/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.node.property;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ChangeDigitalAccessUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(ChangeDigitalAccessUpgradePlugin.class);
    private static final String[] EXO_DIGITAL_PATH_ALIAS = new String[]{"digitalVideoPath", "digitalAudioPath", "digitalAssetsPath", "digitalPicturePath"};
    private RepositoryService repoService;
    private NodeHierarchyCreator nodeHierarchyCreator;

    public ChangeDigitalAccessUpgradePlugin(InitParams initParams, RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator, UserACL userAcl) {
        super(initParams);
        this.repoService = repoService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Processing update setProperty permission for users has addNode permission...");
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            String ws = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Session session = sessionProvider.getSession(ws, this.repoService.getCurrentRepository());
            for (String digitalNodePath : EXO_DIGITAL_PATH_ALIAS) {
                String exoDigitalNodePath = this.nodeHierarchyCreator.getJcrPath(digitalNodePath);
                Node exoDigital = (Node)session.getItem(exoDigitalNodePath);
                this.setPermission(exoDigital);
            }
            LOG.info((Object)"Product info node upgraded successfully!");
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private void setPermission(Node node) {
        block4: {
            ExtendedNode extendedNode = (ExtendedNode)node;
            String nodeName = "";
            try {
                nodeName = extendedNode.getName();
                String[] permissions = new String[]{"read", "add_node", "set_property"};
                extendedNode.setPermission("*:/platform/users", permissions);
                extendedNode.save();
            }
            catch (RepositoryException ex) {
                LOG.info((Object)("" + nodeName + " has been error while update permission!"));
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)ex.getMessage());
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)ex.getMessage());
            }
        }
    }
}

