/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.nodetypes;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class RestoreLocationNodeTypeUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String EXO_RESTORE_LOCATION = "exo:restoreLocation";
    public static final String TRASH_ID = "exo:trashId";

    public void processUpgrade(String oldVersion, String newVersion) {
        block3: {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Migrating exo:restoreLocation starting.............");
            }
            try {
                ExtendedNodeTypeManager nodeTypeManager = WCMCoreUtils.getRepository().getNodeTypeManager();
                NodeTypeValue nodeTypeValue = nodeTypeManager.getNodeTypeValue(EXO_RESTORE_LOCATION);
                List propValues = nodeTypeValue.getDeclaredPropertyDefinitionValues();
                propValues.add(new PropertyDefinitionValue(TRASH_ID, false, false, 1, false, new ArrayList(), false, 1, new ArrayList()));
                nodeTypeValue.setDeclaredPropertyDefinitionValues(propValues);
                nodeTypeManager.registerNodeType(nodeTypeValue, 4);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)"An unexpected error occurs when migrating exo:restoreLocation node type", (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    public RestoreLocationNodeTypeUpgradePlugin(InitParams initParams) {
        super(initParams);
    }
}

