/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.permission.PermissionBean;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeInfo;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={NextAddActionActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={PreviousActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectUserActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectMemberActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddAnyActionListener.class})})
public class UIPermissionTreeForm
extends UIForm
implements UISelectable {
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "TaxoTreeSelectUserOrGroupPopup";
    public static final String SELECT_GROUP_ID = "TaxoTreeSelectUserOrGroup";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIPermissionTreeForm");
    private Node currentNode;
    private PermissionBean permBean;

    public UIPermissionTreeForm() throws Exception {
        this.addChild((UIComponent)new UIPermissionInputSet(PERMISSION));
        this.setActions(new String[]{"Previous", "Save", "Reset", "NextAddAction"});
    }

    private void refresh() {
        this.reset();
        this.checkAll(false);
    }

    private void checkAll(boolean check) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setChecked(check);
        }
    }

    protected boolean isEditable(Node node) throws Exception {
        return PermissionUtil.canChangePermission((Node)node);
    }

    public void fillForm(String user, ExtendedNode node) throws Exception {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        this.refresh();
        uiInputSet.getUIStringInput("userOrGroup").setValue((Object)user);
        if (node != null) {
            if (user.equals(Utils.getNodeOwner((Node)node))) {
                for (String perm : PermissionType.ALL) {
                    uiInputSet.getUIFormCheckBoxInput(perm).setChecked(true);
                }
            } else {
                List permsList = node.getACL().getPermissionEntries();
                Iterator perIter = permsList.iterator();
                StringBuilder userPermission = new StringBuilder();
                while (perIter.hasNext()) {
                    AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                    if (!user.equals(accessControlEntry.getIdentity())) continue;
                    userPermission.append(accessControlEntry.getPermission()).append(" ");
                }
                for (String perm : PermissionType.ALL) {
                    boolean isCheck = userPermission.toString().contains(perm);
                    uiInputSet.getUIFormCheckBoxInput(perm).setChecked(isCheck);
                }
            }
        } else {
            UIPermissionTreeInfo uiInfo = (UIPermissionTreeInfo)((UIContainer)this.getParent()).getChild(UIPermissionTreeInfo.class);
            for (PermissionBean permBeanTemp : uiInfo.getPermBeans()) {
                if (!permBeanTemp.getUsersOrGroups().equals(user)) continue;
                this.getUIFormCheckBoxInput("read").setValue((Object)permBeanTemp.isRead());
                this.getUIFormCheckBoxInput("add_node").setValue((Object)permBeanTemp.isAddNode());
                this.getUIFormCheckBoxInput("remove").setValue((Object)permBeanTemp.isRemove());
                this.getUIFormCheckBoxInput("set_property").setValue((Object)permBeanTemp.isSetProperty());
                break;
            }
        }
    }

    protected void lockForm(boolean isLock) {
        UIPermissionInputSet uiInputSet = (UIPermissionInputSet)this.getChildById(PERMISSION);
        if (isLock) {
            this.setActions(new String[]{"Previous", "Reset", "NextAddAction"});
            uiInputSet.setActionInfo("userOrGroup", null);
        } else {
            this.setActions(new String[]{"Previous", "Save", "Reset", "NextAddAction"});
            uiInputSet.setActionInfo("userOrGroup", new String[]{"SelectUser", "SelectMember", "AddAny"});
        }
        for (String perm : PermissionType.ALL) {
            uiInputSet.getUIFormCheckBoxInput(perm).setEnable(!isLock);
        }
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    public PermissionBean getPermBean() {
        return this.permBean;
    }

    public void setPermBean(PermissionBean permBean) {
        this.permBean = permBean;
    }

    public void doSelect(String selectField, Object value) {
        try {
            ExtendedNode node = (ExtendedNode)this.getCurrentNode();
            this.checkAll(false);
            this.fillForm(value.toString(), node);
            this.lockForm(value.toString().equals(this.getExoOwner((Node)node)));
            this.getUIStringInput(selectField).setValue((Object)value.toString());
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    static /* synthetic */ void access$000(UIPermissionTreeForm x0) {
        x0.refresh();
    }

    static /* synthetic */ void access$100(UIPermissionTreeForm x0, boolean x1) {
        x0.checkAll(x1);
    }
}

