/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveForm;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveInputSet;
import org.exoplatform.ecm.webui.component.admin.drives.UIDriveManager;
import org.exoplatform.ecm.webui.component.admin.drives.UIViewsInputSet;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemovePermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddIconActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDriveForm
extends UIFormTabPane
implements UISelectable {
    private boolean isAddNew_ = true;
    public static final String[] ACTIONS = new String[]{"Save", "Refresh", "Cancel"};
    public static final String POPUP_DRIVEPERMISSION = "PopupDrivePermission";
    private String membershipString = "";

    public UIDriveForm() throws Exception {
        super("UIDriveForm");
        UIDriveInputSet driveInputSet = new UIDriveInputSet("DriveInputSet");
        UIFormSelectBox selectBox = (UIFormSelectBox)driveInputSet.getChildById("workspace");
        selectBox.setOnChange("Change");
        this.addUIFormInput((UIFormInputSet)driveInputSet);
        this.setSelectedTab(driveInputSet.getId());
        UIViewsInputSet viewInputSet = new UIViewsInputSet("ViewsInputSet");
        this.addUIFormInput((UIFormInputSet)viewInputSet);
        this.setActions(ACTIONS);
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIDriveForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return id;
        }
    }

    public void doSelect(String selectField, Object value) {
        UIFormStringInput uiStringInput = this.getUIStringInput(selectField);
        if (selectField.equals("permissions")) {
            String membership = value.toString();
            String valuePermissions = (String)uiStringInput.getValue();
            if (membership != null && valuePermissions.indexOf(membership) < 0) {
                valuePermissions = valuePermissions.length() > 0 ? valuePermissions + "," + membership : valuePermissions + membership;
            }
            uiStringInput.setValue((Object)valuePermissions);
        } else {
            uiStringInput.setValue((Object)value.toString());
        }
        UIDriveManager uiContainer = (UIDriveManager)this.getAncestorOfType(UIDriveManager.class);
        for (UIComponent uiChild : uiContainer.getChildren()) {
            if (!uiChild.getId().equals(POPUP_DRIVEPERMISSION) && !uiChild.getId().equals("JCRBrowser") && !uiChild.getId().equals("JCRBrowserAssets")) continue;
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById(uiChild.getId());
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    public void refresh(String driveName) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        DriveData drive = null;
        if (driveName == null) {
            this.isAddNew_ = true;
        } else {
            this.isAddNew_ = false;
            this.setActions(new String[]{"Save", "Cancel"});
            drive = ((ManageDriveService)this.getApplicationComponent(ManageDriveService.class)).getDriveByName(driveName, repository);
        }
        ((UIDriveInputSet)this.getChild(UIDriveInputSet.class)).update(drive);
        ((UIViewsInputSet)this.getChild(UIViewsInputSet.class)).update(drive);
    }

    public String getWorkspaceEntries(String selectedWorkspace, String repository) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ArrayList wsEntries = repositoryService.getRepository(repository).getConfiguration().getWorkspaceEntries();
        String wsInitRootNodeType = null;
        for (WorkspaceEntry wsEntry : wsEntries) {
            if (!wsEntry.getName().equals(selectedWorkspace)) continue;
            wsInitRootNodeType = wsEntry.getAutoInitializedRootNt();
            break;
        }
        return wsInitRootNodeType;
    }

    static /* synthetic */ boolean access$000(UIDriveForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ String access$100(UIDriveForm x0) {
        return x0.membershipString;
    }

    static /* synthetic */ String access$184(UIDriveForm x0, Object x1) {
        x0.membershipString = x0.membershipString + x1;
        return x0.membershipString;
    }

    static /* synthetic */ String access$102(UIDriveForm x0, String x1) {
        x0.membershipString = x1;
        return x0.membershipString;
    }
}

