/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.VersionHistory;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.templates.UIDialogTab;
import org.exoplatform.ecm.webui.component.admin.templates.UISkinTab;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateContent;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTab;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RefreshActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPermissionActionListener.class})})
public class UITemplateContent
extends UIForm
implements UISelectable {
    public static final String FIELD_SELECT_VERSION = "selectVersion";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VIEWPERMISSION = "viewPermission";
    public static final String FIELD_ENABLE_VERSION = "enableVersion";
    public static final String[] REG_EXPRESSION = new String[]{"[", "]", ":", "&", "%"};
    private boolean isAddNew_ = true;
    private String nodeTypeName_;
    private List<String> listVersion_ = new ArrayList();
    private String templateType;
    public static final String TEMPLATE_PERMISSION = "TemplatePermission";

    public UITemplateContent() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_SELECT_VERSION, FIELD_SELECT_VERSION, options);
        versions.setOnChange("Change");
        versions.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormCheckBoxInput isVersion = new UIFormCheckBoxInput(FIELD_ENABLE_VERSION, FIELD_ENABLE_VERSION, null);
        isVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)isVersion);
        UIFormInputSetWithAction uiActionTab = new UIFormInputSetWithAction("UITemplateContent");
        uiActionTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_VIEWPERMISSION, FIELD_VIEWPERMISSION, null).setEditable(false).addValidator(MandatoryValidator.class, new Object[0]));
        uiActionTab.setActionInfo(FIELD_VIEWPERMISSION, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)uiActionTab);
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setNodeTypeName(String nodeType) {
        this.nodeTypeName_ = nodeType;
    }

    public void update(String templateName) throws Exception {
        if (templateName != null) {
            this.isAddNew_ = false;
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String repository = this.getRepository();
            String templateContent = templateService.getTemplate(this.templateType, this.nodeTypeName_, templateName, repository);
            Node template = templateService.getTemplateNode(this.templateType, this.nodeTypeName_, templateName, repository, SessionProviderFactory.createSystemProvider());
            this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(true);
            String templateRole = templateService.getTemplateRoles(this.templateType, this.nodeTypeName_, templateName, repository);
            boolean isVersioned = template.isNodeType("mix:versionable");
            if (isVersioned) {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(true);
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setOptions(this.getVersionValues(template));
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setValue(template.getBaseVersion().getName());
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(true);
                this.setActions(new String[]{"Save", "Restore", "Refresh", "Cancel"});
            } else {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(true);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
                this.setActions(new String[]{"Save", "Refresh", "Cancel"});
            }
            String content = Utils.encodeHTML((String)templateContent);
            this.getUIFormTextAreaInput(FIELD_CONTENT).setValue((Object)content);
            this.getUIStringInput(FIELD_NAME).setValue((Object)template.getName());
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            this.getUIStringInput(FIELD_VIEWPERMISSION).setValue((Object)templateRole);
            return;
        }
        this.isAddNew_ = true;
        this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
        this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(false);
        this.getUIStringInput(FIELD_NAME).setEditable(true);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    private void refresh() throws Exception {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.refresh();
        UIComponent parent = this.getParent();
        if (parent instanceof UIDialogTab) {
            uiViewTemplate.setRenderedChild(UIDialogTab.class);
        } else if (parent instanceof UIViewTab) {
            uiViewTemplate.setRenderedChild(UIViewTab.class);
        } else if (parent instanceof UISkinTab) {
            uiViewTemplate.setRenderedChild(UISkinTab.class);
        }
        this.update(null);
        this.reset();
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        if (vH != null) {
            return new VersionNode(vH.getRootVersion(), node.getSession());
        }
        return null;
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List child = new ArrayList();
        for (VersionNode version : children) {
            this.listVersion_.add(version.getName());
            child = version.getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion_;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion_.clear();
        List versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt((String)versionList.get(j)) >= Integer.parseInt((String)versionList.get(i))) continue;
                String temp = (String)versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption((String)versionList.get(i), versionList.get(i)));
        }
        return options;
    }

    public void doSelect(String selectField, Object value) {
        String viewPermission = (String)this.getUIStringInput(FIELD_VIEWPERMISSION).getValue();
        viewPermission = viewPermission != null && viewPermission.length() == 0 ? value.toString() : viewPermission + "," + value.toString();
        this.getUIStringInput(FIELD_VIEWPERMISSION).setValue((Object)viewPermission);
        UITemplatesManager uiManager = (UITemplatesManager)this.getAncestorOfType(UITemplatesManager.class);
        uiManager.removeChildById(this.getId() + TEMPLATE_PERMISSION);
    }

    private String getRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }

    static /* synthetic */ String access$000(UITemplateContent x0) {
        return x0.nodeTypeName_;
    }

    static /* synthetic */ String access$100(UITemplateContent x0) {
        return x0.getRepository();
    }

    static /* synthetic */ void access$200(UITemplateContent x0) throws Exception {
        x0.refresh();
    }

    static /* synthetic */ boolean access$300(UITemplateContent x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ boolean access$302(UITemplateContent x0, boolean x1) {
        x0.isAddNew_ = x1;
        return x0.isAddNew_;
    }

    static /* synthetic */ VersionNode access$400(UITemplateContent x0, Node x1) throws Exception {
        return x0.getRootVersion(x1);
    }
}

