/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UITabForm
extends UIFormInputSetWithAction {
    public static final String FIELD_NAME = "tabName";
    private List<?> buttons_;

    public UITabForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        ManageViewService vservice_ = (ManageViewService)this.getApplicationComponent(ManageViewService.class);
        this.buttons_ = vservice_.getButtons();
        for (Object bt : this.buttons_) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(this.getButtonName(bt), "", null));
        }
        this.setActions(new String[]{"AddTab", "Reset", "BackViewForm"}, null);
    }

    private String getButtonName(Object bt) {
        String button = (String)bt;
        return button.substring(0, 1).toLowerCase() + button.substring(1);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public void refresh(boolean isEditable) throws Exception {
        this.getUIStringInput(FIELD_NAME).setEditable(isEditable).setValue(null);
        for (Object bt : this.buttons_) {
            this.getUIFormCheckBoxInput(this.getButtonName(bt)).setChecked(false).setEditable(isEditable);
        }
        if (isEditable) {
            this.setActions(new String[]{"AddTab", "Reset", "BackViewForm"}, null);
        }
    }

    public void update(ViewConfig.Tab tab, boolean isView) throws Exception {
        String[] buttonArray;
        this.refresh(!isView);
        if (tab == null) {
            return;
        }
        this.getUIStringInput(FIELD_NAME).setEditable(false).setValue((Object)tab.getTabName());
        String buttonsProperty = tab.getButtons();
        for (String bt : buttonArray = StringUtils.split((String)buttonsProperty, (String)";")) {
            UIFormCheckBoxInput cbInput = this.getUIFormCheckBoxInput(bt.trim());
            if (cbInput == null) continue;
            cbInput.setChecked(true);
        }
    }

    static /* synthetic */ List access$000(UITabForm x0) {
        return x0.buttons_;
    }

    static /* synthetic */ String access$100(UITabForm x0, Object x1) {
        return x0.getButtonName(x1);
    }
}

