/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.permission.PermissionBean;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeInfo;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPermissionTreeInfo.msg.confirm-delete-permission"), @EventConfig(listeners={EditActionListener.class})})
public class UIPermissionTreeInfo
extends UIContainer {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups", "read", "addNode", "setProperty", "remove"};
    private static String[] PERMISSION_ACTION = new String[]{"Edit", "Delete"};
    private Node currentNode = null;
    private int sizeOfListPermission = 0;
    private List<PermissionBean> permBeans = new ArrayList();

    public UIPermissionTreeInfo() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIGrid.class, null, "PermissionInfo");
        this.addChild((UIComponent)uiGrid);
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    private String getExoOwner(Node node) throws Exception {
        return Utils.getNodeOwner((Node)node);
    }

    public void updateGrid() throws Exception {
        HashMap permsMap = new HashMap();
        int iSystemOwner = 0;
        PermissionBean anyPermBean = new PermissionBean();
        PermissionBean starPermBean = new PermissionBean();
        if (this.currentNode != null) {
            this.permBeans = new ArrayList();
            ExtendedNode node = (ExtendedNode)this.currentNode;
            List permsList = node.getACL().getPermissionEntries();
            for (AccessControlEntry accessControlEntry : permsList) {
                String currentIdentity = accessControlEntry.getIdentity();
                String currentPermission = accessControlEntry.getPermission();
                ArrayList<String> currentPermissionsList = (ArrayList<String>)permsMap.get(currentIdentity);
                if (!permsMap.containsKey(currentIdentity)) {
                    permsMap.put(currentIdentity, null);
                }
                if (currentPermissionsList == null) {
                    currentPermissionsList = new ArrayList<String>();
                }
                if (!currentPermissionsList.contains(currentPermission)) {
                    currentPermissionsList.add(currentPermission);
                }
                permsMap.put(currentIdentity, currentPermissionsList);
            }
            Set keys = permsMap.keySet();
            Iterator keysIter = keys.iterator();
            String owner = SystemIdentity.SYSTEM;
            if (this.getExoOwner((Node)node) != null) {
                owner = this.getExoOwner((Node)node);
            }
            if (owner.equals(SystemIdentity.SYSTEM)) {
                iSystemOwner = -1;
            }
            PermissionBean permOwnerBean = new PermissionBean();
            if (!permsMap.containsKey(owner)) {
                permOwnerBean.setUsersOrGroups(owner);
                permOwnerBean.setRead(true);
                permOwnerBean.setAddNode(true);
                permOwnerBean.setSetProperty(true);
                permOwnerBean.setRemove(true);
                this.permBeans.add(permOwnerBean);
            }
            while (keysIter.hasNext()) {
                String userOrGroup = (String)keysIter.next();
                List permissions = (List)permsMap.get(userOrGroup);
                PermissionBean permBean = new PermissionBean();
                permBean.setUsersOrGroups(userOrGroup);
                for (String perm : permissions) {
                    if ("read".equals(perm)) {
                        permBean.setRead(true);
                        continue;
                    }
                    if ("add_node".equals(perm)) {
                        permBean.setAddNode(true);
                        continue;
                    }
                    if ("set_property".equals(perm)) {
                        permBean.setSetProperty(true);
                        continue;
                    }
                    if (!"remove".equals(perm)) continue;
                    permBean.setRemove(true);
                }
                if (userOrGroup.equals("*")) {
                    starPermBean = permBean;
                }
                if (userOrGroup.equals("any")) {
                    anyPermBean = permBean;
                }
                this.permBeans.add(permBean);
            }
            PermissionBean asPermBean = new PermissionBean();
            if (starPermBean.getUsersOrGroups() != null && anyPermBean.getUsersOrGroups() != null) {
                asPermBean.setUsersOrGroups("*");
                if (starPermBean.isRead() || anyPermBean.isRead()) {
                    asPermBean.setRead(true);
                } else {
                    asPermBean.setRead(false);
                }
                if (starPermBean.isAddNode() || anyPermBean.isAddNode()) {
                    asPermBean.setAddNode(true);
                } else {
                    asPermBean.setAddNode(false);
                }
                if (starPermBean.isSetProperty() || anyPermBean.isSetProperty()) {
                    asPermBean.setSetProperty(true);
                } else {
                    asPermBean.setSetProperty(false);
                }
                if (starPermBean.isRemove() || anyPermBean.isRemove()) {
                    asPermBean.setRemove(true);
                } else {
                    asPermBean.setRemove(false);
                }
            } else if (starPermBean.getUsersOrGroups() == null && anyPermBean.getUsersOrGroups() != null) {
                asPermBean = anyPermBean;
                asPermBean.setUsersOrGroups("*");
            } else if (anyPermBean.getUsersOrGroups() == null && starPermBean.getUsersOrGroups() != null) {
                asPermBean = starPermBean;
                asPermBean.setUsersOrGroups("*");
            } else {
                asPermBean = null;
            }
            if (starPermBean.getUsersOrGroups() != null && this.permBeans != null) {
                this.permBeans.remove(starPermBean);
            }
            if (anyPermBean.getUsersOrGroups() != null && this.permBeans != null) {
                this.permBeans.remove(anyPermBean);
            }
            if (asPermBean != null && !this.permBeans.contains(asPermBean)) {
                this.permBeans.add(asPermBean);
            }
        } else {
            UIPermissionTreeForm uiForm = (UIPermissionTreeForm)((UIContainer)this.getParent()).getChild(UIPermissionTreeForm.class);
            PermissionBean permBean = uiForm.getPermBean();
            if (permBean != null) {
                for (PermissionBean permBeanTemp : this.permBeans) {
                    if (!permBeanTemp.equals((Object)permBean)) continue;
                    permBeanTemp.setAddNode(permBean.isAddNode());
                    permBeanTemp.setRead(permBean.isRead());
                    permBeanTemp.setRemove(permBean.isRemove());
                    permBeanTemp.setSetProperty(permBean.isSetProperty());
                }
                if (!this.permBeans.contains(permBean)) {
                    this.permBeans.add(permBean);
                }
                uiForm.setPermBean(null);
            }
        }
        this.sizeOfListPermission = this.permBeans.size() + iSystemOwner;
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        ObjectPageList objPageList = new ObjectPageList(this.permBeans, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    public int getSizeOfListPermission() {
        return this.sizeOfListPermission;
    }

    public void setSizeOfListPermission(int sizeOfListPermission) {
        this.sizeOfListPermission = sizeOfListPermission;
    }

    public List<PermissionBean> getPermBeans() {
        return this.permBeans;
    }

    public void setPermBeans(List<PermissionBean> permBeans) {
        this.permBeans = permBeans;
    }

    static /* synthetic */ String access$000(UIPermissionTreeInfo x0, Node x1) throws Exception {
        return x0.getExoOwner(x1);
    }
}

