/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(lifecycle=Lifecycle.class)
public class UIPresentation
extends UIBaseNodePresentation {
    private NodeLocation originalNodeLocation;
    private NodeLocation viewNodeLocation;

    public Node getOriginalNode() throws Exception {
        return Utils.getViewableNodeByComposer((String)this.originalNodeLocation.getRepository(), (String)this.originalNodeLocation.getWorkspace(), (String)this.originalNodeLocation.getPath(), (String)"base");
    }

    public void setOriginalNode(Node node) throws Exception {
        this.originalNodeLocation = NodeLocation.make((Node)node);
    }

    public Node getNode() throws Exception {
        return Utils.getViewableNodeByComposer((String)this.viewNodeLocation.getRepository(), (String)this.viewNodeLocation.getWorkspace(), (String)this.viewNodeLocation.getPath());
    }

    public void setNode(Node node) {
        this.viewNodeLocation = NodeLocation.make((Node)node);
    }

    public String getRepositoryName() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        return this.originalNodeLocation != null ? this.originalNodeLocation.getRepository() : portletPreferences.getValue(UISingleContentViewerPortlet.REPOSITORY, "repository");
    }

    public String getTemplate() {
        try {
            return this.getTemplatePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTemplatePath() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePath(this.getOriginalNode(), false);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        String repository = this.getRepositoryName();
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(repository).getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, "exo:templateFile");
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public UIComponent getCommentComponent() {
        return null;
    }

    public UIComponent getRemoveAttach() throws Exception {
        return null;
    }

    public UIComponent getRemoveComment() throws Exception {
        return null;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }
}

