/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.Date;
import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderResponse;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISCVPreferences;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.w3c.dom.Element;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/SingleContentViewer/UISingleContentView.gtmpl")
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    public static String DRIVE = "nodeDrive";
    public static String PARAMETER = "ParameterName";
    public static String SHOW_DATE = "ShowDate";
    public static String SHOW_TITLE = "ShowTitle";
    public static String SHOW_OPTIONBAR = "ShowOptionBar";
    public static String CONTEXTUAL_MODE = "ContextEnable";
    public static String PRINT_PARAMETER = "PrintParameterName";
    public static String PRINT_PAGE = "PrintPage";
    public static final String PREFERENCE_TARGET_PAGE = "basePath";
    public static final String PREFERENCE_SHOW_SCV_WITH = "showScvWith";
    public static final String DEFAULT_SHOW_SCV_WITH = "content-id";
    private PortletMode mode = null;
    public static final String UIPreferencesPopupID = "UIPreferencesPopupWindows";
    private UISCVPreferences popPreferences;
    private UIPresentationContainer uiPresentation;
    PortletPreferences preferences;
    private static final Log log = ExoLogger.getLogger(UISingleContentViewerPortlet.class);

    public UISingleContentViewerPortlet() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + new Date().getTime());
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.preferences = portletRequestContext.getRequest().getPreferences();
    }

    public void activateMode(PortletMode newMode) throws Exception {
        if (this.getChild(UIPresentationContainer.class) != null) {
            this.removeChild(UIPresentationContainer.class);
        }
        if (this.getChild(UISCVPreferences.class) != null) {
            this.removeChild(UISCVPreferences.class);
        }
        if (PortletMode.VIEW.equals((Object)newMode)) {
            this.uiPresentation = (UIPresentationContainer)this.addChild(UIPresentationContainer.class, null, null);
        } else if (PortletMode.EDIT.equals((Object)newMode)) {
            this.popPreferences = (UISCVPreferences)this.addChild(UISCVPreferences.class, null, null);
            this.popPreferences.setInternalPreferencesMode(true);
        }
    }

    public boolean isViewMode() {
        return Utils.getCurrentMode().equals(PortletMode.VIEW);
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        RenderResponse response;
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (context.getRemoteUser() == null) {
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            pContext.getResponse().setProperty("portlet.expiration-cache", "" + wcmService.getPortletExpirationCache());
            if (log.isTraceEnabled()) {
                log.trace((Object)("SCV rendering : cache set to " + wcmService.getPortletExpirationCache()));
            }
        }
        if (!newMode.equals((Object)this.mode)) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        Node nodeView = null;
        if (this.uiPresentation != null && (nodeView = this.uiPresentation.getNodeView()) != null) {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            ((UIPresentation)this.uiPresentation.getChild(UIPresentation.class)).setTemplatePath(templateService.getTemplatePath(nodeView, false));
        }
        if (this.uiPresentation != null && this.uiPresentation.isContextual() && nodeView != null) {
            response = (RenderResponse)context.getResponse();
            Element title = response.createElement("title");
            title.setTextContent(this.uiPresentation.getTitle(nodeView));
            response.addProperty("javax.portlet.markup.head.element", title);
        }
        response = (RenderResponse)context.getResponse();
        Element elementS = response.createElement("script");
        elementS.setAttribute("type", "text/javascript");
        elementS.setAttribute("src", "/eXoWCMResources/javascript/eXo/wcm/frontoffice/public/jquery-1.5.1.js");
        response.addProperty("javax.portlet.markup.head.element", elementS);
        super.processRender(app, context);
    }

    public void changeToViewMode() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletRequestContext.setApplicationMode(PortletMode.VIEW);
    }

    public Node getNodeByPreference() {
        try {
            String repository = this.preferences.getValue(REPOSITORY, null);
            String workspace = this.preferences.getValue(WORKSPACE, null);
            String nodeIdentifier = this.preferences.getValue(IDENTIFIER, null);
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            return wcmService.getReferencedContent(Utils.getSessionProvider(), repository, workspace, nodeIdentifier);
        }
        catch (Exception e) {
            return null;
        }
    }
}

