/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.wcm.webui.search.UISearchForm;
import org.exoplatform.wcm.webui.search.UISearchPageLayout;
import org.exoplatform.wcm.webui.search.UIWCMSearchPortlet;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UISearchResult
extends UIContainer {
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String keyword;
    private String resultType;
    private String suggestion;
    private String suggestionURL;
    private String pageMode;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private float searchTime;
    private List<ResultNode> moreListResult;
    private Set<Integer> morePageSet;
    public static final String PARAMETER_REGX = "(portal=.*)&(keyword=.*)";
    public static final String RESULT_NOT_FOUND = "UISearchResult.msg.result-not-found";

    public void init(String templatePath, ResourceResolver resourceResolver) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        String paginatorTemplatePath = portletPreferences.getValue(UIWCMSearchPortlet.SEARCH_PAGINATOR_TEMPLATE_PATH, null);
        this.pageMode = portletPreferences.getValue("pageMode", "none");
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageMode(this.pageMode);
        this.clearResult();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        PortletPreferences portletPreferences = porletRequestContext.getRequest().getPreferences();
        if (this.resultType == null || this.resultType.length() == 0) {
            this.resultType = "DocumentAndPage";
        }
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String portal = portalRequestContext.getRequestParameter("portal");
        String keyword = portalRequestContext.getRequestParameter("keyword");
        if (portal != null && keyword != null && keyword.length() > 0) {
            UISearchPageLayout uiSearchPageContainer = (UISearchPageLayout)this.getAncestorOfType(UISearchPageLayout.class);
            UISearchForm searchForm = (UISearchForm)uiSearchPageContainer.getChild(UISearchForm.class);
            searchForm.getUIStringInput(UISearchForm.KEYWORD_INPUT).setValue((Object)keyword);
            if (searchForm.getUIFormSelectBox(UISearchForm.PORTALS_SELECTOR).getValue() != null) {
                portal = (String)searchForm.getUIFormSelectBox(UISearchForm.PORTALS_SELECTOR).getValue();
                String string = portal = portal.equals(UISearchForm.ALL_OPTION) ? Util.getPortalRequestContext().getPortalOwner() : portal;
            }
            if (searchForm.getUIStringInput(UISearchForm.KEYWORD_INPUT).getValue() != null) {
                keyword = (String)searchForm.getUIStringInput(UISearchForm.KEYWORD_INPUT).getValue();
            }
            this.setKeyword(keyword);
            SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
            QueryCriteria queryCriteria = new QueryCriteria();
            boolean isSearchDocument = searchForm.getUIFormCheckBoxInput(UISearchForm.DOCUMENT_CHECKING).isChecked();
            boolean isWebPage = searchForm.getUIFormCheckBoxInput(UISearchForm.PAGE_CHECKING).isChecked();
            String repository = portletPreferences.getValue("repository", null);
            TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
            List documentNodeTypes = templateService.getAllDocumentNodeTypes(repository);
            String pageMode = portletPreferences.getValue("pageMode", "none");
            queryCriteria.setContentTypes(documentNodeTypes.toArray(new String[documentNodeTypes.size()]));
            queryCriteria.setSiteName(portal);
            queryCriteria.setKeyword(keyword.toLowerCase());
            queryCriteria.setSearchWebpage(isWebPage);
            queryCriteria.setSearchDocument(isSearchDocument);
            queryCriteria.setSearchWebContent(isSearchDocument);
            queryCriteria.setPageMode(pageMode);
            if (Boolean.parseBoolean(Utils.getCurrentMode())) {
                queryCriteria.setLiveMode(true);
            } else {
                queryCriteria.setLiveMode(false);
            }
            int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
            try {
                WCMPaginatedQueryResult paginatedQueryResult = siteSearchService.searchSiteContents(Utils.getSessionProvider(), queryCriteria, itemsPerPage, false);
                this.setSearchTime(paginatedQueryResult.getQueryTimeInSecond());
                this.setSuggestion(paginatedQueryResult.getSpellSuggestion());
                String suggestionURL = Util.getPortalRequestContext().getRequestURI();
                suggestionURL = suggestionURL + "?portal=" + portal + "&keyword=" + this.getSuggestion();
                this.setSuggestionURL(suggestionURL);
                this.setPageList((PageList)paginatedQueryResult);
                searchForm.setSubmitAction(suggestionURL);
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage(UISearchForm.MESSAGE_NOT_SUPPORT_KEYWORD, null, 1));
            }
        }
        super.processRender(context);
    }

    public void setPageList(PageList dataPageList) {
        this.uiPaginator.setPageList(dataPageList);
        this.moreListResult = new ArrayList();
        this.morePageSet = new HashSet();
    }

    public int getTotalItem() {
        return this.uiPaginator.getPageList().getAvailable();
    }

    public int getItemsPerPage() {
        return this.uiPaginator.getPageList().getPageSize();
    }

    public int getCurrentPage() {
        return this.uiPaginator.getCurrentPage();
    }

    public String getPageMode() {
        return this.pageMode;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public List<String> getURLs(Node node) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        if (!node.hasProperty("publication:navigationNodeURIs")) {
            urls.add(this.getURL(node));
        } else {
            for (Value value : node.getProperty("publication:navigationNodeURIs").getValues()) {
                urls.add(value.getString());
            }
        }
        return urls;
    }

    public String getPublishedNodeURI(String navNodeURI) {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        PortletRequest portletRequest = this.getPortletRequest();
        String accessMode = null;
        accessMode = portalRequestContext.getAccessPath() == 0 ? "public" : "private";
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        if (navNodeURI.startsWith(baseURI)) {
            return navNodeURI;
        }
        return baseURI + portalRequestContext.getRequestContextPath() + "/" + accessMode + navNodeURI;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        PortletRequest portletRequest = this.getPortletRequest();
        String portalURI = portalRequestContext.getPortalURI();
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String repository = portletPreferences.getValue("repository", null);
        String workspace = portletPreferences.getValue("workspace", null);
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String basePath = portletPreferences.getValue("basePath", null);
        link = baseURI + portalURI + basePath + "/" + repository + "/" + workspace;
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            link = link + originalNode.getPath() + "?version=" + node.getParent().getName();
        } else {
            link = link + node.getPath();
        }
        return link;
    }

    private PortletRequest getPortletRequest() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest();
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public boolean isShowPaginator() throws Exception {
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public float getSearchTime() {
        return this.searchTime;
    }

    public void setSearchTime(float searchTime) {
        this.searchTime = searchTime;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public String getSuggestionURL() {
        return this.suggestionURL;
    }

    public void setSuggestionURL(String suggestionURL) {
        this.suggestionURL = suggestionURL;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public int getNumberOfPage() {
        return this.uiPaginator.getPageList().getAvailablePage();
    }

    public void clearResult() {
        this.moreListResult = new ArrayList();
        this.morePageSet = new HashSet();
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        this.setPageList((PageList)new ObjectPageList(new ArrayList(), Integer.parseInt(itemsPerPage)));
    }

    public List<ResultNode> getRealCurrentPageData() throws Exception {
        int currentPage = this.getCurrentPage();
        if ("more".equals(this.pageMode) && !this.morePageSet.contains(currentPage)) {
            this.morePageSet.add(currentPage);
            this.moreListResult.addAll(this.getCurrentPageData());
        }
        return "more".equals(this.pageMode) ? this.moreListResult : this.getCurrentPageData();
    }
}

