/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.search;

import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.wcm.webui.search.UISearchBox;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SearchActionListener.class})})
public class UISearchBox
extends UIForm {
    private String templatePath;
    public static final String KEYWORD_INPUT = "keywordInput".intern();
    public static final String PORTAL_NAME_PARAM = "portal".intern();
    public static final String KEYWORD_PARAM = "keyword".intern();

    public UISearchBox() throws Exception {
        UIFormStringInput uiKeywordInput = new UIFormStringInput(KEYWORD_INPUT, KEYWORD_INPUT, null);
        this.addChild((UIComponent)uiKeywordInput);
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    private String getRepository() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
        return portletPreferences.getValue("repository", null);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            String repository = this.getRepository();
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
            return new JCRResourceResolver(repository, workspace, "exo:templateFile");
        }
        catch (Exception e) {
            return null;
        }
    }
}

