/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.seo;

import java.util.ArrayList;
import java.util.Enumeration;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.wcm.webui.seo.UISEOToolbarForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/seo/UISEOPortletToolbar.gtmpl", events={@EventConfig(listeners={AddSEOActionListener.class})})
public class UISEOToolbarForm
extends UIForm {
    public static final String SEO_POPUP_WINDOW = "UISEOPopupWindow";
    private static ArrayList<String> paramsArray = null;
    private String pageReference = null;
    PageMetadataModel metaModel = null;
    private String fullStatus = "Empty";

    public void processRender(WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String portalName = pcontext.getPortalOwner();
        this.metaModel = null;
        if (!pcontext.useAjax()) {
            this.fullStatus = "Empty";
            paramsArray = null;
            String contentParam = null;
            Enumeration params = pcontext.getRequest().getParameterNames();
            if (params.hasMoreElements()) {
                paramsArray = new ArrayList();
                while (params.hasMoreElements()) {
                    contentParam = params.nextElement().toString();
                    paramsArray.add(pcontext.getRequestParameter(contentParam));
                }
            }
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
        this.pageReference = Util.getUIPortal().getSelectedUserNode().getPageRef();
        if (this.pageReference != null) {
            SiteKey siteKey = Util.getUIPortal().getSelectedUserNode().getNavigation().getKey();
            SiteKey portalKey = SiteKey.portal((String)portalName);
            if (siteKey != null && siteKey.equals((Object)portalKey)) {
                this.metaModel = seoService.getPageMetadata(this.pageReference);
                if (paramsArray != null) {
                    PageMetadataModel tmpModel = seoService.getContentMetadata(paramsArray);
                    if (tmpModel != null) {
                        this.metaModel = tmpModel;
                    } else {
                        for (int i = 0; i < paramsArray.size(); ++i) {
                            if (seoService.getContentNode(((String)paramsArray.get(i)).toString()) == null) continue;
                            this.metaModel = null;
                            break;
                        }
                    }
                }
            } else {
                this.fullStatus = "Disabled";
            }
        }
        if (this.metaModel != null) {
            this.fullStatus = this.metaModel.getFullStatus();
        }
        super.processRender(context);
    }

    public String getFullStatus() {
        return this.fullStatus;
    }

    static /* synthetic */ ArrayList access$000() {
        return paramsArray;
    }
}

