/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.LockData;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.jdbc.LockJDBCContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockJDBCConnection {
    private final Log LOG = ExoLogger.getLogger(LockJDBCContainer.class);
    protected String ADD_LOCK_DATA;
    protected String REMOVE_LOCK_DATA;
    protected String REFRESH_LOCK_DATA;
    protected String GET_LOCKED_NODES;
    protected String GET_LOCK_DATA;
    protected String IS_LOCK_DATA_EXIST;
    protected static String COLUMN_WS_NAME = "WS_NAME";
    protected static String COLUMN_NODE_ID = "NODE_ID";
    protected static String COLUMN_TOKEN_HASH = "TOKEN_HASH";
    protected static String COLUMN_OWNER = "OWNER";
    protected static String COLUMN_IS_SESSIONSCOPED = "IS_SESSIONSCOPED";
    protected static String COLUMN_IS_DEEP = "IS_DEEP";
    protected static String COLUMN_BIRTHDAY = "BIRTHDAY";
    protected static String COLUMN_TIMEOUT = "TIMEOUT";
    private PreparedStatement insertLockData;
    private PreparedStatement removeLockData;
    private PreparedStatement refreshLockData;
    private PreparedStatement getLockedNodes;
    private PreparedStatement getLockData;
    private PreparedStatement isLockDataExist;
    private Connection dbConnection;
    private String wsName;

    public LockJDBCConnection(Connection dbConnection, String wsName) throws SQLException {
        this.dbConnection = dbConnection;
        if (dbConnection.getAutoCommit()) {
            dbConnection.setAutoCommit(false);
        }
        this.wsName = wsName;
        this.ADD_LOCK_DATA = "insert into JCR_LOCKS(WS_NAME, NODE_ID, TOKEN_HASH, OWNER, IS_SESSIONSCOPED, IS_DEEP, BIRTHDAY, TIMEOUT) VALUES(?,?,?,?,?,?,?,?)";
        this.REMOVE_LOCK_DATA = "delete from JCR_LOCKS where NODE_ID=? and WS_NAME=?";
        this.REFRESH_LOCK_DATA = "update JCR_LOCKS set BIRTHDAY=? where NODE_ID=? and WS_NAME=?";
        this.GET_LOCKED_NODES = "select NODE_ID from JCR_LOCKS where WS_NAME=?";
        this.GET_LOCK_DATA = "select * from JCR_LOCKS where NODE_ID=? and WS_NAME=?";
        this.IS_LOCK_DATA_EXIST = "select NODE_ID from JCR_LOCKS where NODE_ID=? and WS_NAME=?";
    }

    public int addLockData(LockData data) throws RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (this.insertLockData == null) {
                this.insertLockData = this.dbConnection.prepareStatement(this.ADD_LOCK_DATA);
            } else {
                this.insertLockData.clearParameters();
            }
            this.insertLockData.setString(1, this.wsName);
            this.insertLockData.setString(2, data.getNodeIdentifier());
            this.insertLockData.setString(3, data.getTokenHash());
            this.insertLockData.setString(4, data.getOwner());
            this.insertLockData.setBoolean(5, data.isSessionScoped());
            this.insertLockData.setBoolean(6, data.isDeep());
            this.insertLockData.setLong(7, data.getBirthDay());
            this.insertLockData.setLong(8, data.getTimeOut());
            return this.insertLockData.executeUpdate();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public int removeLockData(String nodeID) throws RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (this.removeLockData == null) {
                this.removeLockData = this.dbConnection.prepareStatement(this.REMOVE_LOCK_DATA);
            } else {
                this.removeLockData.clearParameters();
            }
            this.removeLockData.setString(1, nodeID);
            this.removeLockData.setString(2, this.wsName);
            return this.removeLockData.executeUpdate();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public int refreshLockData(LockData data) throws RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (this.refreshLockData == null) {
                this.refreshLockData = this.dbConnection.prepareStatement(this.REFRESH_LOCK_DATA);
            } else {
                this.refreshLockData.clearParameters();
            }
            this.refreshLockData.setLong(1, data.getBirthDay());
            this.refreshLockData.setString(2, data.getNodeIdentifier());
            this.refreshLockData.setString(3, this.wsName);
            return this.refreshLockData.executeUpdate();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Set<String> getLockedNodes() throws RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (this.getLockedNodes == null) {
                this.getLockedNodes = this.dbConnection.prepareStatement(this.GET_LOCKED_NODES);
            } else {
                this.getLockedNodes.clearParameters();
            }
            this.getLockedNodes.setString(1, this.wsName);
            ResultSet result = this.getLockedNodes.executeQuery();
            HashSet<String> identifiers = new HashSet<String>();
            while (result.next()) {
                identifiers.add(new String(result.getString(COLUMN_NODE_ID)));
            }
            return identifiers;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public LockData getLockData(String identifier) throws RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (this.getLockData == null) {
                this.getLockData = this.dbConnection.prepareStatement(this.GET_LOCK_DATA);
            } else {
                this.getLockData.clearParameters();
            }
            this.getLockData.setString(1, identifier);
            this.getLockData.setString(2, this.wsName);
            ResultSet result = this.getLockData.executeQuery();
            if (result.next()) {
                return new LockData(result.getString(COLUMN_NODE_ID), result.getString(COLUMN_TOKEN_HASH), result.getBoolean(COLUMN_IS_DEEP), result.getBoolean(COLUMN_IS_SESSIONSCOPED), result.getString(COLUMN_OWNER), result.getLong(COLUMN_TIMEOUT), result.getLong(COLUMN_BIRTHDAY));
            }
            return null;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isLockDataExist(String identifier) throws RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (this.isLockDataExist == null) {
                this.isLockDataExist = this.dbConnection.prepareStatement(this.IS_LOCK_DATA_EXIST);
            } else {
                this.isLockDataExist.clearParameters();
            }
            this.isLockDataExist.setString(1, identifier);
            this.isLockDataExist.setString(2, this.wsName);
            ResultSet result = this.isLockDataExist.executeQuery();
            return result.next();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isOpened() {
        try {
            return !this.dbConnection.isClosed();
        }
        catch (SQLException e) {
            this.LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public final void close() throws IllegalStateException, RepositoryException {
        if (this.isOpened()) {
            try {
                this.dbConnection.close();
            }
            catch (SQLException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    public final void commit() throws IllegalStateException, RepositoryException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
        try {
            if (!this.dbConnection.isReadOnly()) {
                this.dbConnection.commit();
            }
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

