/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomainMBean;
import org.jboss.management.j2ee.J2EEManagedObject;

public class J2EEDomain
extends J2EEManagedObject
implements J2EEDomainMBean {
    private static String domainName = null;
    private List serverNames = new ArrayList();

    public static String getDomainName() {
        return domainName;
    }

    public static ObjectName getDomainServerName(MBeanServer mbeanServer) {
        ObjectName domainServer = null;
        try {
            ObjectName serverQuery = new ObjectName(domainName + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*");
            Set<ObjectName> servers = mbeanServer.queryNames(serverQuery, null);
            if (!servers.isEmpty()) {
                domainServer = servers.iterator().next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return domainServer;
    }

    public J2EEDomain(String domainName) throws MalformedObjectNameException, InvalidParentException {
        super(domainName, "J2EEDomain", domainName);
        J2EEDomain.domainName = domainName;
    }

    public String[] getservers() {
        String[] servers = new String[this.serverNames.size()];
        this.serverNames.toArray(servers);
        return servers;
    }

    public String getserver(int pIndex) {
        if (pIndex >= 0 && pIndex < this.serverNames.size()) {
            return (String)this.serverNames.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEServer".equals(lType)) {
            this.serverNames.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEServer".equals(lType)) {
            this.serverNames.remove(pChild.getCanonicalName());
        }
    }

    public String toString() {
        return "J2EEDomain { " + super.toString() + " } [ " + ", servers: " + this.serverNames + " ]";
    }
}

