/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.io.IOUtils;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/wcmGadget/")
public class GadgetConnector
implements ResourceContainer {
    public static final String FCK_RESOURCE_BUNDLE_FILE = "locale.services.fckeditor.FCKConnector".intern();
    private ApplicationRegistryService applicationRegistryService = (ApplicationRegistryService)WCMCoreUtils.getService(ApplicationRegistryService.class);
    private GadgetRegistryService gadgetRegistryService = (GadgetRegistryService)WCMCoreUtils.getService(GadgetRegistryService.class);
    private String internalServerPath;
    private static Log log = ExoLogger.getLogger(GadgetConnector.class);

    public GadgetConnector(InitParams initParams) {
        this.readServerConfig(initParams);
    }

    private void readServerConfig(InitParams initParams) {
        PropertiesParam propertiesParam = initParams.getPropertiesParam("server.config");
        String scheme = propertiesParam.getProperty("scheme");
        String hostName = propertiesParam.getProperty("hostName");
        String port = propertiesParam.getProperty("port");
        StringBuilder builder = new StringBuilder();
        builder.append(scheme).append("://").append(hostName).append(":").append(port);
        this.internalServerPath = builder.toString();
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentFolder") String language) throws Exception {
        try {
            Response response = this.buildXMLResponse(currentFolder, language);
            if (response != null) {
                return response;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getFoldersAndFiles: ", e.fillInStackTrace());
        }
        return Response.ok().build();
    }

    public Response buildXMLResponse(String currentFolder, String language) throws Exception {
        List<ApplicationCategory> applicationCategories = this.getGadgetCategories();
        Element rootElement = this.createRootElement(currentFolder, applicationCategories, language);
        Document document = rootElement.getOwnerDocument();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
    }

    private Element createRootElement(String currentFolder, List<ApplicationCategory> applicationCategories, String language) throws Exception {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        if (applicationCategories.isEmpty()) {
            Locale locale = null;
            locale = language == null ? Locale.ENGLISH : new Locale(language);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(FCK_RESOURCE_BUNDLE_FILE, locale);
            String message = "";
            try {
                message = resourceBundle.getString("fckeditor.no-gadget");
            }
            catch (MissingResourceException e) {
                message = "fckeditor.no-gadget";
            }
            Element rootElement = document.createElement("Message");
            document.appendChild(rootElement);
            rootElement.setAttribute("number", "555");
            rootElement.setAttribute("text", message);
            rootElement.setAttribute("type", "Error");
            return rootElement;
        }
        Element rootElement = document.createElement("Connector");
        document.appendChild(rootElement);
        rootElement.setAttribute("resourceType", "Gadget");
        Element currentFolderElement = document.createElement("CurrentFolder");
        if (currentFolder == null || currentFolder.equals("/")) {
            currentFolderElement.setAttribute("name", applicationCategories.get(0).getName());
            Element foldersElement = this.createFolderElement(document, applicationCategories);
            rootElement.appendChild(foldersElement);
        } else {
            ApplicationCategory applicationCategory = this.applicationRegistryService.getApplicationCategory(currentFolder.substring(1, currentFolder.length() - 1));
            currentFolderElement.setAttribute("name", applicationCategory.getDisplayName());
            Element filesElement = this.createFileElement(document, applicationCategory);
            rootElement.appendChild(filesElement);
        }
        rootElement.appendChild(currentFolderElement);
        return rootElement;
    }

    private Element createFolderElement(Document document, List<ApplicationCategory> applicationCategories) throws Exception {
        Element folders = document.createElement("Folders");
        for (ApplicationCategory applicationCategory : applicationCategories) {
            Element folder = document.createElement("Folder");
            folder.setAttribute("name", applicationCategory.getDisplayName());
            folders.appendChild(folder);
        }
        return folders;
    }

    private Element createFileElement(Document document, ApplicationCategory applicationCategory) throws Exception {
        Element files = document.createElement("Files");
        List listApplication = this.applicationRegistryService.getApplications(applicationCategory, new ApplicationType[]{ApplicationType.GADGET});
        for (Application application : listApplication) {
            Gadget gadget = this.gadgetRegistryService.getGadget(application.getApplicationName());
            Element file = document.createElement("File");
            file.setAttribute("name", gadget.getName());
            file.setAttribute("fileType", "nt_unstructured");
            file.setAttribute("size", "0");
            file.setAttribute("thumbnail", gadget.getThumbnail());
            file.setAttribute("description", gadget.getDescription());
            String fullurl = "";
            fullurl = gadget.isLocal() ? this.internalServerPath + "/rest/" + gadget.getUrl() : gadget.getUrl();
            file.setAttribute("url", fullurl);
            String data = "{\"context\":{\"country\":\"US\",\"language\":\"en\"},\"gadgets\":[{\"moduleId\":0,\"url\":\"" + fullurl + "\",\"prefs\":[]}]}";
            URL url = new URL(this.internalServerPath + "/eXoGadgetServer/gadgets/metadata");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            String strMetadata = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
            wr.close();
            JSONObject metadata = new JSONObject(strMetadata.toString());
            file.setAttribute("metadata", metadata.toString());
            files.appendChild(file);
        }
        return files;
    }

    private List<ApplicationCategory> getGadgetCategories() throws Exception {
        List applicationCategories = this.applicationRegistryService.getApplicationCategories();
        ArrayList<ApplicationCategory> gadgetCategories = new ArrayList<ApplicationCategory>();
        for (ApplicationCategory applicationCategory : applicationCategories) {
            if (this.applicationRegistryService.getApplications(applicationCategory, new ApplicationType[]{ApplicationType.GADGET}).isEmpty()) continue;
            gadgetCategories.add(applicationCategory);
        }
        return gadgetCategories;
    }
}

