/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.configuration.ConfigurationCheckExecutor;
import org.rhq.core.pc.configuration.UpdateResourceConfigurationRunner;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.util.exception.WrappedRemotingException;

public class ConfigurationManager
extends AgentService
implements ContainerService,
ConfigurationAgentService {
    private final Log log = LogFactory.getLog(ConfigurationManager.class);
    private static final String SENDER_THREAD_POOL_NAME = "ConfigurationManager.threadpool";
    private static final int FACET_METHOD_TIMEOUT = 60000;
    private PluginContainerConfiguration pluginContainerConfiguration;
    private ScheduledExecutorService threadPool;

    public ConfigurationManager() {
        super(ConfigurationAgentService.class);
    }

    public void initialize() {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(SENDER_THREAD_POOL_NAME, true);
        this.threadPool = new ScheduledThreadPoolExecutor(1, threadFactory);
        ConfigurationCheckExecutor configurationChecker = new ConfigurationCheckExecutor(this, this.getConfigurationServerService(), PluginContainer.getInstance().getInventoryManager());
        if (this.pluginContainerConfiguration.getConfigurationDiscoveryPeriod() > 0L && this.pluginContainerConfiguration.isInsideAgent()) {
            this.threadPool.scheduleAtFixedRate(configurationChecker, this.pluginContainerConfiguration.getConfigurationDiscoveryInitialDelay(), this.pluginContainerConfiguration.getConfigurationDiscoveryPeriod(), TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }

    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.pluginContainerConfiguration = configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateRequest request) {
        block2: {
            ConfigurationServerService configurationServerService = this.getConfigurationServerService();
            try {
                ResourceType resourceType = this.getResourceType(request.getResourceId());
                ConfigurationFacet configurationFacet = this.getConfigurationFacet(request.getResourceId(), FacetLockType.WRITE);
                UpdateResourceConfigurationRunner runnable = new UpdateResourceConfigurationRunner(configurationServerService, resourceType, configurationFacet, request);
                this.getThreadPool().submit(runnable);
            }
            catch (PluginContainerException e) {
                this.log.error((Object)("Failed to submit config update task. Cause: " + (Object)((Object)e)));
                if (configurationServerService == null) break block2;
                ConfigurationUpdateResponse error = new ConfigurationUpdateResponse(request.getConfigurationUpdateId(), request.getConfiguration(), (Throwable)e);
                configurationServerService.completeConfigurationUpdate(error);
            }
        }
    }

    public ConfigurationUpdateResponse executeUpdateResourceConfigurationImmediately(ConfigurationUpdateRequest request) throws PluginContainerException {
        ConfigurationUpdateResponse response;
        try {
            ConfigurationServerService configurationServerService = this.getConfigurationServerService();
            ResourceType resourceType = this.getResourceType(request.getResourceId());
            ConfigurationFacet configurationFacet = this.getConfigurationFacet(request.getResourceId(), FacetLockType.WRITE);
            UpdateResourceConfigurationRunner runner = new UpdateResourceConfigurationRunner(configurationServerService, resourceType, configurationFacet, request);
            response = this.getThreadPool().submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error occurred in delete resource thread", (Throwable)e);
        }
        return response;
    }

    public Configuration loadResourceConfiguration(int resourceId) throws PluginContainerException {
        ResourceType resourceType = this.getResourceType(resourceId);
        ConfigurationFacet configComponent = this.getConfigurationFacet(resourceId, FacetLockType.READ);
        try {
            Configuration configuration = configComponent.loadResourceConfiguration();
            if (configuration == null) {
                throw new PluginContainerException("Plugin Error: Resource Component for [" + resourceType.getName() + "] Resource with id [" + resourceId + "] returned a null Configuration.");
            }
            if (configuration.getNotes() == null) {
                configuration.setNotes("Resource config for " + resourceType.getName() + " Resource w/ id " + resourceId);
            }
            ConfigurationDefinition configurationDefinition = resourceType.getResourceConfigurationDefinition();
            ConfigurationUtility.normalizeConfiguration((Configuration)configuration, (ConfigurationDefinition)configurationDefinition);
            List errorMessages = ConfigurationUtility.validateConfiguration((Configuration)configuration, (ConfigurationDefinition)configurationDefinition);
            for (String errorMessage : errorMessages) {
                this.log.warn((Object)("Plugin Error: Invalid " + resourceType.getName() + " Resource configuration returned by " + resourceType.getPlugin() + " plugin - " + errorMessage));
            }
            return configuration;
        }
        catch (Throwable t) {
            throw new PluginContainerException("Cannot load Resource configuration for [" + resourceId + "]", (Throwable)new WrappedRemotingException(t));
        }
    }

    protected ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected ConfigurationFacet getConfigurationFacet(int resourceId, FacetLockType lockType) throws PluginContainerException {
        boolean daemonThread = lockType != FacetLockType.WRITE;
        return ComponentUtil.getComponent(resourceId, ConfigurationFacet.class, lockType, 60000L, daemonThread, true);
    }

    protected ResourceType getResourceType(int resourceId) throws PluginContainerException {
        return ComponentUtil.getResourceType(resourceId);
    }

    protected ConfigurationServerService getConfigurationServerService() {
        if (this.pluginContainerConfiguration.getServerServices() != null) {
            return this.pluginContainerConfiguration.getServerServices().getConfigurationServerService();
        }
        return null;
    }
}

