/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.UITreeTaxonomyBuilder;
import org.exoplatform.ecm.webui.tree.selectone.UISelectTaxonomyPanel;
import org.exoplatform.ecm.webui.tree.selectone.UITreeTaxonomyList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/ecm/webui/UIContainerWithAction.gtmpl"), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbOneTaxonomy", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})})})
public class UIOneTaxonomySelector
extends UIBaseNodeTreeSelector {
    private String[] acceptedNodeTypesInTree = new String[0];
    private String[] acceptedNodeTypesInPathPanel = new String[0];
    private String[] acceptedMimeTypes = new String[0];
    private String[] exceptedNodeTypesInPathPanel = new String[0];
    private String repositoryName = null;
    private String workspaceName = null;
    private String rootTreePath = null;
    private boolean isDisable = false;
    private boolean allowPublish = false;
    private boolean alreadyChangePath = false;
    private String rootTaxonomyName = null;
    private String[] defaultExceptedNodeTypes = new String[]{"exo:symlink"};

    public UIOneTaxonomySelector() throws Exception {
        this.addChild(UIBreadcumbs.class, "BreadcumbOneTaxonomy", "BreadcumbOneTaxonomy");
        this.addChild(UITreeTaxonomyList.class, null, null);
        this.addChild(UITreeTaxonomyBuilder.class, null, UITreeTaxonomyBuilder.class.getSimpleName() + this.hashCode());
        this.addChild(UISelectTaxonomyPanel.class, null, null);
    }

    public String getRootTaxonomyName() {
        return this.rootTaxonomyName;
    }

    public void setRootTaxonomyName(String rootTaxonomyName) {
        this.rootTaxonomyName = rootTaxonomyName;
    }

    Node getTaxoTreeNode(String taxoTreeName) throws RepositoryException {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        return taxonomyService.getTaxonomyTree(this.repositoryName, taxoTreeName);
    }

    public String[] getDefaultExceptedNodeTypes() {
        return this.defaultExceptedNodeTypes;
    }

    public void init(SessionProvider sessionProvider) throws Exception {
        Node rootNode;
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(this.repositoryName);
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List templates = templateService.getDocumentTemplates(this.repositoryName);
        if (this.rootTreePath.trim().equals("/")) {
            rootNode = sessionProvider.getSession(this.workspaceName, manageableRepository).getRootNode();
        } else {
            NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
            try {
                rootNode = (Node)nodeFinder.getItem(this.repositoryName, this.workspaceName, this.rootTreePath);
            }
            catch (PathNotFoundException pathNotFoundException) {
                rootNode = null;
            }
        }
        UITreeTaxonomyList uiTreeTaxonomyList = (UITreeTaxonomyList)this.getChild(UITreeTaxonomyList.class);
        uiTreeTaxonomyList.setTaxonomyTreeList(this.repositoryName);
        UITreeTaxonomyBuilder builder = (UITreeTaxonomyBuilder)this.getChild(UITreeTaxonomyBuilder.class);
        builder.setAllowPublish(this.allowPublish, publicationService, templates);
        builder.setAcceptedNodeTypes(this.acceptedNodeTypesInTree);
        builder.setDefaultExceptedNodeTypes(this.defaultExceptedNodeTypes);
        if (rootNode != null) {
            builder.setRootTreeNode(rootNode);
        }
        UISelectTaxonomyPanel selectPathPanel = (UISelectTaxonomyPanel)this.getChild(UISelectTaxonomyPanel.class);
        selectPathPanel.setAllowPublish(this.allowPublish, publicationService, templates);
        selectPathPanel.setAcceptedNodeTypes(this.acceptedNodeTypesInPathPanel);
        selectPathPanel.setAcceptedMimeTypes(this.acceptedMimeTypes);
        selectPathPanel.setExceptedNodeTypes(this.exceptedNodeTypesInPathPanel);
        selectPathPanel.setDefaultExceptedNodeTypes(this.defaultExceptedNodeTypes);
        selectPathPanel.updateGrid();
    }

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish) {
        this.allowPublish = allowPublish;
    }

    public void setRootNodeLocation(String repository, String workspace, String rootPath) throws Exception {
        this.repositoryName = repository;
        this.workspaceName = workspace;
        this.rootTreePath = rootPath;
    }

    public void setIsDisable(String wsName, boolean isDisable) {
        this.setWorkspaceName(wsName);
        this.isDisable = isDisable;
    }

    public boolean isDisable() {
        return this.isDisable;
    }

    public void setIsShowSystem(boolean isShowSystem) {
        ((UITreeTaxonomyList)this.getChild(UITreeTaxonomyList.class)).setIsShowSystem(isShowSystem);
    }

    public void setShowRootPathSelect(boolean isRendered) {
        UITreeTaxonomyList uiTreeTaxonomyList = (UITreeTaxonomyList)this.getChild(UITreeTaxonomyList.class);
        uiTreeTaxonomyList.setShowRootPathSelect(isRendered);
    }

    public String[] getAcceptedNodeTypesInTree() {
        return this.acceptedNodeTypesInTree;
    }

    public void setAcceptedNodeTypesInTree(String[] acceptedNodeTypesInTree) {
        this.acceptedNodeTypesInTree = acceptedNodeTypesInTree;
    }

    public String[] getAcceptedNodeTypesInPathPanel() {
        return this.acceptedNodeTypesInPathPanel;
    }

    public void setAcceptedNodeTypesInPathPanel(String[] acceptedNodeTypesInPathPanel) {
        this.acceptedNodeTypesInPathPanel = acceptedNodeTypesInPathPanel;
    }

    public String[] getExceptedNodeTypesInPathPanel() {
        return this.exceptedNodeTypesInPathPanel;
    }

    public void setExceptedNodeTypesInPathPanel(String[] exceptedNodeTypesInPathPanel) {
        this.exceptedNodeTypesInPathPanel = exceptedNodeTypesInPathPanel;
    }

    public String[] getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedMimeTypes(String[] acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getRootTreePath() {
        return this.rootTreePath;
    }

    public void setRootTreePath(String rootTreePath) {
        this.rootTreePath = rootTreePath;
        ((UISelectTaxonomyPanel)this.getChild(UISelectTaxonomyPanel.class)).setTaxonomyTreePath(rootTreePath);
    }

    public String getTaxonomyLabel(Node node) throws RepositoryException {
        try {
            String display = node.getName();
            if (this.rootTaxonomyName == null) {
                this.rootTaxonomyName = this.rootTreePath.substring(this.rootTreePath.lastIndexOf("/") + 1);
            }
            display = this.rootTaxonomyName.concat(node.getPath().replace(this.rootTreePath, "")).replaceAll("/", ".");
            return Utils.getResourceBundle("eXoTaxonomies.".concat(display).concat(".label"));
        }
        catch (MissingResourceException missingResourceException) {
            return node.getName();
        }
    }

    public void onChange(Node currentNode, Object context) throws Exception {
        UISelectTaxonomyPanel selectPathPanel = (UISelectTaxonomyPanel)this.getChild(UISelectTaxonomyPanel.class);
        UITreeTaxonomyList uiTreeTaxonomyList = (UITreeTaxonomyList)this.getChild(UITreeTaxonomyList.class);
        String taxoTreeName = (String)uiTreeTaxonomyList.getUIFormSelectBox(UITreeTaxonomyList.TAXONOMY_TREE).getValue();
        Node parentRoot = this.getTaxoTreeNode(taxoTreeName);
        selectPathPanel.setParentNode(currentNode);
        selectPathPanel.updateGrid();
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        String pathName = currentNode.getName();
        if (currentNode.equals(parentRoot)) {
            pathName = "";
        }
        String label = pathName.length() > 0 ? this.getTaxonomyLabel(currentNode) : pathName;
        UIBreadcumbs.LocalPath localPath = new UIBreadcumbs.LocalPath(pathName, label);
        List listLocalPath = uiBreadcumbs.getPath();
        StringBuilder buffer = new StringBuilder(1024);
        for (UIBreadcumbs.LocalPath iterLocalPath : listLocalPath) {
            buffer.append("/").append(iterLocalPath.getId());
        }
        if (!this.alreadyChangePath) {
            String breadcumbPath;
            String path = buffer.toString();
            if (!(path = path.replaceAll("/+", "/")).startsWith(this.rootTreePath)) {
                path = currentNode.getPath().contains(parentRoot.getPath()) ? currentNode.getPath() : this.rootTreePath + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() == 0) {
                path = "/";
            }
            if (!(breadcumbPath = this.rootTreePath + buffer.toString()).equals(path)) {
                if (breadcumbPath.startsWith(path)) {
                    if (listLocalPath != null && listLocalPath.size() > 0) {
                        listLocalPath.remove(listLocalPath.size() - 1);
                    }
                } else if (!currentNode.equals(parentRoot)) {
                    listLocalPath.add(localPath);
                }
            }
        }
        this.alreadyChangePath = false;
        uiBreadcumbs.setPath(listLocalPath);
    }

    private void changeNode(String stringPath, Object context) throws Exception {
        UITreeTaxonomyBuilder builder = (UITreeTaxonomyBuilder)this.getChild(UITreeTaxonomyBuilder.class);
        builder.changeNode(stringPath, context);
    }

    public void changeGroup(String groupId, Object context) throws Exception {
        List listLocalPath;
        String stringPath = this.rootTreePath;
        if (!this.rootTreePath.equals("/")) {
            stringPath = stringPath + "/";
        }
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        if (groupId == null) {
            groupId = "";
        }
        if ((listLocalPath = uiBreadcumb.getPath()) == null || listLocalPath.size() == 0) {
            return;
        }
        ArrayList<String> listLocalPathString = new ArrayList<String>();
        for (UIBreadcumbs.LocalPath localPath : listLocalPath) {
            listLocalPathString.add(localPath.getId().trim());
        }
        if (listLocalPathString.contains(groupId)) {
            int i;
            int index = listLocalPathString.indexOf(groupId);
            this.alreadyChangePath = false;
            if (index == listLocalPathString.size() - 1) {
                return;
            }
            for (i = listLocalPathString.size() - 1; i > index; --i) {
                listLocalPathString.remove(i);
                listLocalPath.remove(i);
            }
            this.alreadyChangePath = true;
            uiBreadcumb.setPath(listLocalPath);
            for (i = 0; i < listLocalPathString.size(); ++i) {
                String pathName = (String)listLocalPathString.get(i);
                if (pathName == null && pathName.equals("")) continue;
                stringPath = stringPath + pathName.trim();
                if (i >= listLocalPathString.size() - 1) continue;
                stringPath = stringPath + "/";
            }
            this.changeNode(stringPath, context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIOneTaxonomySelector uiOneNodePathSelector = (UIOneTaxonomySelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiOneNodePathSelector.changeGroup(selectGroupId, event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiOneNodePathSelector);
        }
    }
}

