/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.annotations.AbstractAnnotationPlugin;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectableMemberAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation>
extends AbstractAnnotationPlugin<T, C> {
    protected InjectableMemberAnnotationPlugin(Class<C> annotation) {
        super(annotation);
    }

    protected abstract String getName(T var1);

    protected PropertyMetaData findPropertyMetaData(T info, BeanMetaData beanMetaData) {
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyMetaData pmd : properties) {
                if (!pmd.getName().equals(this.getName(info))) continue;
                return pmd;
            }
        }
        return null;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(T info, C annotation, BeanMetaData beanMetaData) {
        PropertyMetaData pmd = this.findPropertyMetaData(info, beanMetaData);
        return this.isMetaDataComplete(pmd);
    }

    protected boolean isMetaDataComplete(PropertyMetaData pmd) {
        return pmd != null;
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, BeanMetaData beanMetaData) throws Throwable {
        Set<PropertyMetaData> properties = this.getProperties(beanMetaData);
        PropertyMetaData property = this.getPropertyMetaData(info, annotation, beanMetaData);
        properties.add(property);
        return Collections.singletonList(property);
    }

    protected PropertyMetaData getPropertyMetaData(T info, C annotation, BeanMetaData beanMetaData) {
        return this.getPropertyMetaData(info, annotation);
    }

    protected PropertyMetaData getPropertyMetaData(T info, C annotation) {
        ValueMetaData value = this.createValueMetaData(info, annotation);
        if (value == null) {
            throw new IllegalArgumentException("Should not return null value, " + this);
        }
        return new AbstractPropertyMetaData(this.getName(info), value);
    }

    protected Set<PropertyMetaData> getProperties(BeanMetaData beanMetaData) {
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties == null) {
            properties = new HashSet<PropertyMetaData>();
            AbstractBeanMetaData bean = this.checkIfNotAbstractBeanMetaDataSpecific(beanMetaData);
            bean.setProperties(properties);
        }
        return properties;
    }

    public ValueMetaData createValueMetaData(ParameterInfo parameterInfo, C annotation, ValueMetaData previousValue) {
        return this.createValueMetaData(parameterInfo.getParameterType(), annotation, previousValue);
    }

    protected ValueMetaData createValueMetaData(TypeInfo type, C annotation, ValueMetaData previousValue) {
        return this.createValueMetaData((T)type, annotation);
    }

    protected ValueMetaData createValueMetaData(TypeInfo type, C annotation) {
        return this.createValueMetaData(annotation, null);
    }

    protected ValueMetaData createValueMetaData(T info, C annotation) {
        return this.createValueMetaData(annotation, null);
    }

    protected ValueMetaData createValueMetaData(C annotation, ValueMetaData previousValue) {
        return this.createValueMetaData(annotation);
    }

    public ValueMetaData createValueMetaData(C annotation) {
        throw new IllegalArgumentException("Missing createValueMetaData(" + annotation + ") implementation: " + this.toString());
    }
}

