/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.jms.server.destination.QueueService;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.mq.server.jmx.QueueMBean;
import org.w3c.dom.Element;

@ManagementObject(componentType=@ManagementComponent(type="JMSDestination", subtype="Queue"), properties=ManagementProperties.EXPLICIT)
public class Queue
implements MBeanRegistration,
QueueMBean {
    private QueueService delegate;

    public Queue() {
        this.delegate = new QueueService();
    }

    public Queue(boolean createProgramatically) {
        this.delegate = new QueueService(createProgramatically);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.delegate.addNotificationListener(listener, filter, handback);
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void create() throws Exception {
        this.delegate.create();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void destroy() {
        this.delegate.destroy();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The write-cache size, can only be set when queue is stopped")
    public int getDownCacheSize() {
        return this.delegate.getDownCacheSize();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The in-memory message limit, can only be set when queue is stopped")
    public int getFullSize() {
        return this.delegate.getFullSize();
    }

    @ManagementProperty(use={ViewUse.RUNTIME})
    public String getJNDIName() {
        return this.delegate.getJNDIName();
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public int getMessageCount() throws Exception {
        return this.delegate.getMessageCount();
    }

    @ManagementProperty(use={ViewUse.RUNTIME})
    public String getName() {
        return this.delegate.getName();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="he paging size, can only be set when queue is stopped")
    public int getPageSize() {
        return this.delegate.getPageSize();
    }

    @ManagementProperty(use={ViewUse.RUNTIME})
    public ObjectName getServerPeer() {
        return this.delegate.getServerPeer();
    }

    public ObjectName getServiceName() {
        return this.delegate.getServiceName();
    }

    @ManagementProperty(use={ViewUse.STATISTIC})
    public boolean isCreatedProgrammatically() {
        return this.delegate.isCreatedProgrammatically();
    }

    @ManagementOperation(description="List all mesages with the selector", impact=ManagedOperation.Impact.ReadOnly)
    public List listMessages(String arg0) throws Exception {
        return this.delegate.listAllMessages(arg0);
    }

    @ManagementOperation(description="List all mesages", impact=ManagedOperation.Impact.ReadOnly)
    public List listAllMessages() throws Exception {
        return this.delegate.listAllMessages();
    }

    @ManagementOperation(description="List all durable mesages", impact=ManagedOperation.Impact.ReadOnly)
    public List listDurableMessages() throws Exception {
        return this.delegate.listDurableMessages();
    }

    @ManagementOperation(description="List all durable mesages using a selector", impact=ManagedOperation.Impact.ReadOnly)
    public List listDurableMessages(String selector) throws Exception {
        return this.delegate.listDurableMessages(selector);
    }

    @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
    public List listNonDurableMessages() throws Exception {
        return this.delegate.listNonDurableMessages();
    }

    @ManagementOperation(description="List all non durable mesages using a selector", impact=ManagedOperation.Impact.ReadOnly)
    public List listNonDurableMessages(String selector) throws Exception {
        return this.delegate.listNonDurableMessages(selector);
    }

    @ManagementOperation(description="Reset the message counter", impact=ManagedOperation.Impact.WriteOnly)
    public void resetMessageCounter() throws Exception {
        this.delegate.resetMessageCounter();
    }

    @ManagementOperation(description="Remove all messages in the queue", impact=ManagedOperation.Impact.WriteOnly)
    public void removeAllMessages() throws Exception {
        this.delegate.removeAllMessages();
    }

    public void setDownCacheSize(int arg0) {
        this.delegate.setDownCacheSize(arg0);
    }

    public void setFullSize(int arg0) {
        this.delegate.setFullSize(arg0);
    }

    public void setJNDIName(String arg0) throws Exception {
        this.delegate.setJNDIName(arg0);
    }

    public void setPageSize(int arg0) {
        this.delegate.setPageSize(arg0);
    }

    public void setSecurityConfig(Element arg0) throws Exception {
        this.delegate.setSecurityConfig(arg0);
    }

    public void setSecurityConf(Element arg0) throws Exception {
        this.delegate.setSecurityConfig(arg0);
    }

    public void setSecurityManager(ObjectName arg0) {
    }

    public void setServerPeer(ObjectName arg0) {
        this.delegate.setServerPeer(arg0);
    }

    public void setDestinationManager(ObjectName arg0) throws Exception {
        ObjectName peer = new ObjectName("jboss.messaging:service=ServerPeer");
        this.delegate.setServerPeer(peer);
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void start() throws Exception {
        this.delegate.start();
    }

    @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
    public void stop() {
        this.delegate.stop();
    }

    public void setMessageCounterHistoryDayLimit(int arg0) {
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION})
    public ObjectName getExpiryDestination() {
        return this.delegate.getExpiryQueue();
    }

    public void setExpiryDestination(ObjectName destination) {
        try {
            this.delegate.setExpiryQueue(destination);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void postDeregister() {
        this.delegate.postDeregister();
    }

    public void postRegister(Boolean registrationDone) {
        this.delegate.postRegister(registrationDone);
    }

    public void preDeregister() throws Exception {
        this.delegate.preDeregister();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return this.delegate.preRegister(server, name);
    }
}

