/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.REST.viewer;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;

@Path(value="/pdfviewer/{repoName}/{workspaceName}/{pageNumber}/{rotation}/{scale}/{uuid}/")
public class PDFViewerRESTService
implements ResourceContainer {
    private static final String LASTMODIFIED = "Last-Modified";
    private RepositoryService repositoryService_;

    public PDFViewerRESTService(RepositoryService repositoryService) throws Exception {
        this.repositoryService_ = repositoryService;
    }

    @GET
    public Response getCoverImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="uuid") String uuid, @PathParam(value="pageNumber") String pageNumber, @PathParam(value="rotation") String rotation, @PathParam(value="scale") String scale) throws Exception {
        return this.getImageByPageNumber(repoName, wsName, uuid, pageNumber, rotation, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getImageByPageNumber(String repoName, String wsName, String uuid, String pageNumber, String strRotation, String strScale) throws Exception {
        BufferedImage image;
        System.setProperty("org.icepdf.core.awtFontLoading", "true");
        Document document = new Document();
        ManageableRepository repository = this.repositoryService_.getRepository(repoName);
        Session session = this.getSystemProvider().getSession(wsName, repository);
        Node currentNode = session.getNodeByUUID(uuid);
        Node contentNode = currentNode.getNode("jcr:content");
        try {
            InputStream input = contentNode.getProperty("jcr:data").getStream();
            document.setInputStream(input, currentNode.getPath());
        }
        catch (PDFException ex) {
            System.out.println("Error parsing PDF document " + (Object)((Object)ex));
        }
        catch (PDFSecurityException ex) {
            System.out.println("Error encryption not supported " + (Object)((Object)ex));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Error file not found " + ex);
        }
        catch (IOException ex) {
            System.out.println("Error handling PDF document " + ex);
        }
        float scale = Float.parseFloat(strScale);
        float rotation = Float.parseFloat(strRotation);
        int maximumOfPage = document.getNumberOfPages();
        int pageNum = 1;
        try {
            pageNum = Integer.parseInt(pageNumber);
        }
        catch (NumberFormatException e) {
            pageNum = 1;
        }
        if (pageNum >= maximumOfPage) {
            pageNum = maximumOfPage;
        } else if (pageNum < 1) {
            pageNum = 1;
        }
        BufferedImage rendImage = image = (BufferedImage)document.getPageImage(pageNum - 1, 1, 2, rotation, scale);
        File file = null;
        try {
            file = new File("imageCapture1_" + pageNum + ".png");
            ImageIO.write((RenderedImage)rendImage, "png", file);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            String lastModified = contentNode.getProperty("jcr:lastModified").getString();
            session.logout();
            Response response = Response.ok((Object)is, (String)"image").header(LASTMODIFIED, (Object)lastModified).build();
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            image.flush();
            document.dispose();
            if (file != null) {
                file.delete();
            }
            session.logout();
        }
        return Response.ok().build();
    }

    private SessionProvider getSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }
}

