/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.classify.impl;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.classify.NodeClassifyPlugin;

public class AlphabetClassifyPlugin
extends NodeClassifyPlugin {
    public void classifyChildrenNode(Node parent) throws Exception {
        Session session = parent.getSession();
        NodeIterator nodeIterator = parent.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            char firstCharacter = child.getName().charAt(0);
            Node classifiedNode = null;
            try {
                classifiedNode = parent.getNode(Character.toString(firstCharacter));
            }
            catch (PathNotFoundException ex) {
                classifiedNode = parent.addNode(Character.toString(firstCharacter));
                session.save();
            }
            String srcPath = child.getPath();
            String destPath = classifiedNode.getPath() + "/" + child.getName();
            session.move(srcPath, destPath);
        }
        session.save();
    }
}

