/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.richfaces.validator.FacesBeanValidator;
import org.richfaces.validator.GraphValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIGraphValidator
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.richfaces.GraphValidator";
    public static final String COMPONENT_FAMILY = "org.richfaces.GraphValidator";

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract String getSummary();

    public abstract void setSummary(String var1);

    public abstract Set<String> getProfile();

    public abstract void setProfile(Set<String> var1);

    public abstract String getType();

    public abstract void setType(String var1);

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        Object value = this.getValue();
        if (null != value) {
            Validator validator = context.getApplication().createValidator(this.getType());
            if (validator instanceof GraphValidator) {
                GraphValidator graphValidator = (GraphValidator)validator;
                String[] messages = graphValidator.validateGraph(context, (UIComponent)this, value, this.getProfile());
                if (null != messages) {
                    context.renderResponse();
                    String clientId = this.getClientId(context);
                    for (String msg : messages) {
                        String summary = null != this.getSummary() ? this.getSummary() + msg : msg;
                        context.addMessage(clientId, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, msg));
                    }
                }
            } else {
                throw new FacesException("Validator org.richfaces.BeanValidator does not implement GraphValidator");
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        FacesBeanValidator validator = (FacesBeanValidator)context.getApplication().createValidator(this.getType());
        validator.setSummary(this.getSummary());
        this.setupValidators((UIComponent)this, validator);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.isRendered()) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                child.encodeAll(context);
            }
        }
    }

    private void setupValidators(UIComponent component, Validator validator) {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)child;
                this.setupValidator(input, validator);
            }
            this.setupValidators(child, validator);
        }
    }

    private void setupValidator(EditableValueHolder input, Validator validator) {
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            if (!(validators[i] instanceof FacesBeanValidator)) continue;
            return;
        }
        input.addValidator(validator);
    }

    public boolean getRendersChildren() {
        return true;
    }
}

