/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MX4JComponentAdapter
extends AbstractComponentAdapter {
    private Object instance_;
    private Log log = ExoLogger.getLogger(MX4JComponentAdapter.class);
    private static final Comparator<org.exoplatform.container.xml.ComponentPlugin> COMPARATOR = new Comparator<org.exoplatform.container.xml.ComponentPlugin>(){

        @Override
        public int compare(org.exoplatform.container.xml.ComponentPlugin o1, org.exoplatform.container.xml.ComponentPlugin o2) {
            return this.getPriority(o1) - this.getPriority(o2);
        }

        private int getPriority(org.exoplatform.container.xml.ComponentPlugin p) {
            return p.getPriority() == null ? 0 : Integer.parseInt(p.getPriority());
        }
    };

    public MX4JComponentAdapter(Object key, Class implementation) {
        super(key, implementation);
    }

    public Object getComponentInstance(PicoContainer container) {
        if (this.instance_ != null) {
            return this.instance_;
        }
        ExoContainer exocontainer = (ExoContainer)container;
        Object key = this.getComponentKey();
        String componentKey = key instanceof String ? (String)key : ((Class)key).getName();
        ConfigurationManager manager = (ConfigurationManager)exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
        Component component = manager.getComponent(componentKey);
        try {
            ExternalComponentPlugins ecplugins;
            InitParams params = null;
            boolean debug = false;
            if (component != null) {
                params = component.getInitParams();
                debug = component.getShowDeployInfo();
            }
            this.instance_ = exocontainer.createComponent(this.getComponentImplementation(), params);
            if (debug) {
                this.log.debug((Object)("==> create  component : " + this.instance_));
            }
            if (component != null && component.getComponentPlugins() != null) {
                this.addComponentPlugin(debug, this.instance_, component.getComponentPlugins(), exocontainer);
            }
            if ((ecplugins = manager.getConfiguration().getExternalComponentPlugins(componentKey)) != null) {
                this.addComponentPlugin(debug, this.instance_, ecplugins.getComponentPlugins(), exocontainer);
            }
            if (this.instance_ instanceof ComponentLifecycle) {
                ComponentLifecycle lc = (ComponentLifecycle)this.instance_;
                lc.initComponent(exocontainer);
            }
        }
        catch (Exception ex) {
            String msg = "Cannot instantiate component " + this.getComponentImplementation();
            if (component != null) {
                msg = "Cannot instantiate component key=" + component.getKey() + " type=" + component.getType() + " found at " + component.getDocumentURL();
            }
            throw new RuntimeException(msg, ex);
        }
        return this.instance_;
    }

    private void addComponentPlugin(boolean debug, Object component, List<org.exoplatform.container.xml.ComponentPlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        Collections.sort(plugins, COMPARATOR);
        for (org.exoplatform.container.xml.ComponentPlugin plugin : plugins) {
            try {
                Class<?> clazz = Class.forName(plugin.getType());
                ComponentPlugin cplugin = (ComponentPlugin)container.createComponent(clazz, plugin.getInitParams());
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
                clazz = component.getClass();
                Method m = this.getSetMethod(clazz, plugin.getSetMethod());
                Object[] params = new Object[]{cplugin};
                m.invoke(component, params);
                if (debug) {
                    this.log.debug((Object)("==> add component plugin: " + cplugin));
                }
                cplugin.setName(plugin.getName());
                cplugin.setDescription(plugin.getDescription());
            }
            catch (Exception ex) {
                this.log.error((Object)("Failed to instanciate plugin " + plugin.getName() + "for component " + component + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    private Method getSetMethod(Class clazz, String name) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            Class<?>[] types;
            if (!name.equals(m.getName()) || (types = m.getParameterTypes()) == null || types.length != 1 || !ComponentPlugin.class.isAssignableFrom(types[0])) continue;
            return m;
        }
        return null;
    }

    public void verify(PicoContainer container) {
    }
}

