/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.log;

import org.jboss.webbeans.log.JDKProvider;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Log4JProvider;
import org.jboss.webbeans.log.LogImpl;
import org.jboss.webbeans.log.LogProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logging {
    private static final boolean isLog4JAvailable;

    public static Log getLog(String category) {
        return new LogImpl(category);
    }

    public static Log getLog(Class<?> clazz) {
        return new LogImpl(clazz.getName());
    }

    static LogProvider getLogProvider(String category, boolean wrapped) {
        return isLog4JAvailable ? new Log4JProvider(category, wrapped) : new JDKProvider(category, wrapped);
    }

    public static LogProvider getLogProvider(Class<?> clazz) {
        return Logging.getLogProvider(clazz.getName(), false);
    }

    static {
        boolean available;
        try {
            Class.forName("org.apache.log4j.Logger");
            available = true;
        }
        catch (ClassNotFoundException cnfe) {
            available = false;
        }
        isLog4JAvailable = available;
    }
}

