/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration.propset;

import java.util.UUID;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.gui.configuration.helper.ConfigurationUtility;
import org.rhq.core.gui.configuration.propset.ConfigurationSet;
import org.rhq.core.gui.util.FacesComponentIdFactory;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesExpressionUtility;

public class PropertySetComponent
extends UIComponentBase
implements FacesComponentIdFactory {
    private static final String COMPONENT_FAMILY = "rhq";
    public static final String COMPONENT_TYPE = "org.rhq.PropertySet";
    public static final String PROPERTY_EXPRESSION_STRING_ATTRIBUTE = "propertyExpressionString";
    public static final String CONFIGURATION_SET_ATTRIBUTE = "configurationSet";
    private Boolean readOnly;
    private Integer listIndex;
    private Object[] stateValues;

    public PropertySetComponent() {
        this.setRendererType(COMPONENT_TYPE);
    }

    public String createUniqueId() {
        return "rhq_id" + UUID.randomUUID();
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    @Nullable
    public PropertyDefinitionSimple getPropertyDefinition() {
        PropertySimple propertySimple = this.getProperty();
        if (propertySimple == null) {
            return null;
        }
        ConfigurationDefinition configurationDefinition = this.getConfigurationSet().getConfigurationDefinition();
        PropertyDefinition propertyDefinition = ConfigurationUtility.getPropertyDefinitionForProperty((Property)propertySimple, configurationDefinition);
        return (PropertyDefinitionSimple)propertyDefinition;
    }

    @Nullable
    public PropertySimple getProperty() {
        String propertyExpressionString = FacesComponentUtility.getExpressionAttribute((UIComponent)this, PROPERTY_EXPRESSION_STRING_ATTRIBUTE, String.class);
        if (propertyExpressionString == null || propertyExpressionString.equals("")) {
            propertyExpressionString = (String)this.getAttributes().get(PROPERTY_EXPRESSION_STRING_ATTRIBUTE);
        }
        if (propertyExpressionString == null || propertyExpressionString.equals("")) {
            return null;
        }
        propertyExpressionString = FacesExpressionUtility.unwrapExpressionString(propertyExpressionString);
        propertyExpressionString = "#{" + propertyExpressionString.replace(".stringValue", "") + "}";
        PropertySimple propertySimple = FacesExpressionUtility.getValue(propertyExpressionString, PropertySimple.class);
        return propertySimple;
    }

    @Nullable
    public ConfigurationSet getConfigurationSet() {
        ConfigurationSet configurationSet = FacesComponentUtility.getExpressionAttribute((UIComponent)this, CONFIGURATION_SET_ATTRIBUTE, ConfigurationSet.class);
        if (configurationSet == null) {
            throw new IllegalStateException("The 'configurationSet' attribute is required.");
        }
        return configurationSet;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Integer getListIndex() {
        return this.listIndex;
    }

    public void setListIndex(Integer listIndex) {
        this.listIndex = listIndex;
    }

    public Object saveState(FacesContext facesContext) {
        if (this.stateValues == null) {
            this.stateValues = new Object[3];
        }
        this.stateValues[0] = super.saveState(facesContext);
        this.stateValues[1] = this.readOnly;
        this.stateValues[2] = this.listIndex;
        return this.stateValues;
    }

    public void restoreState(FacesContext facesContext, Object stateValues) {
        this.stateValues = (Object[])stateValues;
        super.restoreState(facesContext, this.stateValues[0]);
        this.readOnly = (Boolean)this.stateValues[1];
        this.listIndex = (Integer)this.stateValues[2];
    }
}

