/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;

class CMap
extends Dictionary
implements org.icepdf.core.pobjects.fonts.CMap {
    private static final Logger logger = Logger.getLogger(CMap.class.toString());
    private Map cIdSystemInfo;
    private String cMapName;
    private float cMapType;
    private Object useCMap;
    private int wMode;
    private int[][] codeSpaceRange;
    private Map<Integer, Integer> bfChars;
    private CMapRange[] bfRange;
    private Map cIdChars;
    private Map cIdRange;
    private Hashtable notDefChars;
    private Hashtable notDefRange;
    private Stream cMapStream;
    private InputStream cMapInputStream;

    public CMap(Library library, Hashtable hashtable, Stream stream) {
        super(library, hashtable);
        this.cMapStream = stream;
    }

    public CMap(Library library, Hashtable hashtable, InputStream inputStream) {
        super(library, hashtable);
        this.cMapInputStream = inputStream;
    }

    public void init() {
        try {
            Object object;
            if (this.cMapInputStream == null) {
                this.cMapInputStream = this.cMapStream.getInputStreamForDecodedStreamBytes();
            }
            Parser parser = new Parser(this.cMapInputStream);
            Object object2 = null;
            while ((object = parser.getStreamObject()) != null) {
                String string = object.toString();
                if (string.toLowerCase().indexOf("cidsysteminfo") >= 0) {
                    object = parser.getStreamObject();
                    this.cIdSystemInfo = (Hashtable)object;
                    object = parser.getStreamObject();
                }
                if (object instanceof Name) {
                    string = object.toString();
                    if (string.toLowerCase().indexOf("cmapname") >= 0) {
                        object = parser.getStreamObject();
                        this.cMapName = object.toString();
                        object = parser.getStreamObject();
                    }
                    if (string.toLowerCase().indexOf("cmaptype") >= 0) {
                        object = parser.getStreamObject();
                        this.cMapType = Float.parseFloat(object.toString());
                        object = parser.getStreamObject();
                    }
                    if (string.toLowerCase().indexOf("usemap") >= 0) {
                        // empty if block
                    }
                }
                if (object instanceof String) {
                    StringObject stringObject;
                    int n;
                    int n2;
                    String string2 = (String)object;
                    if (string2.equalsIgnoreCase("begincodespacerange")) {
                        n2 = (int)Float.parseFloat(object2.toString());
                        this.codeSpaceRange = new int[n2][2];
                        for (n = 0; n < n2; ++n) {
                            object = parser.getStreamObject();
                            stringObject = (StringObject)object;
                            int n3 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            object = parser.getStreamObject();
                            stringObject = (StringObject)object;
                            int n4 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            this.codeSpaceRange[n][0] = n3;
                            this.codeSpaceRange[n][1] = n4;
                        }
                    }
                    if (string2.equalsIgnoreCase("beginbfchar")) {
                        n2 = (int)Float.parseFloat(object2.toString());
                        this.bfChars = new HashMap<Integer, Integer>(n2);
                        for (n = 0; n < n2; ++n) {
                            object = parser.getStreamObject();
                            stringObject = (StringObject)object;
                            Integer n5 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            object = parser.getStreamObject();
                            stringObject = (StringObject)object;
                            Integer n6 = null;
                            try {
                                n6 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            }
                            catch (NumberFormatException numberFormatException) {
                                logger.log(Level.FINE, "CMAP: ", numberFormatException);
                            }
                            this.bfChars.put(n5, n6);
                        }
                    }
                    if (string2.equalsIgnoreCase("beginbfrange")) {
                        n2 = (int)Float.parseFloat(object2.toString());
                        this.bfRange = new CMapRange[n2];
                        for (n = 0; n < n2; ++n) {
                            object = parser.getStreamObject();
                            stringObject = (StringObject)object;
                            Integer n7 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            object = parser.getStreamObject();
                            stringObject = (StringObject)object;
                            Integer n8 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            object = parser.getStreamObject();
                            if (object instanceof Vector) {
                                this.bfRange[n] = new CMapRange((int)n7, (int)n8, (Vector)object);
                                continue;
                            }
                            stringObject = (StringObject)object;
                            Integer n9 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            this.bfRange[n] = new CMapRange((int)n7, (int)n8, n9);
                        }
                    }
                    if (string2.equalsIgnoreCase("begincidchar")) {
                        // empty if block
                    }
                    if (string2.equalsIgnoreCase("begincidrange")) {
                        // empty if block
                    }
                    if (string2.equalsIgnoreCase("beginnotdefchar")) {
                        // empty if block
                    }
                    if (string2.equalsIgnoreCase("beginnotdefrange")) {
                        // empty if block
                    }
                }
                object2 = object;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.FINE, "CMap parsing error", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cMapInputStream != null) {
            try {
                this.cMapInputStream.close();
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error clossing cmap stream", iOException);
            }
        }
    }

    public char toSelector(char c) {
        if (this.cIdSystemInfo != null) {
            Object object;
            if (this.bfChars != null && (object = this.bfChars.get(new Integer(c))) != null) {
                return (char)((Integer)object).intValue();
            }
            if (this.bfRange != null) {
                for (CMapRange cMapRange : this.bfRange) {
                    if (!cMapRange.inRange(c)) continue;
                    return (char)cMapRange.getCMapValue(c);
                }
            }
        }
        return c;
    }

    class CMapRange {
        int startRange = 0;
        int endRange = 0;
        int offsetValue = 0;
        Vector offsetVecor = null;

        public CMapRange(int n, int n2, int n3) {
            this.startRange = n;
            this.endRange = n2;
            this.offsetValue = n3;
        }

        public CMapRange(int n, int n2, Vector vector) {
            this.startRange = n;
            this.endRange = n2;
            this.offsetVecor = vector;
        }

        public boolean inRange(int n) {
            return n >= this.startRange && n <= this.endRange;
        }

        public int getCMapValue(int n) {
            int n2 = -1;
            if (this.offsetVecor == null) {
                n2 = this.offsetValue + (n - this.startRange);
            } else {
                String string = this.offsetVecor.elementAt(n - this.startRange).toString();
                n2 = Integer.parseInt(string);
            }
            return n2;
        }
    }
}

