/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderResponse;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditForm;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIJCRExplorerPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIJCRExplorerPortlet.class);
    public static final String REPOSITORY = "repository";
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String MAX_SIZE_UPLOAD = "uploadFileSizeLimitMB";
    public static final String ISDIRECTLY_DRIVE = "isDirectlyDrive";
    public static final String DRIVE_NAME = "driveName";
    public static final String USECASE = "usecase";
    public static final String JAILED = "jailed";
    public static final String SOCIAL = "social";
    public static final String SELECTION = "selection";
    public static final String PERSONAL = "personal";
    public static final String PARAMETERIZE = "parameterize";
    public static final String PARAMETERIZE_PATH = "nodePath";
    private boolean flagSelect = false;

    public UIJCRExplorerPortlet() throws Exception {
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.addChild(UIJcrExplorerContainer.class, null, null);
        explorerContainer.initExplorer();
        ((UIJcrExplorerEditContainer)this.addChild(UIJcrExplorerEditContainer.class, null, null)).setRendered(false);
    }

    public boolean isFlagSelect() {
        return this.flagSelect;
    }

    public void setFlagSelect(boolean flagSelect) {
        this.flagSelect = flagSelect;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.getChild(UIJcrExplorerContainer.class);
        UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class);
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        HashMap map = this.getElementByContext(context);
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        HashMap changeDrive = (HashMap)pcontext.getAttribute("jcrexplorer-show-document");
        if (changeDrive != null) {
            map = changeDrive;
            context.setAttribute("jcrexplorer-show-document", null);
        }
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            if (map.size() > 0) {
                this.showDocument(context, map);
            } else {
                this.initwhenDirect(explorerContainer, editContainer);
            }
            explorerContainer.setRendered(true);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            if (uiExplorer != null) {
                try {
                    uiExplorer.getSession();
                    try {
                        uiExplorer.getSession().getItem(uiExplorer.getRootPath());
                    }
                    catch (PathNotFoundException e) {
                        this.reloadWhenBroken(uiExplorer);
                        super.processRender(app, context);
                        return;
                    }
                }
                catch (RepositoryException repo) {
                    super.processRender(app, context);
                }
            }
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(false);
        } else if (portletReqContext.getApplicationMode() == PortletMode.HELP) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\n\n>>>>>>>>>>>>>>>>>>> IN HELP  MODE \n");
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            explorerContainer.setRendered(false);
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(true);
        }
        RenderResponse response = (RenderResponse)context.getResponse();
        Element elementS = response.createElement("script");
        elementS.setAttribute("type", "text/javascript");
        elementS.setAttribute("src", "/eXoWCMResources/javascript/eXo/wcm/backoffice/public/Components.js");
        response.addProperty("javax.portlet.markup.head.element", elementS);
        super.processRender(app, context);
    }

    public void initwhenDirect(UIJcrExplorerContainer explorerContainer, UIJcrExplorerEditContainer editContainer) throws Exception {
        if (((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).isFlagSelectRender()) {
            PortletPreferences portletPref = this.getPortletPreferences();
            String driveName = portletPref.getValue(DRIVE_NAME, "").trim();
            String repository = portletPref.getValue(REPOSITORY, "").trim();
            String userId = Util.getPortalRequestContext().getRemoteUser();
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            explorerContainer.initExplorer();
            ((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).setFlagSelectRender(false);
            ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
            DriveData driveData = driveService.getDriveByName(driveName, repository);
            String nodePath = portletPref.getValue(PARAMETERIZE_PATH, "").trim();
            if (!nodePath.startsWith("/")) {
                nodePath = "/" + nodePath;
            }
            String homePath = driveData.getHomePath().concat(nodePath).replaceAll("/+", "/");
            if (!this.canUseConfigDrive(repository, driveName)) {
                homePath = this.getUserDrive(repository, "private").getHomePath();
            }
            if (homePath.contains("${userId}")) {
                homePath = homePath.replace("${userId}", userId);
            }
            uiJCRExplorer.setSelectNode(driveData.getWorkspace(), homePath);
            uiJCRExplorer.refreshExplorer();
        }
    }

    public String getPreferenceRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        return repository;
    }

    public String getPreferenceTrashHomeNodePath() {
        return this.getPortletPreferences().getValue(Utils.TRASH_HOME_NODE_PATH, "");
    }

    public String getPreferenceTrashRepository() {
        return this.getPortletPreferences().getValue(Utils.TRASH_REPOSITORY, "");
    }

    public String getPreferenceTrashWorkspace() {
        return this.getPortletPreferences().getValue(Utils.TRASH_WORKSPACE, "");
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    public DriveData getUserDrive(String repoName, String userType) throws Exception {
        ManageDriveService manageDriveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List userRoles = Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        for (DriveData userDrive : manageDriveService.getPersonalDrives(repoName, userId, userRoles)) {
            if (!userDrive.getName().equalsIgnoreCase(userType)) continue;
            return userDrive;
        }
        return null;
    }

    public boolean canUseConfigDrive(String repoName, String driveName) throws Exception {
        ManageDriveService dservice = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        List userRoles = Utils.getMemberships();
        for (DriveData drive : dservice.getDriveByUserRoles(repoName, userId, userRoles)) {
            if (!drive.getName().equals(driveName)) continue;
            return true;
        }
        return false;
    }

    public void reloadWhenBroken(UIJCRExplorer uiExplorer) {
        ((UIControl)uiExplorer.getChild(UIControl.class)).setRendered(false);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        uiWorkingArea.setRenderedChild(UIDrivesArea.class);
    }

    private HashMap<String, String> getElementByContext(WebuiRequestContext context) {
        Matcher matcher;
        HashMap<String, String> mapParam = new HashMap<String, String>();
        if (context.useAjax()) {
            return mapParam;
        }
        Pattern patternUrl = Pattern.compile("([^/]+)/([^/]+)/([^/]+)/(.*)");
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String nodePathParam = pcontext.getRequestParameter("path");
        if (nodePathParam != null && (matcher = (patternUrl = Pattern.compile("([^/]+)/([^/]+)/(.*)")).matcher(nodePathParam)).find()) {
            mapParam.put(REPOSITORY, matcher.group(1));
            mapParam.put("drive", matcher.group(2));
            mapParam.put("path", matcher.group(3));
            return mapParam;
        }
        String nodePathUrl = pcontext.getNodePath().substring(1);
        String[] uri = nodePathUrl.split("/");
        if (uri == null || uri.length < 3) {
            return mapParam;
        }
        patternUrl = Pattern.compile("([^/]+)/([^/]+)/([^/]+)/(.*)");
        matcher = patternUrl.matcher(nodePathUrl);
        if (matcher.find()) {
            mapParam.put(REPOSITORY, matcher.group(2));
            mapParam.put("drive", matcher.group(3));
            mapParam.put("path", "/" + matcher.group(4));
        } else {
            patternUrl = Pattern.compile("([^/]+)/([^/]+)/(.*)");
            matcher = patternUrl.matcher(nodePathUrl);
            if (matcher.find()) {
                mapParam.put(REPOSITORY, matcher.group(2));
                mapParam.put("drive", matcher.group(3));
                mapParam.put("path", "/");
            }
        }
        return mapParam;
    }

    private void showDocument(WebuiRequestContext context, HashMap<String, String> map) throws Exception {
        String repositoryName = String.valueOf(map.get(REPOSITORY));
        String driveName = String.valueOf(map.get("drive"));
        String path = String.valueOf(map.get("path"));
        if (!path.equals("/")) {
            ArrayList<String> encodeNameArr = new ArrayList<String>();
            for (String name : path.split("/")) {
                if (name.length() <= 0) continue;
                encodeNameArr.add(Text.escapeIllegalJcrChars((String)name));
            }
            StringBuilder encodedPath = new StringBuilder();
            for (String encodedName : encodeNameArr) {
                encodedPath.append("/").append(encodedName);
            }
            path = encodedPath.toString();
        }
        UIApplication uiApp = (UIApplication)this.findFirstComponentOfType(UIApplication.class);
        ManageDriveService manageDrive = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        DriveData driveData = null;
        try {
            driveData = manageDrive.getDriveByName(driveName, repositoryName);
            if (driveData == null) {
                throw new PathNotFoundException();
            }
        }
        catch (PathNotFoundException e) {
            Object[] args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.drive-not-exist", args, 1));
            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> viewList = new ArrayList<String>();
        for (String role : Utils.getMemberships()) {
            for (String viewName : driveData.getViews().split(",")) {
                if (viewList.contains(viewName.trim())) continue;
                Node viewNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), repositoryName, SessionProviderFactory.createSystemProvider());
                String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                if (permiss.contains("${userId}")) {
                    permiss = permiss.replace("${userId}", userId);
                }
                String[] viewPermissions = permiss.split(",");
                if (permiss.equals("*")) {
                    viewList.add(viewName.trim());
                }
                if (!driveData.hasPermission(viewPermissions, role)) continue;
                viewList.add(viewName.trim());
            }
        }
        String viewListStr = "";
        ArrayList<SelectItemOption> viewOptions = new ArrayList<SelectItemOption>();
        ResourceBundle res = context.getApplicationResourceBundle();
        String viewLabel = null;
        for (String viewName : viewList) {
            try {
                viewLabel = res.getString("Views.label." + viewName);
            }
            catch (MissingResourceException e) {
                viewLabel = viewName;
            }
            viewOptions.add(new SelectItemOption(viewLabel, (Object)viewName));
            if (viewListStr.length() > 0) {
                viewListStr = viewListStr + "," + viewName;
                continue;
            }
            viewListStr = viewName;
        }
        driveData.setViews(viewListStr);
        String homePath = driveData.getHomePath();
        if (homePath.contains("${userId}")) {
            homePath = homePath.replace("${userId}", userId);
        }
        this.setFlagSelect(true);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.findFirstComponentOfType(UIJCRExplorer.class);
        Preference pref = uiExplorer.getPreference();
        pref.setShowSideBar(driveData.getViewSideBar());
        pref.setShowNonDocumentType(driveData.getViewNonDocument());
        pref.setShowPreferenceDocuments(driveData.getViewPreferences());
        pref.setAllowCreateFoder(driveData.getAllowCreateFolders());
        pref.setShowHiddenNode(driveData.getShowHiddenNode());
        uiExplorer.setDriveData(driveData);
        uiExplorer.setIsReferenceNode(false);
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        ManageableRepository repository = rservice.getRepository(repositoryName);
        try {
            Session session = provider.getSession(driveData.getWorkspace(), repository);
            session.getItem(homePath);
        }
        catch (AccessDeniedException ace) {
            Object[] args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.access-denied", args, 1));
            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (NoSuchWorkspaceException nosuchWS) {
            Object[] args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.workspace-not-exist", args, 1));
            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        uiExplorer.setRepositoryName(repositoryName);
        uiExplorer.setWorkspaceName(driveData.getWorkspace());
        uiExplorer.setRootPath(homePath);
        path = homePath.concat(path).replaceAll("/+", "/");
        UIControl uiControl = (UIControl)uiExplorer.getChild(UIControl.class);
        UIActionBar uiActionbar = (UIActionBar)uiControl.getChild(UIActionBar.class);
        uiActionbar.setTabOptions((String)viewList.get(0));
        UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
        uiAddressBar.setViewList(viewList);
        uiAddressBar.setSelectedViewName((String)viewList.get(0));
        uiExplorer.setSelectNode(driveData.getWorkspace(), path);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.findFirstComponentOfType(UIWorkingArea.class);
        UIDocumentWorkspace uiDocWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        uiDocWorkspace.setRenderedChild(UIDocumentContainer.class);
        UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        if (popupAction != null && popupAction.isRendered()) {
            popupAction.deActivate();
            context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        uiExplorer.refreshExplorer();
        uiExplorer.setRenderSibling(UIJCRExplorer.class);
    }
}

