/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exoplatform.common.http.client.AuthSchemeNotImplException;
import org.exoplatform.common.http.client.AuthorizationHandler;
import org.exoplatform.common.http.client.Codecs;
import org.exoplatform.common.http.client.DefaultAuthHandler;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.MD5;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.RoResponse;
import org.exoplatform.common.http.client.Util;

public class AuthorizationInfo
implements Cloneable {
    private static Hashtable CntxtList = new Hashtable();
    private static AuthorizationHandler AuthHandler = new DefaultAuthHandler();
    private String host;
    private int port;
    private String scheme;
    private String realm;
    private String cookie;
    private NVPair[] auth_params = new NVPair[0];
    private Object extra_info = null;
    private String[] paths = new String[0];

    AuthorizationInfo(String host, int port) {
        this.host = host.trim().toLowerCase();
        this.port = port;
    }

    public AuthorizationInfo(String host, int port, String scheme, String realm, NVPair[] params, Object info) {
        this.scheme = scheme.trim();
        this.host = host.trim().toLowerCase();
        this.port = port;
        this.realm = realm;
        this.cookie = null;
        if (params != null) {
            this.auth_params = Util.resizeArray(params, params.length);
        }
        this.extra_info = info;
    }

    public AuthorizationInfo(String host, int port, String scheme, String realm, String cookie) {
        this.scheme = scheme.trim();
        this.host = host.trim().toLowerCase();
        this.port = port;
        this.realm = realm;
        this.cookie = cookie != null ? cookie.trim() : null;
    }

    AuthorizationInfo(AuthorizationInfo templ) {
        this.scheme = templ.scheme;
        this.host = templ.host;
        this.port = templ.port;
        this.realm = templ.realm;
        this.cookie = templ.cookie;
        this.auth_params = Util.resizeArray(templ.auth_params, templ.auth_params.length);
        this.extra_info = templ.extra_info;
    }

    public static AuthorizationHandler setAuthHandler(AuthorizationHandler handler) {
        AuthorizationHandler tmp = AuthHandler;
        AuthHandler = handler;
        return tmp;
    }

    public static AuthorizationHandler getAuthHandler() {
        return AuthHandler;
    }

    public static AuthorizationInfo getAuthorization(String host, int port, String scheme, String realm) {
        return AuthorizationInfo.getAuthorization(host, port, scheme, realm, HTTPConnection.getDefaultContext());
    }

    public static synchronized AuthorizationInfo getAuthorization(String host, int port, String scheme, String realm, Object context) {
        Hashtable AuthList = Util.getList(CntxtList, context);
        AuthorizationInfo auth_info = new AuthorizationInfo(host, port, scheme, realm, null, null);
        return (AuthorizationInfo)AuthList.get(auth_info);
    }

    static AuthorizationInfo queryAuthHandler(AuthorizationInfo auth_info, RoRequest req, RoResponse resp) throws AuthSchemeNotImplException, IOException {
        if (AuthHandler == null) {
            return null;
        }
        AuthorizationInfo new_info = AuthHandler.getAuthorization(auth_info, req, resp);
        if (new_info != null) {
            if (req != null) {
                AuthorizationInfo.addAuthorization((AuthorizationInfo)new_info.clone(), req.getConnection().getContext());
            } else {
                AuthorizationInfo.addAuthorization((AuthorizationInfo)new_info.clone(), HTTPConnection.getDefaultContext());
            }
        }
        return new_info;
    }

    static synchronized AuthorizationInfo getAuthorization(AuthorizationInfo auth_info, RoRequest req, RoResponse resp, boolean query_auth_h) throws AuthSchemeNotImplException, IOException {
        Hashtable AuthList = req != null ? Util.getList(CntxtList, req.getConnection().getContext()) : Util.getList(CntxtList, HTTPConnection.getDefaultContext());
        AuthorizationInfo new_info = (AuthorizationInfo)AuthList.get(auth_info);
        if (new_info == null && query_auth_h) {
            new_info = AuthorizationInfo.queryAuthHandler(auth_info, req, resp);
        }
        return new_info;
    }

    static AuthorizationInfo getAuthorization(String host, int port, String scheme, String realm, RoRequest req, RoResponse resp, boolean query_auth_h) throws AuthSchemeNotImplException, IOException {
        return AuthorizationInfo.getAuthorization(new AuthorizationInfo(host, port, scheme, realm, null, null), req, resp, query_auth_h);
    }

    public static void addAuthorization(AuthorizationInfo auth_info) {
        AuthorizationInfo.addAuthorization(auth_info, HTTPConnection.getDefaultContext());
    }

    public static void addAuthorization(AuthorizationInfo auth_info, Object context) {
        Hashtable AuthList = Util.getList(CntxtList, context);
        AuthorizationInfo old_info = (AuthorizationInfo)AuthList.get(auth_info);
        if (old_info != null) {
            int ol = old_info.paths.length;
            int al = auth_info.paths.length;
            if (al == 0) {
                auth_info.paths = old_info.paths;
            } else {
                auth_info.paths = Util.resizeArray(auth_info.paths, al + ol);
                System.arraycopy(old_info.paths, 0, auth_info.paths, al, ol);
            }
        }
        AuthList.put(auth_info, auth_info);
    }

    public static void addAuthorization(String host, int port, String scheme, String realm, String cookie, NVPair[] params, Object info) {
        AuthorizationInfo.addAuthorization(host, port, scheme, realm, cookie, params, info, HTTPConnection.getDefaultContext());
    }

    public static void addAuthorization(String host, int port, String scheme, String realm, String cookie, NVPair[] params, Object info, Object context) {
        AuthorizationInfo auth = new AuthorizationInfo(host, port, scheme, realm, cookie);
        if (params != null && params.length > 0) {
            auth.auth_params = Util.resizeArray(params, params.length);
        }
        auth.extra_info = info;
        AuthorizationInfo.addAuthorization(auth, context);
    }

    public static void addBasicAuthorization(String host, int port, String realm, String user, String passwd) {
        AuthorizationInfo.addAuthorization(host, port, "Basic", realm, Codecs.base64Encode(user + ":" + passwd), null, null);
    }

    public static void addBasicAuthorization(String host, int port, String realm, String user, String passwd, Object context) {
        AuthorizationInfo.addAuthorization(host, port, "Basic", realm, Codecs.base64Encode(user + ":" + passwd), null, null, context);
    }

    public static void addDigestAuthorization(String host, int port, String realm, String user, String passwd) {
        AuthorizationInfo.addDigestAuthorization(host, port, realm, user, passwd, HTTPConnection.getDefaultContext());
    }

    public static void addDigestAuthorization(String host, int port, String realm, String user, String passwd, Object context) {
        NVPair[] params;
        AuthorizationInfo prev = AuthorizationInfo.getAuthorization(host, port, "Digest", realm, context);
        if (prev == null) {
            params = new NVPair[]{new NVPair("username", user), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            params = prev.getParams();
            for (int idx = 0; idx < params.length; ++idx) {
                if (!params[idx].getName().equalsIgnoreCase("username")) continue;
                params[idx] = new NVPair("username", user);
                break;
            }
        }
        String[] extra = new String[]{MD5.hexDigest(user + ":" + realm + ":" + passwd), null, null};
        AuthorizationInfo.addAuthorization(host, port, "Digest", realm, null, params, extra, context);
    }

    public static void removeAuthorization(AuthorizationInfo auth_info) {
        AuthorizationInfo.removeAuthorization(auth_info, HTTPConnection.getDefaultContext());
    }

    public static void removeAuthorization(AuthorizationInfo auth_info, Object context) {
        Hashtable AuthList = Util.getList(CntxtList, context);
        AuthList.remove(auth_info);
    }

    public static void removeAuthorization(String host, int port, String scheme, String realm) {
        AuthorizationInfo.removeAuthorization(new AuthorizationInfo(host, port, scheme, realm, null, null));
    }

    public static void removeAuthorization(String host, int port, String scheme, String realm, Object context) {
        AuthorizationInfo.removeAuthorization(new AuthorizationInfo(host, port, scheme, realm, null, null), context);
    }

    static AuthorizationInfo findBest(RoRequest req) {
        String path = Util.getPath(req.getRequestURI());
        String host = req.getConnection().getHost();
        int port = req.getConnection().getPort();
        Hashtable AuthList = Util.getList(CntxtList, req.getConnection().getContext());
        Enumeration list = AuthList.elements();
        while (list.hasMoreElements()) {
            AuthorizationInfo info = (AuthorizationInfo)list.nextElement();
            if (!info.host.equals(host) || info.port != port) continue;
            String[] paths = info.paths;
            for (int idx = 0; idx < paths.length; ++idx) {
                if (!path.equals(paths[idx])) continue;
                return info;
            }
        }
        AuthorizationInfo best = null;
        String base = path.substring(0, path.lastIndexOf(47) + 1);
        int min = Integer.MAX_VALUE;
        list = AuthList.elements();
        while (list.hasMoreElements()) {
            AuthorizationInfo info = (AuthorizationInfo)list.nextElement();
            if (!info.host.equals(host) || info.port != port) continue;
            String[] paths = info.paths;
            for (int idx = 0; idx < paths.length; ++idx) {
                int pos;
                int num_seg;
                String ibase = paths[idx].substring(0, paths[idx].lastIndexOf(47) + 1);
                if (base.equals(ibase)) {
                    return info;
                }
                if (base.startsWith(ibase)) {
                    num_seg = 0;
                    pos = ibase.length() - 1;
                    while ((pos = base.indexOf(47, pos + 1)) != -1) {
                        ++num_seg;
                    }
                    if (num_seg >= min) continue;
                    min = num_seg;
                    best = info;
                    continue;
                }
                if (!ibase.startsWith(base)) continue;
                num_seg = 0;
                pos = base.length();
                while ((pos = ibase.indexOf(47, pos + 1)) != -1) {
                    ++num_seg;
                }
                if (num_seg >= min) continue;
                min = num_seg;
                best = info;
            }
        }
        return best;
    }

    public synchronized void addPath(String resource) {
        String path = Util.getPath(resource);
        for (int idx = 0; idx < this.paths.length; ++idx) {
            if (!this.paths[idx].equals(path)) continue;
            return;
        }
        this.paths = Util.resizeArray(this.paths, this.paths.length + 1);
        this.paths[this.paths.length - 1] = path;
    }

    static AuthorizationInfo[] parseAuthString(String challenge, RoRequest req, RoResponse resp) throws ProtocolException {
        int beg = 0;
        int end = 0;
        char[] buf = challenge.toCharArray();
        int len = buf.length;
        int[] pos_ref = new int[2];
        AuthorizationInfo[] auth_arr = new AuthorizationInfo[]{};
        while (Character.isWhitespace(buf[len - 1])) {
            --len;
        }
        while ((beg = Util.skipSpace(buf, beg)) != len) {
            int sts;
            end = Util.findSpace(buf, beg + 1);
            try {
                sts = resp.getStatusCode();
            }
            catch (IOException ioe) {
                throw new ProtocolException(ioe.toString());
            }
            AuthorizationInfo curr = sts == 401 ? new AuthorizationInfo(req.getConnection().getHost(), req.getConnection().getPort()) : new AuthorizationInfo(req.getConnection().getProxyHost(), req.getConnection().getProxyPort());
            if (buf[end - 1] == ',') {
                curr.scheme = challenge.substring(beg, end - 1);
                beg = end;
            } else {
                curr.scheme = challenge.substring(beg, end);
                pos_ref[0] = beg;
                pos_ref[1] = end;
                Vector params = AuthorizationInfo.parseParams(challenge, buf, pos_ref, len, curr);
                beg = pos_ref[0];
                end = pos_ref[1];
                if (!params.isEmpty()) {
                    curr.auth_params = new NVPair[params.size()];
                    params.copyInto(curr.auth_params);
                }
            }
            if (curr.realm == null) {
                curr.realm = "";
            }
            auth_arr = Util.resizeArray(auth_arr, auth_arr.length + 1);
            auth_arr[auth_arr.length - 1] = curr;
        }
        return auth_arr;
    }

    private static final Vector parseParams(String challenge, char[] buf, int[] pos_ref, int len, AuthorizationInfo curr) throws ProtocolException {
        int beg = pos_ref[0];
        int end = pos_ref[1];
        boolean first = true;
        Vector<NVPair> params = new Vector<NVPair>();
        while ((beg = Util.skipSpace(buf, end)) != len) {
            String param_value;
            if (!first) {
                if (buf[beg] != ',') {
                    throw new ProtocolException("Bad Authentication header format: '" + challenge + "'\nExpected \",\" at position " + beg);
                }
                if ((beg = Util.skipSpace(buf, beg + 1)) == len) break;
                if (buf[beg] == ',') {
                    end = beg;
                    continue;
                }
            }
            int pstart = beg;
            for (end = beg + 1; end < len && !Character.isWhitespace(buf[end]) && buf[end] != '=' && buf[end] != ','; ++end) {
            }
            if (first && (end == len || buf[end] == '=' && (end + 1 == len || buf[end + 1] == '=' && end + 2 == len))) {
                curr.cookie = challenge.substring(beg, len);
                beg = len;
                break;
            }
            String param_name = challenge.substring(beg, end);
            beg = Util.skipSpace(buf, end);
            if (beg < len && buf[beg] != '=' && buf[beg] != ',' || !first && (beg == len || buf[beg] == ',')) {
                beg = pstart;
                break;
            }
            if (beg < len && buf[beg] == '=') {
                if ((beg = Util.skipSpace(buf, beg + 1)) == len) {
                    throw new ProtocolException("Bad Authentication header format: " + challenge + "\nUnexpected EOL after token" + " at position " + (end - 1));
                }
                if (buf[beg] != '\"') {
                    end = Util.skipToken(buf, beg);
                    if (end == beg) {
                        throw new ProtocolException("Bad Authentication header format: " + challenge + "\nToken expected at " + "position " + beg);
                    }
                    param_value = challenge.substring(beg, end);
                } else {
                    end = beg++;
                    while ((end = challenge.indexOf(34, end + 1)) != -1 && challenge.charAt(end - 1) == '\\') {
                    }
                    if (end == -1) {
                        throw new ProtocolException("Bad Authentication header format: " + challenge + "\nClosing <\"> for " + "quoted-string starting at position " + beg + " not found");
                    }
                    param_value = Util.dequoteString(challenge.substring(beg, end));
                    ++end;
                }
            } else {
                param_value = null;
            }
            if (param_name.equalsIgnoreCase("realm")) {
                curr.realm = param_value;
            } else {
                params.addElement(new NVPair(param_name, param_value));
            }
            first = false;
        }
        pos_ref[0] = beg;
        pos_ref[1] = end;
        return params;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final String getRealm() {
        return this.realm;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public final NVPair[] getParams() {
        return Util.resizeArray(this.auth_params, this.auth_params.length);
    }

    public final void setParams(NVPair[] params) {
        this.auth_params = params != null ? Util.resizeArray(params, params.length) : new NVPair[0];
    }

    public final Object getExtraInfo() {
        return this.extra_info;
    }

    public final void setExtraInfo(Object info) {
        this.extra_info = info;
    }

    public String toString() {
        StringBuffer field = new StringBuffer(100);
        field.append(this.scheme);
        field.append(" ");
        if (this.cookie != null) {
            field.append(this.cookie);
        } else {
            if (this.realm.length() > 0) {
                field.append("realm=\"");
                field.append(Util.quoteString(this.realm, "\\\""));
                field.append('\"');
            }
            for (int idx = 0; idx < this.auth_params.length; ++idx) {
                field.append(',');
                field.append(this.auth_params[idx].getName());
                if (this.auth_params[idx].getValue() == null) continue;
                field.append("=\"");
                field.append(Util.quoteString(this.auth_params[idx].getValue(), "\\\""));
                field.append('\"');
            }
        }
        return field.toString();
    }

    public int hashCode() {
        return (this.host + this.scheme.toLowerCase() + this.realm).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AuthorizationInfo) {
            AuthorizationInfo auth = (AuthorizationInfo)obj;
            if (this.host.equals(auth.host) && this.port == auth.port && this.scheme.equalsIgnoreCase(auth.scheme) && this.realm.equals(auth.realm)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        AuthorizationInfo ai;
        try {
            ai = (AuthorizationInfo)super.clone();
            ai.auth_params = Util.resizeArray(this.auth_params, this.auth_params.length);
            try {
                ai.extra_info = this.extra_info.getClass().getMethod("clone", null).invoke(this.extra_info, null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ai.paths = new String[this.paths.length];
            System.arraycopy(this.paths, 0, ai.paths, 0, this.paths.length);
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
        return ai;
    }

    static {
        CntxtList.put(HTTPConnection.getDefaultContext(), new Hashtable());
    }
}

