/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.webdav;

import java.io.InputStream;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.webdav.method.CHECKIN;
import org.exoplatform.services.rest.ext.webdav.method.CHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.COPY;
import org.exoplatform.services.rest.ext.webdav.method.LOCK;
import org.exoplatform.services.rest.ext.webdav.method.OPTIONS;
import org.exoplatform.services.rest.ext.webdav.method.ORDERPATCH;
import org.exoplatform.services.rest.ext.webdav.method.PROPFIND;
import org.exoplatform.services.rest.ext.webdav.method.PROPPATCH;
import org.exoplatform.services.rest.ext.webdav.method.REPORT;
import org.exoplatform.services.rest.ext.webdav.method.SEARCH;
import org.exoplatform.services.rest.ext.webdav.method.UNCHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.UNLOCK;
import org.exoplatform.services.rest.ext.webdav.method.VERSIONCONTROL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/jcr/")
public class WebDavServiceImpl
extends org.exoplatform.services.jcr.webdav.WebDavServiceImpl {
    private static Log log = ExoLogger.getLogger((String)"cms.webdav.WebDavServiceImpl");
    private final NodeFinder nodeFinder;

    public WebDavServiceImpl(InitParams params, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, NodeFinder nodeFinder) throws Exception {
        super(params, repositoryService, sessionProviderService);
        this.nodeFinder = nodeFinder;
    }

    private String getRealDestinationHeader(String baseURI, String repoName, String destinationHeader) {
        String serverURI = baseURI + "/jcr/" + repoName;
        if (!(destinationHeader = TextUtil.unescape((String)destinationHeader, (char)'%')).startsWith(serverURI)) {
            return null;
        }
        String destPath = destinationHeader.substring(serverURI.length() + 1);
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(destPath), LinkUtils.getParentPath(this.path(destPath)), true);
            return item.getSession().getWorkspace().getName() + LinkUtils.createPath(item.getPath(), LinkUtils.getItemName(this.path(destPath)));
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + destPath), (Throwable)e);
            return null;
        }
    }

    @CHECKIN
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkin(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.checkin(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @CHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.checkout(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @COPY
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response copy(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)));
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        String realDestinationHeader = this.getRealDestinationHeader(uriInfo.getPath(), repoName, destinationHeader);
        if (realDestinationHeader != null) {
            destinationHeader = realDestinationHeader;
        }
        return super.copy(repoName, repoPath, destinationHeader, lockTokenHeader, ifHeader, depthHeader, overwriteHeader, uriInfo, body);
    }

    @GET
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response get(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Range") String rangeHeader, @HeaderParam(value="If-Modified-Since") String ifModifiedSince, @QueryParam(value="version") String version, @Context UriInfo uriInfo) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.get(repoName, repoPath, rangeHeader, null, version, uriInfo);
    }

    @HEAD
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response head(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.head(repoName, repoPath, uriInfo);
    }

    @LOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response lock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.lock(repoName, repoPath, lockTokenHeader, ifHeader, depthHeader, body);
    }

    @UNLOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response unlock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.unlock(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @OPTIONS
    @Path(value="/{repoName}/{path:.*}/")
    public Response options(@PathParam(value="path") String path) {
        return super.options(path);
    }

    @ORDERPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response order(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.order(repoName, repoPath, lockTokenHeader, ifHeader, uriInfo, body);
    }

    @PROPFIND
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response propfind(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.propfind(repoName, repoPath, depthHeader, uriInfo, body);
    }

    @PROPPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response proppatch(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.proppatch(repoName, repoPath, lockTokenHeader, ifHeader, uriInfo, body);
    }

    @PUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response put(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="File-NodeType") String fileNodeTypeHeader, @HeaderParam(value="Content-NodeType") String nodeTypeHeader, @HeaderParam(value="Content-MixinTypes") List<String> mixinTypes, @HeaderParam(value="Content-type") MediaType mediaType, InputStream inputStream) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), LinkUtils.getParentPath(this.path(Text.escapeIllegalJcrChars(repoPath))), true);
            repoPath = item.getSession().getWorkspace().getName() + LinkUtils.createPath(item.getPath(), LinkUtils.getItemName(this.path(repoPath)));
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.put(repoName, repoPath, lockTokenHeader, ifHeader, nodeTypeHeader, null, mixinTypes, mediaType, inputStream);
    }

    @REPORT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response report(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.report(repoName, repoPath, depthHeader, uriInfo, body);
    }

    @SEARCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response search(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.search(repoName, repoPath, uriInfo, body);
    }

    @UNCHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response uncheckout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.uncheckout(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @VERSIONCONTROL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response versionControl(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            Item item = this.nodeFinder.getItem(repoName, this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
            repoPath = item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            return Response.serverError().build();
        }
        return super.versionControl(repoName, repoPath, lockTokenHeader, ifHeader);
    }
}

