/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.javascript;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.picocontainer.Startable;

public class XJavascriptService
implements Startable {
    private static String WEBCONTENT_JS_QUERY = "select * from exo:jsFile where jcr:path like '{path}/%' and exo:active='true' order by exo:priority ASC".intern();
    private final String MODULE_NAME = "eXo.WCM.Live".intern();
    private final String PATH = "/javascript/eXo/{portalName}/live".intern();
    private JavascriptConfigService jsConfigService;
    private WCMConfigurationService configurationService;
    private ServletContext sContext;
    private Log log = ExoLogger.getLogger((String)"wcm:XJavascriptService");

    public XJavascriptService() throws Exception {
        this.jsConfigService = WCMCoreUtils.getService(JavascriptConfigService.class);
        this.sContext = WCMCoreUtils.getService(ServletContext.class);
        this.configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
    }

    public String getActiveJavaScript(Node webcontent) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String jsQuery = StringUtils.replaceOnce((String)WEBCONTENT_JS_QUERY, (String)"{path}", (String)webcontent.getPath());
        NodeLocation webcontentLocation = NodeLocation.make(webcontent);
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository repository = repositoryService.getRepository(webcontentLocation.getRepository());
        Session session = null;
        session = webcontentLocation.getPath().startsWith("/jcr:system") ? repository.getSystemSession(repository.getConfiguration().getSystemWorkspaceName()) : repository.getSystemSession(webcontentLocation.getWorkspace());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(jsQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iterator = queryResult.getNodes();
        while (iterator.hasNext()) {
            Node registeredJSFile = iterator.nextNode();
            buffer.append(registeredJSFile.getNode("jcr:content").getProperty("jcr:data").getString());
        }
        session.logout();
        return buffer.toString();
    }

    public void updatePortalJSOnModify(Node portalNode, Node jsFile) throws Exception {
        String repository = ((ManageableRepository)portalNode.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portalNode.getName())) {
            this.addSharedPortalJavascript(portalNode, jsFile, false);
        } else {
            this.addPortalJavascript(portalNode, jsFile, false);
        }
    }

    public void updatePortalJSOnRemove(Node portalNode, Node jsFile) throws Exception {
        String repository = ((ManageableRepository)portalNode.getSession().getRepository()).getConfiguration().getName();
        String sharedPortalName = this.configurationService.getSharedPortalName(repository);
        if (sharedPortalName.equals(portalNode.getName())) {
            this.addSharedPortalJavascript(portalNode, jsFile, false);
        } else {
            this.addPortalJavascript(portalNode, jsFile, false);
        }
    }

    private void addPortalJavascript(Node portalNode, Node jsFile, boolean isStartup) throws Exception {
        String javascriptPath = StringUtils.replaceOnce((String)this.PATH, (String)"{portalName}", (String)portalNode.getName());
        if (this.jsConfigService.isModuleLoaded((CharSequence)this.MODULE_NAME)) {
            this.jsConfigService.removeExtendedJavascript(this.MODULE_NAME, javascriptPath, this.sContext);
        }
    }

    private void addSharedPortalJavascript(Node portalNode, Node jsFile, boolean isStartup) throws Exception {
        String javascriptPath = StringUtils.replaceOnce((String)this.PATH, (String)"{portalName}", (String)portalNode.getName());
        if (this.jsConfigService.isModuleLoaded((CharSequence)this.MODULE_NAME)) {
            this.jsConfigService.removeExtendedJavascript(this.MODULE_NAME, javascriptPath, this.sContext);
        }
    }

    public void start() {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalJavascript(sharedPortal, null, true);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalJavascript(portal, null, true);
            }
        }
        catch (PathNotFoundException e) {
            this.log.warn((Object)"Exception when merging inside Portal : WCM init is not completed.");
        }
        catch (Exception e) {
            this.log.error((Object)"Exception when start XJavascriptService");
        }
    }

    public void stop() {
    }
}

