/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.jcr.ext.replication.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelNotConnectedException;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelWasDisconnectedException;
import org.exoplatform.services.jcr.ext.replication.transport.ConnectionListener;
import org.exoplatform.services.jcr.ext.replication.transport.MemberAddress;
import org.exoplatform.services.jcr.ext.replication.transport.PacketListener;
import org.exoplatform.services.jcr.ext.replication.transport.PacketTransformer;
import org.exoplatform.services.jcr.ext.replication.transport.StateEvent;
import org.exoplatform.services.jcr.ext.replication.transport.StateListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelManager
implements RequestHandler,
MembershipListener {
    public static final int INITIALIZED = 1;
    public static final int CONNECTED = 2;
    public static final int DISCONNECTED = 3;
    private static final Log LOG = ExoLogger.getLogger("ext.AsyncChannelManager");
    protected int state = 1;
    protected JChannel channel;
    protected MessageDispatcher dispatcher;
    protected final String channelConfig;
    protected final String channelName;
    private final int confMembersCount;
    private List<PacketListener> packetListeners;
    private List<StateListener> stateListeners;
    private final List<ConnectionListener> connectionListeners;
    protected final PacketHandler packetsHandler;
    private CountDownLatch latch;

    public ChannelManager(String channelConfig, String channelName, int confMembersCount) {
        this.channelConfig = channelConfig;
        this.channelName = channelName;
        this.confMembersCount = confMembersCount;
        this.packetListeners = new ArrayList<PacketListener>();
        this.stateListeners = new ArrayList<StateListener>();
        this.connectionListeners = new ArrayList<ConnectionListener>();
        this.packetsHandler = new PacketHandler();
        this.packetsHandler.start();
    }

    public boolean isConnected() {
        return this.channel != null;
    }

    public void connect() throws ReplicationException {
        try {
            if (this.channel == null) {
                this.latch = new CountDownLatch(1);
                this.channel = new JChannel(this.channelConfig);
                this.channel.setOpt(5, (Object)Boolean.TRUE);
                this.channel.setOpt(6, (Object)Boolean.TRUE);
                this.dispatcher = new MessageDispatcher((Channel)this.channel, null, null, null);
                this.dispatcher.setRequestHandler((RequestHandler)this);
                this.dispatcher.setMembershipListener((MembershipListener)this);
            }
        }
        catch (ChannelException e) {
            throw new ReplicationException("Can't create JGroups channel", e);
        }
        LOG.info("Channel name : " + this.channelName);
        try {
            this.channel.connect(this.channelName);
            this.state = 2;
        }
        catch (ChannelException e) {
            throw new ReplicationException("Can't connect to JGroups channel", e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public synchronized void disconnect() {
        this.state = 3;
        if (this.dispatcher != null) {
            this.dispatcher.setRequestHandler(null);
            this.dispatcher.setMembershipListener(null);
            this.dispatcher.stop();
            this.dispatcher = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("dispatcher stopped");
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOG.error("The interapted on disconnect : " + e, e);
            }
        }
        if (this.channel != null) {
            this.channel.disconnect();
            if (LOG.isDebugEnabled()) {
                LOG.debug("channel disconnected");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error("The interapted on disconnect : " + e, e);
            }
            this.channel.close();
            this.channel = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disconnect done, fire connection listeners");
            }
            for (ConnectionListener cl : this.connectionListeners) {
                cl.onDisconnect();
            }
        }
    }

    public void addPacketListener(PacketListener packetListener) {
        this.packetListeners.add(packetListener);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.packetListeners.remove(packetListener);
    }

    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public MessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public List<MemberAddress> getOtherMembers() {
        ArrayList list = new ArrayList(this.channel.getView().getMembers());
        list.remove(this.channel.getLocalAddress());
        ArrayList<MemberAddress> members = new ArrayList<MemberAddress>();
        for (Address address : list) {
            members.add(new MemberAddress(address));
        }
        return members;
    }

    public void sendPacket(AbstractPacket packet, MemberAddress ... destinations) throws IOException {
        Vector<Address> dest;
        if (this.latch != null && this.latch.getCount() != 0L) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.state == 2) {
            dest = new Vector<Address>();
            for (MemberAddress address : destinations) {
                dest.add(address.getAddress());
            }
        } else {
            if (this.state == 1) {
                throw new ChannelNotConnectedException("The channel is not connected.");
            }
            throw new ChannelWasDisconnectedException("The channel was disconnected.");
        }
        this.sendPacket(packet, dest);
    }

    private void sendPacket(AbstractPacket packet, Vector<Address> dest) throws IOException {
        if (this.state == 2) {
            byte[] buffer = PacketTransformer.getAsByteArray(packet);
            Message msg = new Message(null, null, buffer);
            if (this.state == 3 || this.dispatcher == null) {
                throw new ChannelWasDisconnectedException("The channel was disconnected.");
            }
            this.dispatcher.castMessage(dest, msg, 6, 0L);
        }
    }

    public void sendPacket(AbstractPacket packet) throws IOException {
        if (this.latch != null && this.latch.getCount() != 0L) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.state != 2) {
            if (this.state == 1) {
                throw new ChannelNotConnectedException("The channel is not connected.");
            }
            throw new ChannelWasDisconnectedException("The channel was disconnected.");
        }
        Vector<Address> dest = new Vector<Address>(this.channel.getView().getMembers());
        dest.remove(this.channel.getLocalAddress());
        this.sendPacket(packet, dest);
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public Object handle(Message message) {
        if (this.isConnected()) {
            try {
                this.packetsHandler.add(PacketTransformer.getAsPacket(message.getBuffer()), new MemberAddress(message.getSrc()));
                if (this.channel.getView() != null) {
                    if (this.channel.getView().getMembers().size() == this.confMembersCount) {
                        this.packetsHandler.handle();
                    } else {
                        LOG.warn("Not all members connected to the channel " + this.channel.getView().getMembers().size() + " != " + this.confMembersCount + ", queue message " + message);
                    }
                } else {
                    LOG.warn("No members found or channel closed, queue message " + message);
                }
                return new String("Success");
            }
            catch (IOException e) {
                LOG.error("Message handler error " + e, e);
                return e.getMessage();
            }
            catch (ClassNotFoundException e) {
                LOG.error("Message handler error " + e, e);
                return e.getMessage();
            }
        }
        LOG.warn("Channel is closed but message received " + message);
        return new String("Disconnected");
    }

    public void viewAccepted(View view) {
        if (this.isConnected()) {
            LOG.info("View accepted " + view.printDetails());
            ArrayList<MemberAddress> members = new ArrayList<MemberAddress>();
            for (Address address : view.getMembers()) {
                members.add(new MemberAddress(address));
            }
            StateEvent event = new StateEvent(new MemberAddress(this.channel.getLocalAddress()), members);
            for (StateListener listener : this.stateListeners) {
                listener.onStateChanged(event);
            }
            this.packetsHandler.handle();
        } else {
            LOG.warn("Channel is closed but View accepted " + view.printDetails());
        }
    }

    public void block() {
    }

    public void suspect(Address arg0) {
    }

    protected class PacketHandler
    extends Thread {
        private final Object lock = new Object();
        private final ConcurrentLinkedQueue<MemberPacket> queue = new ConcurrentLinkedQueue();
        private MemberPacket current;

        protected PacketHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.current = this.queue.poll();
                            while (this.current != null) {
                                PacketListener[] pl;
                                for (PacketListener handler : pl = ChannelManager.this.packetListeners.toArray(new PacketListener[ChannelManager.this.packetListeners.size()])) {
                                    handler.receive(this.current.packet, this.current.member);
                                }
                                this.current = this.queue.poll();
                            }
                            this.lock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Cannot handle the queue. Wait lock failed " + e, e);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error("Cannot handle the queue now. Error " + e, e);
                    try {
                        PacketHandler.sleep(5000L);
                        continue;
                    }
                    catch (Throwable e1) {
                        LOG.error("Sleep error " + e1);
                        continue;
                    }
                }
                break;
            }
        }

        public void add(AbstractPacket packet, MemberAddress member) {
            this.queue.add(new MemberPacket(packet, member));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle() {
            if (this.current == null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                Thread.yield();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Handler already active, queue size : " + this.queue.size());
            }
        }
    }

    class MemberPacket {
        final AbstractPacket packet;
        final MemberAddress member;

        MemberPacket(AbstractPacket packet, MemberAddress member) {
            this.packet = packet;
            this.member = member;
        }
    }
}

