/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.exoplatform.wcm.connector.FileUploadHandler;
import org.exoplatform.wcm.connector.handler.FCKFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/wcmDriver/")
public class DriverConnector
extends BaseConnector
implements ResourceContainer {
    public static final String FILE_TYPE_WEBCONTENT = "Web Contents";
    public static final String FILE_TYPE_DMSDOC = "DMS Documents";
    public static final String FILE_TYPE_MEDIAS = "Medias";
    public static final String[] MEDIA_MIMETYPE = new String[]{"application", "image", "audio", "video"};
    private static Log log = ExoLogger.getLogger(DriverConnector.class);
    private int limit;
    private PortalContainer manager;
    private OrganizationService organizationService;
    private ResourceBundleService resourceBundleService;
    private String[] resourceBundleNames;

    public DriverConnector(InitParams params) {
        this.limit = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
        this.manager = PortalContainer.getInstance();
        this.organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        this.resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        this.resourceBundleNames = this.resourceBundleService.getSharedResourceBundleNames();
    }

    @GET
    @Path(value="/getDrivers/")
    public Response getDrivers(@QueryParam(value="lang") String lang) throws Exception {
        String repositoryName = WCMCoreUtils.getRepository(null).getConfiguration().getName();
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        List<DriveData> listDriver = this.getDriversByUserId(repositoryName, userId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("Connector");
        document.appendChild(rootElement);
        rootElement.setAttribute("isUpload", "false");
        rootElement.appendChild(this.appendDrivers(document, this.generalDrivers(listDriver), "General Drives", lang));
        rootElement.appendChild(this.appendDrivers(document, this.groupDrivers(listDriver, userId), "Group Drives", lang));
        rootElement.appendChild(this.appendDrivers(document, this.personalDrivers(listDriver, userId), "Personal Drives", lang));
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getFoldersAndFiles(@QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="filterBy") String filterBy) throws Exception {
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            ManageDriveService manageDriveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
            String driverHomePath = manageDriveService.getDriveByName(driverName, repositoryName).getHomePath();
            String itemPath = driverHomePath + (currentFolder != null && !"".equals(currentFolder) && !driverHomePath.endsWith("/") ? "/" : "") + currentFolder;
            ConversationState conversationState = ConversationState.getCurrent();
            String userId = conversationState.getIdentity().getUserId();
            itemPath = StringUtils.replaceOnce((String)itemPath, (String)"${userId}", (String)userId);
            Node node = (Node)session.getItem(itemPath);
            return this.buildXMLResponseForChildren(node, null, repositoryName, filterBy, session, currentPortal);
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getFoldersAndFiles: ", (Throwable)e);
            return Response.ok().build();
        }
    }

    @POST
    @Path(value="/uploadFile/upload/")
    public Response uploadFile(InputStream inputStream, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="uploadId") String uploadId, @QueryParam(value="language") String language, @HeaderParam(value="content-type") String contentType, @HeaderParam(value="content-length") String contentLength) throws Exception {
        Node currentFolderNode = this.getParentFolderNode(repositoryName, workspaceName, driverName, currentFolder);
        return this.createUploadFileResponse(inputStream, repositoryName, workspaceName, currentFolderNode, currentPortal, jcrPath, uploadId, language, contentType, contentLength, this.limit);
    }

    @GET
    @Path(value="/uploadFile/control/")
    public Response processUpload(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String siteName, @QueryParam(value="userId") String userId, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="action") String action, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName, @QueryParam(value="uploadId") String uploadId) throws Exception {
        try {
            Node currentFolderNode = this.getParentFolderNode(repositoryName, workspaceName, driverName, currentFolder);
            return this.createProcessUploadResponse(repositoryName, workspaceName, currentFolderNode, siteName, userId, jcrPath, action, language, fileName, uploadId);
        }
        catch (Exception e) {
            log.error((Object)"Error when perform processUpload: ", (Throwable)e);
            return Response.ok().build();
        }
    }

    private List<DriveData> getDriversByUserId(String repoName, String userId) throws Exception {
        String[] allPermission;
        ManageDriveService driveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        List<String> userRoles = this.getMemberships(userId);
        List allDrives = driveService.getAllDrives(repoName);
        HashSet<DriveData> temp = new HashSet<DriveData>();
        if (userId != null) {
            block0: for (DriveData driveData : allDrives) {
                allPermission = driveData.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : userRoles) {
                        if (!driveData.hasPermission(allPermission, rolse)) continue;
                        temp.add(driveData);
                        continue block1;
                    }
                }
            }
        } else {
            block3: for (DriveData driveData : allDrives) {
                for (String permission : allPermission = driveData.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    temp.add(driveData);
                    continue block3;
                }
            }
        }
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            driveList.add((DriveData)iterator.next());
        }
        Collections.sort(driveList);
        return driveList;
    }

    private Element appendDrivers(Document document, List<DriveData> driversList, String groupName, String lang) throws Exception {
        Element folders = document.createElement("Folders");
        folders.setAttribute("name", this.resolveDriveLabel(groupName, lang));
        folders.setAttribute("isUpload", "false");
        for (DriveData driver : driversList) {
            String repository = WCMCoreUtils.getRepository(null).getConfiguration().getName();
            String workspace = driver.getWorkspace();
            String path = driver.getHomePath();
            String name = driver.getName();
            Element folder = document.createElement("Folder");
            NodeLocation nodeLocation = new NodeLocation(repository, workspace, path);
            Node driverNode = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
            folder.setAttribute("name", name);
            folder.setAttribute("label", this.resolveDriveLabel(name, lang));
            folder.setAttribute("url", FCKUtils.createWebdavURL(driverNode));
            folder.setAttribute("folderType", "exo:drive");
            folder.setAttribute("path", path);
            folder.setAttribute("repository", repository);
            folder.setAttribute("workspace", workspace);
            folder.setAttribute("isUpload", "true");
            folders.appendChild(folder);
        }
        return folders;
    }

    private String resolveDriveLabel(String name, String lang) {
        for (String resourceBundleName : this.resourceBundleNames) {
            try {
                ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle(resourceBundleName, new Locale(lang));
                return resourceBundle.getString("ContentSelector.title." + name.replaceAll(" ", ""));
            }
            catch (MissingResourceException e) {
            }
        }
        return name;
    }

    private List<DriveData> personalDrivers(List<DriveData> driveList, String userId) {
        ArrayList<DriveData> personalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        for (DriveData drive : driveList) {
            String driveHomePath = StringUtils.replaceOnce((String)drive.getHomePath(), (String)"${userId}", (String)userId);
            if (!driveHomePath.startsWith(userPath + "/" + userId)) continue;
            drive.setHomePath(driveHomePath);
            personalDrivers.add(drive);
        }
        Collections.sort(personalDrivers);
        return personalDrivers;
    }

    private List<DriveData> groupDrivers(List<DriveData> driverList, String userId) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        ArrayList<DriveData> groupDrivers = new ArrayList<DriveData>();
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        List<String> groups = this.getGroups(userId);
        block0: for (DriveData drive : driverList) {
            if (!drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrivers.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrivers);
        return groupDrivers;
    }

    private List<DriveData> generalDrivers(List<DriveData> driverList) throws Exception {
        ArrayList<DriveData> generalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driverList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrivers.add(drive);
        }
        return generalDrivers;
    }

    private List<String> getMemberships(String userId) throws Exception {
        ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)this.manager);
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Membership membership = (Membership)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroupId();
            userMemberships.add(role);
        }
        ((ComponentRequestLifecycle)this.organizationService).endRequest((ExoContainer)this.manager);
        return userMemberships;
    }

    private List<String> getGroups(String userId) throws Exception {
        ((ComponentRequestLifecycle)this.organizationService).startRequest((ExoContainer)this.manager);
        ArrayList<String> groupList = new ArrayList<String>();
        Collection groups = this.organizationService.getGroupHandler().findGroupsOfUser(userId);
        Object[] objects = groups.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Group group = (Group)objects[i];
            String groupPath = null;
            groupPath = group.getParentId() == null || group.getParentId().length() == 0 ? "/" + group.getGroupName() : group.getParentId() + "/" + group.getGroupName();
            groupList.add(groupPath);
        }
        return groupList;
    }

    private Response buildXMLResponseForChildren(Node node, String command, String repositoryName, String filterBy, Session session, String currentPortal) throws Exception {
        Element rootElement = FCKUtils.createRootElement(command, node, this.folderHandler.getFolderType(node));
        NodeList nodeList = rootElement.getElementsByTagName("CurrentFolder");
        Element currentFolder = (Element)nodeList.item(0);
        currentFolder.setAttribute("isUpload", "true");
        Document document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Folders");
        folders.setAttribute("isUpload", "true");
        Element files = document.createElement("Files");
        files.setAttribute("isUpload", "true");
        Node sourceNode = null;
        Node checkNode = null;
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            String fileType = null;
            if (child.isNodeType(FCKUtils.EXO_HIDDENABLE)) continue;
            if (child.isNodeType("exo:symlink") && child.hasProperty("exo:uuid")) {
                sourceNode = session.getNodeByUUID(child.getProperty("exo:uuid").getString());
            }
            Node node2 = checkNode = sourceNode != null ? sourceNode : child;
            if (this.isFolder(checkNode)) {
                Element folder = this.createFolderElement(document, checkNode, checkNode.getPrimaryNodeType().getName(), child.getName());
                folders.appendChild(folder);
            }
            if (FILE_TYPE_WEBCONTENT.equals(filterBy) && (checkNode.isNodeType("exo:webContent") || checkNode.isNodeType("exo:article"))) {
                fileType = FILE_TYPE_WEBCONTENT;
            }
            if (FILE_TYPE_MEDIAS.equals(filterBy) && this.isMediaType(checkNode, repositoryName)) {
                fileType = FILE_TYPE_MEDIAS;
            }
            if (FILE_TYPE_DMSDOC.equals(filterBy) && this.isDMSDocument(checkNode, repositoryName)) {
                fileType = FILE_TYPE_DMSDOC;
            }
            if (fileType == null) continue;
            Element file = FCKFileHandler.createFileElement(document, fileType, checkNode, child, currentPortal);
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    private boolean isFolder(Node checkNode) throws RepositoryException {
        return checkNode.isNodeType(FCKUtils.NT_UNSTRUCTURED) || checkNode.isNodeType(FCKUtils.NT_FOLDER) || checkNode.isNodeType("exo:taxonomy");
    }

    private boolean isDMSDocument(Node node, String repositoryName) throws Exception {
        TemplateService templateService = (TemplateService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(TemplateService.class);
        List dmsDocumentListTmp = templateService.getDocumentTemplates(repositoryName);
        ArrayList dmsDocumentList = new ArrayList();
        dmsDocumentList.addAll(dmsDocumentListTmp);
        dmsDocumentList.remove("exo:webContent");
        dmsDocumentList.remove("exo:article");
        for (String documentType : dmsDocumentList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType) || this.isMediaType(node, repositoryName) || node.isNodeType("exo:webContent")) continue;
            return true;
        }
        return false;
    }

    private boolean isMediaType(Node node, String repository) {
        String mimeType = "";
        try {
            mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            return false;
        }
        for (String type : MEDIA_MIMETYPE) {
            if (!mimeType.contains(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return null;
    }

    @Override
    protected Node getRootContentStorage(Node node) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getImagesFolder(node);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getImagesFolders(node);
        }
    }

    protected Response createUploadFileResponse(InputStream inputStream, String repositoryName, String workspaceName, Node currentFolderNode, String runningPortalName, String jcrPath, String uploadId, String language, String contentType, String contentLength, int limit) throws Exception {
        return this.fileUploadHandler.upload(uploadId, contentType, Double.parseDouble(contentLength), inputStream, currentFolderNode, language, limit);
    }

    protected Response createProcessUploadResponse(String repositoryName, String workspaceName, Node currentFolderNode, String siteName, String userId, String jcrPath, String action, String language, String fileName, String uploadId) throws Exception {
        if (FileUploadHandler.SAVE_ACTION.equals(action)) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return this.fileUploadHandler.saveAsNTFile(currentFolderNode, uploadId, fileName, language, siteName, userId);
        }
        return this.fileUploadHandler.control(uploadId, action);
    }

    private Node getParentFolderNode(String repositoryName, String workspaceName, String driverName, String currentFolder) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repositoryName);
        Session session = sessionProvider.getSession(workspaceName, manageableRepository);
        ManageDriveService manageDriveService = (ManageDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ManageDriveService.class);
        try {
            return (Node)session.getItem(manageDriveService.getDriveByName(driverName, repositoryName).getHomePath() + (currentFolder != null && currentFolder.length() != 0 ? "/" : "") + currentFolder);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Element createFolderElement(Document document, Node child, String folderType, String childName) throws Exception {
        Element folder = document.createElement("Folder");
        folder.setAttribute("name", childName);
        folder.setAttribute("url", FCKUtils.createWebdavURL(child));
        folder.setAttribute("folderType", folderType);
        folder.setAttribute("path", child.getPath());
        folder.setAttribute("isUpload", "true");
        return folder;
    }
}

