/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.DeploymentAspectManagerFactory;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.http.HttpContext;
import org.jboss.wsf.spi.http.HttpContextFactory;
import org.jboss.wsf.spi.http.HttpServer;

public class DeploymentAspectHttpServer
extends AbstractExtensible
implements HttpServer {
    private Map<String, Deployment> deployments = new HashMap<String, Deployment>();

    public void start() {
    }

    public HttpContext createContext(String contextRoot) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        HttpContext httpContext = ((HttpContextFactory)spiProvider.getSPI(HttpContextFactory.class)).newHttpContext((HttpServer)this, contextRoot);
        return httpContext;
    }

    public void publish(HttpContext context, Endpoint endpoint) {
        String contextRoot = context.getContextRoot();
        Class implClass = this.getImplementorClass(endpoint);
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            DeploymentModelFactory depModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
            Deployment deployment = depModelFactory.newDeployment("endpoint-deployment", implClass.getClassLoader());
            deployment.setRuntimeClassLoader(deployment.getInitialClassLoader());
            Service service = deployment.getService();
            service.setContextRoot(contextRoot);
            org.jboss.wsf.spi.deployment.Endpoint ep = depModelFactory.newEndpoint(implClass.getName());
            service.addEndpoint(ep);
            this.getDeploymentAspectManager().deploy(deployment);
            this.deployments.put(contextRoot, deployment);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    public void destroy(HttpContext context, Endpoint endpoint) {
        String contextRoot = context.getContextRoot();
        try {
            Deployment deployment = this.deployments.remove(contextRoot);
            if (deployment != null) {
                this.getDeploymentAspectManager().undeploy(deployment);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    private DeploymentAspectManager getDeploymentAspectManager() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        DeploymentAspectManagerFactory depManagerFactory = (DeploymentAspectManagerFactory)spiProvider.getSPI(DeploymentAspectManagerFactory.class);
        DeploymentAspectManager depManager = depManagerFactory.getDeploymentAspectManager("WSDeploymentAspectManagerEndpointAPI");
        return depManager;
    }

    private Class getImplementorClass(Endpoint endpoint) {
        Object implementor = endpoint.getImplementor();
        Class<?> implClass = implementor instanceof Class ? (Class<?>)implementor : implementor.getClass();
        return implClass;
    }
}

