/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.attachments.AttachmentsFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedObject;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.attachments.AttachmentMetaData;
import org.jboss.system.server.profileservice.attachments.AttachmentStore;
import org.jboss.system.server.profileservice.attachments.RepositoryAttachmentMetaData;
import org.jboss.system.server.profileservice.attachments.RepositoryAttachmentMetaDataFactory;
import org.jboss.system.server.profileservice.persistence.PersistenceFactory;
import org.jboss.system.server.profileservice.persistence.xml.PersistenceRoot;
import org.jboss.system.server.profileservice.repository.AbstractFileAttachmentsSerializer;
import org.jboss.virtual.VirtualFile;

public class AbstractAttachmentStore
implements AttachmentStore {
    public static final String METADATA_NAME = "metadata";
    private static final Logger log = Logger.getLogger(AbstractAttachmentStore.class);
    private static final VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private final URI attachmentStoreRoot;
    private AbstractFileAttachmentsSerializer serializer;
    private MainDeployerStructure mainDeployer;
    private PersistenceFactory persistenceFactory;

    protected static URI getURI(File root) {
        if (root == null) {
            throw new IllegalArgumentException("Null attachment root.");
        }
        if (root.exists() && !root.isDirectory()) {
            throw new IllegalArgumentException("Attachment root is not a directory.");
        }
        return root.toURI();
    }

    public AbstractAttachmentStore(File root) {
        this(AbstractAttachmentStore.getURI(root));
    }

    public AbstractAttachmentStore(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Null uri.");
        }
        this.attachmentStoreRoot = uri;
    }

    public URI getAttachmentStoreRoot() {
        return this.attachmentStoreRoot;
    }

    public MainDeployerStructure getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployerStructure mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public AbstractFileAttachmentsSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(AbstractFileAttachmentsSerializer serializer) {
        this.serializer = serializer;
    }

    public PersistenceFactory getPersistenceFactory() {
        return this.persistenceFactory;
    }

    public void setPersistenceFactory(PersistenceFactory persistenceFactory) {
        this.persistenceFactory = persistenceFactory;
    }

    public Deployment createDeployment(ProfileDeployment deployment) throws Exception {
        Object mcDeployment = null;
        mcDeployment = deployment.getRoot() == null ? new AbstractDeployment(deployment.getName()) : deploymentFactory.createVFSDeployment(deployment.getRoot());
        Map attachments = deployment.getAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            MutableAttachments predetermined = AttachmentsFactory.createMutableAttachments();
            for (String name : attachments.keySet()) {
                predetermined.addAttachment(name, attachments.get(name));
            }
            mcDeployment.setPredeterminedManagedObjects((Attachments)predetermined);
        }
        return mcDeployment;
    }

    protected RepositoryAttachmentMetaData loadAttachmentMetaData(String relativeDeploymentPath) {
        String fixedMetadataPath = this.getMetaDataPathName(relativeDeploymentPath);
        try {
            return this.getSerializer().loadAttachment(fixedMetadataPath, RepositoryAttachmentMetaData.class);
        }
        catch (Exception e) {
            log.error((Object)("Failed to load attachment metadata from relative path: " + relativeDeploymentPath), (Throwable)e);
            return null;
        }
    }

    public RepositoryAttachmentMetaData loadMetaData(VirtualFile deploymentRoot) throws Exception {
        if (deploymentRoot == null) {
            throw new IllegalArgumentException("Null deployment root.");
        }
        String deploymentPath = this.createRelativeDeploymentPath(deploymentRoot);
        return this.loadAttachmentMetaData(deploymentPath);
    }

    public void removeComponent(String ctx, ManagedComponent comp) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("null deployment ctx name");
        }
        if (comp == null) {
            throw new IllegalArgumentException("null managed component");
        }
        this.saveAttachment(ctx, comp, true);
    }

    public void updateDeployment(String ctx, ManagedComponent comp) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("null deployment ctx name");
        }
        if (comp == null) {
            throw new IllegalArgumentException("null managed component");
        }
        this.saveAttachment(ctx, comp, false);
    }

    public void saveAttachment(String deploymentName, ManagedComponent component, boolean remove) throws Exception {
        VFSDeploymentContext ctx = this.getDeploymentContext(deploymentName);
        if (ctx == null) {
            throw new IllegalStateException("Cannot persist attachment, failed to find deployment: " + deploymentName);
        }
        VirtualFile root = ctx.getRoot();
        String deploymentPath = this.createRelativeDeploymentPath(root);
        RepositoryAttachmentMetaData repositoryMetaData = this.loadAttachmentMetaData(deploymentPath);
        if (repositoryMetaData == null) {
            repositoryMetaData = RepositoryAttachmentMetaDataFactory.createInstance();
            repositoryMetaData.setDeploymentName(root.getName());
        }
        ManagedComponent parent = component;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        ManagedObject managedObject = component.getDeployment().getManagedObject(parent.getName());
        if (managedObject == null && parent instanceof ManagedObject) {
            managedObject = (ManagedObject)parent;
        }
        String attachmentName = managedObject.getAttachmentName();
        List<AttachmentMetaData> attachments = repositoryMetaData.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<AttachmentMetaData>();
            repositoryMetaData.setAttachments(attachments);
        }
        AttachmentMetaData attachment = null;
        for (AttachmentMetaData a : attachments) {
            if (!attachmentName.equals(a.getName())) continue;
            attachment = a;
        }
        if (attachment == null) {
            attachment = new AttachmentMetaData();
            attachments.add(attachment);
        }
        attachment.setName(attachmentName);
        attachment.setClassName(managedObject.getAttachment().getClass().getName());
        String attachmentPath = deploymentPath + attachment.getName();
        PersistenceRoot persistenceRoot = this.getSerializer().loadAttachment(attachmentPath, PersistenceRoot.class);
        persistenceRoot = this.createPersistedMetaData(persistenceRoot, managedObject, component, remove);
        this.getSerializer().saveAttachment(attachmentPath, (Object)persistenceRoot);
        long lastModified = System.currentTimeMillis();
        attachment.setLastModified(lastModified);
        repositoryMetaData.setLastModified(lastModified);
        this.getSerializer().saveAttachment(this.getMetaDataPathName(deploymentPath), (Object)repositoryMetaData);
    }

    protected PersistenceRoot createPersistedMetaData(PersistenceRoot root, ManagedObject managedObject, ManagedComponent component, boolean remove) {
        if (root == null) {
            root = new PersistenceRoot();
        }
        if ((root = remove ? this.persistenceFactory.removeComponent(root, managedObject, component) : this.persistenceFactory.updateComponent(root, managedObject, component)).getName() == null) {
            root.setName(managedObject.getAttachmentName());
        }
        if (root.getClassName() == null) {
            root.setClassName(managedObject.getAttachment().getClass().getName());
        }
        return root;
    }

    public PersistenceRoot loadAttachment(VirtualFile deploymentCtx, AttachmentMetaData attachment) throws Exception {
        if (deploymentCtx == null) {
            throw new IllegalArgumentException("Null deployment root.");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment");
        }
        String deploymentPath = this.createRelativeDeploymentPath(deploymentCtx);
        String attachmentPath = deploymentPath + attachment.getName();
        return this.getSerializer().loadAttachment(attachmentPath, PersistenceRoot.class);
    }

    protected String getMetaDataPathName(String deploymentPath) {
        return deploymentPath.endsWith(File.separator) ? deploymentPath + METADATA_NAME : deploymentPath + File.separator + METADATA_NAME;
    }

    protected String createRelativeDeploymentPath(VirtualFile vf) throws Exception {
        if (vf == null) {
            throw new IllegalStateException("Null deployment.");
        }
        String pathName = vf.toURI().toString();
        String fileName = vf.getName();
        String hash = HashGenerator.createHash(pathName);
        return fileName + "-" + hash + File.separator;
    }

    protected VFSDeploymentContext getDeploymentContext(String name) {
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Null main deployer.");
        }
        DeploymentContext deploymentContext = this.mainDeployer.getDeploymentContext(name);
        if (deploymentContext == null || !(deploymentContext instanceof VFSDeploymentContext)) {
            return null;
        }
        return (VFSDeploymentContext)deploymentContext;
    }

    private static class HashGenerator {
        private static MessageDigest digest;

        private HashGenerator() {
        }

        public static String createHash(String pathName) throws NoSuchAlgorithmException, MalformedURLException, URISyntaxException {
            byte[] bytez;
            StringBuffer buffer = new StringBuffer();
            Formatter f = new Formatter(buffer);
            for (byte b : bytez = HashGenerator.internalCreateHash(pathName)) {
                f.format("%02x", b);
            }
            return f.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static byte[] internalCreateHash(String pathName) throws NoSuchAlgorithmException {
            MessageDigest digest = HashGenerator.getDigest();
            try {
                digest.update(pathName.getBytes());
                byte[] byArray = digest.digest();
                return byArray;
            }
            finally {
                digest.reset();
            }
        }

        public static MessageDigest getDigest() throws NoSuchAlgorithmException {
            if (digest == null) {
                digest = MessageDigest.getInstance("MD5");
            }
            return digest;
        }
    }
}

