/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.sync.TwoPhaseCommitAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSynchronizationAction<T extends SynchronizationActionContext>
implements TwoPhaseCommitAction<T> {
    private Logger log = Logger.getLogger(this.getClass());
    private final ContentModification modification;
    private final T context;
    private boolean cancelled = false;
    private boolean complete = false;
    private State state = State.OPEN;

    protected AbstractSynchronizationAction(T context, ContentModification modification) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (modification == null) {
            throw new IllegalArgumentException("Null modification");
        }
        this.context = context;
        this.modification = modification;
    }

    @Override
    public ContentModification getRepositoryContentModification() {
        return this.modification;
    }

    @Override
    public T getContext() {
        return this.context;
    }

    @Override
    public void cancel() {
        if (this.state == State.OPEN) {
            this.doCancel();
            this.cancelled = true;
            this.state = State.CANCELLED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        if (this.state == State.OPEN) {
            try {
                this.doComplete();
                this.state = State.CLOSED;
            }
            catch (Exception e) {
                this.state = State.ROLLBACK_ONLY;
            }
            finally {
                this.complete = true;
            }
        }
    }

    @Override
    public boolean prepare() {
        boolean result = false;
        switch (this.state) {
            case OPEN: {
                this.complete();
                if (this.state != State.CLOSED) break;
            }
            case CLOSED: {
                result = this.doPrepare();
                if (result) {
                    this.state = State.PREPARED;
                    result = true;
                    break;
                }
                this.state = State.ROLLBACK_ONLY;
                break;
            }
            case PREPARED: 
            case COMMITTED: 
            case ROLLEDBACK: {
                this.log.warn((Object)("Should not call prepare on an item with state " + (Object)((Object)this.state)));
            }
        }
        return result;
    }

    @Override
    public void commit() {
        switch (this.state) {
            case PREPARED: {
                this.doCommit();
                this.state = State.COMMITTED;
                break;
            }
            case OPEN: 
            case CLOSED: 
            case COMMITTED: 
            case ROLLEDBACK: 
            case CANCELLED: 
            case ROLLBACK_ONLY: {
                this.log.warn((Object)("Should not call prepare on an item with state " + (Object)((Object)this.state)));
            }
        }
    }

    @Override
    public void rollback() {
        switch (this.state) {
            case COMMITTED: 
            case ROLLEDBACK: {
                this.log.warn((Object)("Should not call prepare on an item with state " + (Object)((Object)this.state)));
                return;
            }
            case OPEN: {
                this.doRollbackFromOpen();
                break;
            }
            case CANCELLED: {
                this.doRollbackFromCancelled();
                break;
            }
            case ROLLBACK_ONLY: {
                this.doRollbackFromRollbackOnly();
                break;
            }
            case CLOSED: {
                this.doRollbackFromComplete();
                break;
            }
            case PREPARED: {
                this.doRollbackFromPrepared();
            }
        }
        this.state = State.ROLLEDBACK;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public State getState() {
        return this.state;
    }

    protected abstract void doCancel();

    protected abstract void doComplete() throws Exception;

    protected abstract boolean doPrepare();

    protected abstract void doCommit();

    protected abstract void doRollbackFromOpen();

    protected abstract void doRollbackFromCancelled();

    protected abstract void doRollbackFromRollbackOnly();

    protected abstract void doRollbackFromComplete();

    protected abstract void doRollbackFromPrepared();

    protected static RepositoryItemMetadata getMarkedRemovedItem(ContentModification base) {
        RepositoryItemMetadata result = base.getItem();
        if (!result.isRemoved()) {
            result = new RepositoryItemMetadata(result);
            result.setRemoved(true);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        OPEN,
        CANCELLED,
        CLOSED,
        PREPARED,
        COMMITTED,
        ROLLEDBACK,
        ROLLBACK_ONLY;

    }
}

