/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import com.google.inject.Injector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.apache.shindig.common.servlet.GuiceServletContextListener;

public abstract class InjectedServlet
extends HttpServlet {
    protected Injector injector;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        this.injector = (Injector)context.getAttribute("guice-injector");
        if (this.injector == null) {
            throw new UnavailableException("Guice Injector not found! Make sure you registered " + GuiceServletContextListener.class.getName() + " as a listener");
        }
        this.injector.injectMembers((Object)this);
    }
}

