/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.server.inventory.ResourceFactoryServerService;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.util.ReportUtils;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.ResourceFactoryManager;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;

public class DeleteResourceRunner
implements Callable,
Runnable {
    private final Log log = LogFactory.getLog(DeleteResourceRunner.class);
    private ResourceFactoryManager resourceFactoryManager;
    private DeleteResourceFacet facet;
    private int requestId;
    private int resourceId;

    public DeleteResourceRunner(ResourceFactoryManager resourceFactoryManager, DeleteResourceFacet facet, int requestId, int resourceId) {
        this.resourceFactoryManager = resourceFactoryManager;
        this.facet = facet;
        this.requestId = requestId;
        this.resourceId = resourceId;
    }

    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while chaining run to call", (Throwable)e);
        }
    }

    public Object call() throws Exception {
        this.log.info((Object)("Deleting resource from request: " + this.requestId));
        DeleteResourceStatus status = null;
        String errorMessage = null;
        try {
            this.facet.deleteResource();
            PluginContainer.getInstance().getInventoryManager().removeResource(this.resourceId);
            status = DeleteResourceStatus.SUCCESS;
        }
        catch (Throwable t) {
            errorMessage = ReportUtils.getErrorMessageFromThrowable((Throwable)t);
            status = DeleteResourceStatus.FAILURE;
        }
        DeleteResourceResponse response = new DeleteResourceResponse(this.requestId, status, errorMessage);
        ResourceFactoryServerService serverService = this.resourceFactoryManager.getServerService();
        if (serverService != null) {
            try {
                serverService.completeDeleteResourceRequest(response);
            }
            catch (Throwable throwable) {
                this.log.error((Object)("Error received while attempting to complete report for request: " + this.requestId), throwable);
            }
        }
        return response;
    }
}

