/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMIncompleteSequenceBehavior;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMCreateSequenceSerializer
implements RMSerializer {
    private static final AddressingConstants ADDRESSING_CONSTANTS = AddressingBuilder.getAddressingBuilder().newAddressingConstants();
    private static final RMSerializer INSTANCE = new RMCreateSequenceSerializer();

    private RMCreateSequenceSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMCreateSequence o = (RMCreateSequence)object;
        try {
            QName offerQName;
            SOAPElement offerElement;
            SOAPBody soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
            RMConstants wsrmConstants = provider.getConstants();
            QName createSequenceQName = wsrmConstants.getCreateSequenceQName();
            SOAPElement createSequenceElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapBody, createSequenceQName, "soap body");
            QName acksToQName = wsrmConstants.getAcksToQName();
            SOAPElement acksToElement = RMSerializationHelper.getRequiredElement(createSequenceElement, acksToQName, createSequenceQName);
            QName addressQName = ADDRESSING_CONSTANTS.getAddressQName();
            SOAPElement acksToAddressElement = RMSerializationHelper.getRequiredElement(acksToElement, addressQName, acksToQName);
            String acksToAddress = RMSerializationHelper.getRequiredTextContent(acksToAddressElement, addressQName);
            o.setAcksTo(acksToAddress);
            QName expiresQName = wsrmConstants.getExpiresQName();
            SOAPElement expiresElement = RMSerializationHelper.getOptionalElement(createSequenceElement, expiresQName, createSequenceQName);
            if (expiresElement != null) {
                String duration = RMSerializationHelper.getRequiredTextContent(expiresElement, expiresQName);
                o.setExpires(RMHelper.stringToDuration(duration));
            }
            if ((offerElement = RMSerializationHelper.getOptionalElement(createSequenceElement, offerQName = wsrmConstants.getOfferQName(), createSequenceQName)) != null) {
                QName behaviorQName;
                SOAPElement behaviorElement;
                SOAPElement offerExpiresElement;
                RMCreateSequence.RMOffer offer = o.newOffer();
                QName identifierQName = wsrmConstants.getIdentifierQName();
                SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(offerElement, identifierQName, offerQName);
                String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
                offer.setIdentifier(identifier);
                QName endpointQName = wsrmConstants.getEndpointQName();
                SOAPElement endpointElement = RMSerializationHelper.getOptionalElement(offerElement, endpointQName, offerQName);
                if (endpointElement != null) {
                    SOAPElement endpointAddressElement = RMSerializationHelper.getRequiredElement(endpointElement, addressQName, endpointQName);
                    String endpointAddress = RMSerializationHelper.getRequiredTextContent(endpointAddressElement, addressQName);
                    offer.setEndpoint(endpointAddress);
                }
                if ((offerExpiresElement = RMSerializationHelper.getOptionalElement(offerElement, expiresQName, offerQName)) != null) {
                    String duration = RMSerializationHelper.getRequiredTextContent(offerExpiresElement, expiresQName);
                    offer.setExpires(duration);
                }
                if ((behaviorElement = RMSerializationHelper.getOptionalElement(offerElement, behaviorQName = wsrmConstants.getIncompleteSequenceBehaviorQName(), offerQName)) != null) {
                    String behaviorString = RMSerializationHelper.getRequiredTextContent(behaviorElement, behaviorQName);
                    offer.setIncompleteSequenceBehavior(RMIncompleteSequenceBehavior.getValue(behaviorString));
                }
                o.setOffer(offer);
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMCreateSequence o = (RMCreateSequence)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName createSequenceQName = wsrmConstants.getCreateSequenceQName();
            SOAPElement createSequenceElement = soapEnvelope.getBody().addChildElement(createSequenceQName);
            QName acksToQName = wsrmConstants.getAcksToQName();
            QName addressQName = ADDRESSING_CONSTANTS.getAddressQName();
            createSequenceElement.addChildElement(acksToQName).addChildElement(addressQName).setValue(o.getAcksTo());
            if (o.getExpires() != null) {
                QName expiresQName = wsrmConstants.getExpiresQName();
                createSequenceElement.addChildElement(expiresQName).setValue(RMHelper.durationToString(o.getExpires()));
            }
            if (o.getOffer() != null) {
                RMCreateSequence.RMOffer offer = o.getOffer();
                QName offerQName = wsrmConstants.getOfferQName();
                SOAPElement offerElement = createSequenceElement.addChildElement(offerQName);
                QName identifierQName = wsrmConstants.getIdentifierQName();
                offerElement.addChildElement(identifierQName).setValue(offer.getIdentifier());
                if (offer.getEndpoint() != null) {
                    QName endpointQName = wsrmConstants.getEndpointQName();
                    offerElement.addChildElement(endpointQName).addChildElement(addressQName).setValue(offer.getEndpoint());
                }
                if (offer.getExpires() != null) {
                    QName expiresQName = wsrmConstants.getExpiresQName();
                    offerElement.addChildElement(expiresQName).setValue(offer.getExpires());
                }
                if (offer.getIncompleteSequenceBehavior() != null) {
                    RMIncompleteSequenceBehavior behavior = offer.getIncompleteSequenceBehavior();
                    QName behaviorQName = wsrmConstants.getIncompleteSequenceBehaviorQName();
                    SOAPElement behaviorElement = offerElement.addChildElement(behaviorQName);
                    behaviorElement.setValue(behavior.toString());
                }
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

