/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@SequenceGenerator(name="SEQ", sequenceName="RHQ_RESOURCE_SUBCAT_ID_SEQ")
@Table(name="RHQ_RESOURCE_SUBCAT")
@NamedQueries(value={@NamedQuery(name="ResourceSubCategory.findByNameAndPlugin", query="SELECT rsc FROM ResourceSubCategory AS rsc WHERE rsc.name = :name AND rsc.resourceType.plugin = :plugin")})
public class ResourceSubCategory
implements Comparable<ResourceSubCategory>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_NAME_AND_PLUGIN = "ResourceSubCategory.findByNameAndPlugin";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CTIME")
    private Long ctime;
    @Column(name="MTIME")
    private Long mtime;
    @OneToMany(mappedBy="parentSubCategory", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    @OrderBy
    private List<ResourceSubCategory> childSubCategories = new ArrayList<ResourceSubCategory>();
    @JoinColumn(name="PARENT_SUBCATEGORY_ID")
    @ManyToOne
    private ResourceSubCategory parentSubCategory;
    @JoinColumn(name="RESOURCE_TYPE_ID", updatable=false)
    @ManyToOne
    private ResourceType resourceType;

    public ResourceSubCategory() {
    }

    public ResourceSubCategory(String name) {
        assert (name != null);
        this.childSubCategories = new ArrayList<ResourceSubCategory>();
        this.name = name;
        this.mtime = this.ctime = Long.valueOf(System.currentTimeMillis());
    }

    @NotNull
    public Set<ResourceType> findTaggedResourceTypes() {
        ResourceType parentResourceType = this.findParentResourceType();
        TreeSet<ResourceType> taggedResourceTypes = new TreeSet<ResourceType>();
        this.findTaggedResourceTypes(parentResourceType, taggedResourceTypes);
        return taggedResourceTypes;
    }

    private void findTaggedResourceTypes(ResourceType parentResourceType, Collection<ResourceType> taggedResourceTypes) {
        Set<ResourceType> childResourceTypes = parentResourceType.getChildResourceTypes();
        for (ResourceType childResourceType : childResourceTypes) {
            if (this.equals(childResourceType.getSubCategory())) {
                taggedResourceTypes.add(childResourceType);
            }
            this.findTaggedResourceTypes(childResourceType, taggedResourceTypes);
        }
    }

    @NotNull
    public ResourceType findParentResourceType() {
        ResourceSubCategory subCategory;
        for (subCategory = this; subCategory != null && subCategory.getResourceType() == null; subCategory = subCategory.getParentSubCategory()) {
        }
        if (subCategory == null) {
            throw new IllegalStateException(this + " has no parent resource type.");
        }
        return subCategory.getResourceType();
    }

    public boolean isCreatable() {
        for (ResourceType taggedResourceType : this.findTaggedResourceTypes()) {
            if (!taggedResourceType.isCreatable()) continue;
            return true;
        }
        return false;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCtime() {
        return this.ctime;
    }

    @PrePersist
    void onPersist() {
        this.mtime = this.ctime = Long.valueOf(System.currentTimeMillis());
    }

    public long getMtime() {
        return this.mtime;
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public void update(@NotNull ResourceSubCategory newSubCategory) {
        this.displayName = newSubCategory.getDisplayName();
        this.description = newSubCategory.getDescription();
    }

    public void removeChildSubCategory(ResourceSubCategory oldChildSubCategory) {
        oldChildSubCategory.parentSubCategory = null;
        this.childSubCategories.remove(oldChildSubCategory);
    }

    public void addChildSubCategory(ResourceSubCategory childSubCategory) {
        childSubCategory.setParentSubCategory(this);
        this.childSubCategories.add(childSubCategory);
    }

    public List<ResourceSubCategory> getChildSubCategories() {
        return this.childSubCategories;
    }

    public void setChildSubCategories(List<ResourceSubCategory> childSubCategories) {
        this.childSubCategories = childSubCategories;
    }

    public void setParentSubCategory(ResourceSubCategory parentSubCategory) {
        this.parentSubCategory = parentSubCategory;
    }

    public ResourceSubCategory getParentSubCategory() {
        return this.parentSubCategory;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public int compareTo(ResourceSubCategory that) {
        return this.name.compareTo(that.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceSubCategory)) {
            return false;
        }
        ResourceSubCategory that = (ResourceSubCategory)o;
        return this.name.equals(that.getName());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        return result;
    }

    public String toString() {
        return "ResourceSubCategory[id=" + this.id + ", name=" + this.name + "]";
    }
}

