/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.text.NumberFormat;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.DataContainerImpl;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.invocation.CacheInvocationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachePrinter {
    public static String printCacheDetails(Cache c) {
        DataContainer ci = ((CacheInvocationDelegate)c).getDataContainer();
        return ci.printDetails();
    }

    public static String printCacheLockingInfo(Cache c) {
        DataContainerImpl cd = (DataContainerImpl)((CacheInvocationDelegate)c).getDataContainer();
        return cd.printLockInfo();
    }

    public static String printCacheInterceptors(CacheSPI<?, ?> cache) {
        StringBuilder b = new StringBuilder();
        int index = 0;
        b.append("\n");
        for (CommandInterceptor i : cache.getInterceptorChain()) {
            b.append("# ");
            b.append(index);
            b.append(" : ");
            b.append(i);
            b.append("\n");
            ++index;
        }
        return b.toString();
    }

    public static String printInterceptorChain(CommandInterceptor i) {
        StringBuilder sb = new StringBuilder();
        if (i != null) {
            if (i.getNext() != null) {
                sb.append(CachePrinter.printInterceptorChain(i.getNext())).append("\n");
            }
            sb.append("\t>> ");
            sb.append(i.getClass().getName());
        }
        return sb.toString();
    }

    public static String formatHtml(String s) {
        s = s.replaceAll("\r\n", "<br/>");
        s = s.replaceAll("\r", "<br/>");
        s = s.replaceAll("\n", "<br/>");
        s = s.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        s = s.replaceAll(" ", "&nbsp;");
        return s;
    }

    public static String prettyPrint(long millis) {
        if (millis < 1000L) {
            return millis + " milliseconds";
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        double toPrint = (double)millis / 1000.0;
        if (toPrint < 300.0) {
            return nf.format(toPrint) + " seconds";
        }
        if ((toPrint /= 60.0) < 120.0) {
            return nf.format(toPrint) + " minutes";
        }
        return nf.format(toPrint /= 60.0) + " hours";
    }
}

