/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexMerger;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitorListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueueStore;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Recovery;
import org.exoplatform.services.jcr.impl.core.query.lucene.RedoLog;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.VolatileIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiIndex
implements IndexerIoModeListener,
IndexUpdateMonitorListener {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.MultiIndex");
    private IndexInfos indexNames;
    private final Set deletable = new HashSet();
    private final List indexes = new ArrayList();
    private final NamespaceMappings nsMappings;
    private final DirectoryManager directoryManager;
    private final Directory indexDir;
    private final SearchIndex handler;
    private VolatileIndex volatileIndex;
    private final IndexUpdateMonitor indexUpdateMonitor;
    private CachingMultiIndexReader multiReader;
    private final DocNumberCache cache;
    private final Object updateMonitor = new Object();
    private boolean redoLogApplied = false;
    private long lastFlushTime;
    private long lastFileSystemFlushTime;
    private final IndexMerger merger;
    private static final Timer FLUSH_TIMER = new Timer(true);
    private TimerTask flushTask;
    private RedoLog redoLog = null;
    private IndexingQueue indexingQueue;
    private final IndexingTree indexingTree;
    private long nextTransactionId = 0L;
    private long currentTransactionId = -1L;
    private boolean reindexing = false;
    private final IndexFormatVersion version;
    private final IndexerIoModeHandler modeHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiIndex(SearchIndex handler, IndexingTree indexingTree, IndexerIoModeHandler modeHandler, IndexInfos indexInfos, IndexUpdateMonitor indexUpdateMonitor) throws IOException {
        this.modeHandler = modeHandler;
        this.indexUpdateMonitor = indexUpdateMonitor;
        this.directoryManager = handler.getDirectoryManager();
        this.indexDir = this.directoryManager.getDirectory(".");
        this.handler = handler;
        this.cache = new DocNumberCache(handler.getCacheSize());
        this.indexingTree = indexingTree;
        this.nsMappings = handler.getNamespaceMappings();
        this.flushTask = null;
        this.indexNames = indexInfos;
        this.indexNames.setDirectory(this.indexDir);
        this.indexNames.read();
        this.lastFileSystemFlushTime = System.currentTimeMillis();
        this.lastFlushTime = System.currentTimeMillis();
        modeHandler.addIndexerIoModeListener(this);
        indexUpdateMonitor.addIndexUpdateMonitorListener(this);
        this.removeDeletable();
        this.merger = new IndexMerger(this);
        this.merger.setMaxMergeDocs(handler.getMaxMergeDocs());
        this.merger.setMergeFactor(handler.getMergeFactor());
        this.merger.setMinMergeDocs(handler.getMinMergeDocs());
        IndexingQueueStore store = new IndexingQueueStore(this.indexDir);
        this.indexingQueue = new IndexingQueue(store);
        HashSet<String> currentNames = new HashSet<String>(this.indexNames.getNames());
        for (String name : currentNames) {
            if (!this.directoryManager.hasDirectory(name)) {
                log.debug("index does not exist anymore: " + name);
                continue;
            }
            PersistentIndex index = new PersistentIndex(name, handler.getTextAnalyzer(), handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager);
            index.setMaxFieldLength(handler.getMaxFieldLength());
            index.setUseCompoundFile(handler.getUseCompoundFile());
            index.setTermInfosIndexDivisor(handler.getTermInfosIndexDivisor());
            this.indexes.add(index);
            this.merger.indexAdded(index.getName(), index.getNumDocuments());
        }
        this.resetVolatileIndex();
        CachingMultiIndexReader reader = this.getIndexReader(handler.isInitializeHierarchyCache());
        try {
            this.version = IndexFormatVersion.getVersion((IndexReader)reader);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            reader.release();
            throw throwable;
        }
        reader.release();
        this.indexingQueue.initialize(this);
        if (modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            this.setReadWrite();
        }
        this.indexNames.setMultiIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numDocs() throws IOException {
        int n;
        if (this.indexNames.size() == 0) {
            return this.volatileIndex.getNumDocuments();
        }
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            n = reader.numDocs();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reader.release();
            throw throwable;
        }
        reader.release();
        return n;
    }

    IndexFormatVersion getIndexFormatVersion() {
        return this.version;
    }

    void createInitialIndex(ItemDataConsumer stateMgr) throws IOException {
        block5: {
            if (this.indexNames.size() == 0) {
                this.reindexing = true;
                try {
                    try {
                        long count = 0L;
                        this.executeAndLog(new Start(-1L));
                        count = this.createIndex(this.indexingTree.getIndexingRoot(), stateMgr, count);
                        this.executeAndLog(new Commit(this.getTransactionId()));
                        log.info("Created initial index for {} nodes", (Object)new Long(count));
                        this.releaseMultiReader();
                        this.scheduleFlushTask();
                    }
                    catch (Exception e) {
                        String msg = "Error indexing workspace";
                        IOException ex = new IOException(msg);
                        ex.initCause(e);
                        throw ex;
                    }
                    Object var6_4 = null;
                    this.reindexing = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.reindexing = false;
                    throw throwable;
                }
            }
            throw new IllegalStateException("Index already present");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update(Collection remove, Collection add) throws IOException {
        Object object;
        if (add.size() > this.handler.getBufferSize()) {
            try {
                this.getIndexReader().release();
            }
            catch (IOException e) {
                log.warn("unable to prepare index reader for queries during update", (Throwable)e);
            }
        }
        Object e = this.updateMonitor;
        synchronized (e) {
            this.indexUpdateMonitor.setUpdateInProgress(true, false);
        }
        boolean flush = false;
        try {
            long transactionId = this.nextTransactionId++;
            this.executeAndLog(new Start(transactionId));
            Iterator it = remove.iterator();
            while (it.hasNext()) {
                this.executeAndLog(new DeleteNode(transactionId, (String)it.next()));
            }
            for (Document doc : add) {
                if (doc == null) continue;
                this.executeAndLog(new AddNode(transactionId, doc));
                flush |= this.checkVolatileCommit();
            }
            this.executeAndLog(new Commit(transactionId));
            if (flush) {
                Object object2 = this.updateMonitor;
                synchronized (object2) {
                    this.indexUpdateMonitor.setUpdateInProgress(true, true);
                }
                this.flush();
            }
            Object var10_11 = null;
            object = this.updateMonitor;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            Object object3 = this.updateMonitor;
            synchronized (object3) {
                this.indexUpdateMonitor.setUpdateInProgress(false, flush);
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
            throw throwable;
        }
        synchronized (object) {
            this.indexUpdateMonitor.setUpdateInProgress(false, flush);
            this.updateMonitor.notifyAll();
            this.releaseMultiReader();
        }
    }

    void addDocument(Document doc) throws IOException {
        this.update(Collections.EMPTY_LIST, Arrays.asList(doc));
    }

    void removeDocument(String uuid) throws IOException {
        this.update(Arrays.asList(uuid), Collections.EMPTY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int removeAllDocuments(String uuid) throws IOException {
        Object object;
        int num;
        Object object2 = this.updateMonitor;
        synchronized (object2) {
            this.indexUpdateMonitor.setUpdateInProgress(true, false);
        }
        try {
            Term idTerm = new Term(FieldNames.UUID, uuid.toString());
            this.executeAndLog(new Start(-1L));
            num = this.volatileIndex.removeDocument(idTerm);
            if (num > 0) {
                this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
            }
            for (int i = 0; i < this.indexes.size(); ++i) {
                PersistentIndex index = (PersistentIndex)this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                int removed = index.removeDocument(idTerm);
                if (removed > 0) {
                    this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
                }
                num += removed;
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
            Object var8_9 = null;
            object = this.updateMonitor;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Object object3 = this.updateMonitor;
            synchronized (object3) {
                this.indexUpdateMonitor.setUpdateInProgress(false, false);
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
            throw throwable;
        }
        synchronized (object) {
            this.indexUpdateMonitor.setUpdateInProgress(false, false);
            this.updateMonitor.notifyAll();
            this.releaseMultiReader();
        }
        return num;
    }

    synchronized IndexReader[] getIndexReaders(String[] indexNames, IndexListener listener) throws IOException {
        HashSet<String> names = new HashSet<String>(Arrays.asList(indexNames));
        HashMap<ReadOnlyIndexReader, PersistentIndex> indexReaders = new HashMap<ReadOnlyIndexReader, PersistentIndex>();
        try {
            for (PersistentIndex index : this.indexes) {
                if (!names.contains(index.getName())) continue;
                indexReaders.put(index.getReadOnlyIndexReader(listener), index);
            }
        }
        catch (IOException e) {
            for (Map.Entry entry : indexReaders.entrySet()) {
                ReadOnlyIndexReader reader = (ReadOnlyIndexReader)entry.getKey();
                try {
                    reader.release();
                }
                catch (IOException ex) {
                    log.warn("Exception releasing index reader: " + ex);
                }
                ((PersistentIndex)entry.getValue()).resetListener();
            }
            throw e;
        }
        return indexReaders.keySet().toArray(new IndexReader[indexReaders.size()]);
    }

    synchronized PersistentIndex getOrCreateIndex(String indexName) throws IOException {
        PersistentIndex index;
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return idx;
        }
        if (this.modeHandler.getMode() == IndexerIoMode.READ_ONLY) {
            throw new UnsupportedOperationException("Can't create index in READ_ONLY mode.");
        }
        if (indexName == null) {
            while (this.directoryManager.hasDirectory(indexName = this.indexNames.newName())) {
            }
        }
        try {
            index = new PersistentIndex(indexName, this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager);
        }
        catch (IOException e) {
            if (!this.directoryManager.delete(indexName)) {
                this.deletable.add(indexName);
            }
            throw e;
        }
        index.setMaxFieldLength(this.handler.getMaxFieldLength());
        index.setUseCompoundFile(this.handler.getUseCompoundFile());
        index.setTermInfosIndexDivisor(this.handler.getTermInfosIndexDivisor());
        this.indexes.add(index);
        return index;
    }

    synchronized boolean hasIndex(String indexName) throws IOException {
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return true;
        }
        return this.directoryManager.hasDirectory(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceIndexes(String[] obsoleteIndexes, PersistentIndex index, Collection deleted) throws IOException {
        if (this.handler.isInitializeHierarchyCache()) {
            long time = System.currentTimeMillis();
            index.getReadOnlyIndexReader(true).release();
            time = System.currentTimeMillis() - time;
            log.debug("hierarchy cache initialized in {} ms", (Object)new Long(time));
        }
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            Object object;
            Object object2 = this.updateMonitor;
            synchronized (object2) {
                this.indexUpdateMonitor.setUpdateInProgress(true, true);
            }
            try {
                if (!this.reindexing) {
                    this.executeAndLog(new Start(-2L));
                }
                HashSet<String> names = new HashSet<String>(Arrays.asList(obsoleteIndexes));
                for (String indexName : names) {
                    if (!this.indexNames.contains(indexName)) continue;
                    this.executeAndLog(new DeleteIndex(this.getTransactionId(), indexName));
                }
                this.executeAndLog(new CreateIndex(this.getTransactionId(), index.getName()));
                this.executeAndLog(new AddIndex(this.getTransactionId(), index.getName()));
                for (Term id : deleted) {
                    index.removeDocument(id);
                }
                index.commit();
                if (!this.reindexing) {
                    this.executeAndLog(new Commit(this.getTransactionId()));
                }
                Object var9_10 = null;
                object = this.updateMonitor;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                Object object3 = this.updateMonitor;
                synchronized (object3) {
                    this.indexUpdateMonitor.setUpdateInProgress(false, true);
                    this.updateMonitor.notifyAll();
                    this.releaseMultiReader();
                }
                throw throwable;
            }
            synchronized (object) {
                this.indexUpdateMonitor.setUpdateInProgress(false, true);
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
        if (this.reindexing) {
            this.attemptDelete();
        }
    }

    public CachingMultiIndexReader getIndexReader() throws IOException {
        return this.getIndexReader(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CachingMultiIndexReader getIndexReader(boolean initCache) throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            if (this.multiReader != null) {
                this.multiReader.acquire();
                return this.multiReader;
            }
            while (this.indexUpdateMonitor.getUpdateInProgress()) {
                try {
                    this.updateMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while waiting to aquire reader");
                }
            }
            if (this.multiReader == null) {
                ArrayList<ReadOnlyIndexReader> readerList = new ArrayList<ReadOnlyIndexReader>();
                for (int i = 0; i < this.indexes.size(); ++i) {
                    PersistentIndex pIdx = (PersistentIndex)this.indexes.get(i);
                    if (!this.indexNames.contains(pIdx.getName())) continue;
                    try {
                        readerList.add(pIdx.getReadOnlyIndexReader(initCache));
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        if (!this.directoryManager.hasDirectory(pIdx.getName())) continue;
                        throw e;
                    }
                }
                readerList.add(this.volatileIndex.getReadOnlyIndexReader());
                ReadOnlyIndexReader[] readers = readerList.toArray(new ReadOnlyIndexReader[readerList.size()]);
                this.multiReader = new CachingMultiIndexReader(readers, this.cache);
            }
            this.multiReader.acquire();
            return this.multiReader;
        }
    }

    VolatileIndex getVolatileIndex() {
        return this.volatileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.modeHandler.getMode().equals((Object)IndexerIoMode.READ_WRITE)) {
            this.merger.dispose();
            MultiIndex multiIndex = this;
            synchronized (multiIndex) {
                if (this.flushTask != null) {
                    this.flushTask.cancel();
                }
                try {
                    this.releaseMultiReader();
                }
                catch (IOException e) {
                    log.error("Exception while closing search index.", (Throwable)e);
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    log.error("Exception while closing search index.", (Throwable)e);
                }
                this.volatileIndex.close();
                for (int i = 0; i < this.indexes.size(); ++i) {
                    ((PersistentIndex)this.indexes.get(i)).close();
                }
                this.indexingQueue.close();
                try {
                    this.indexDir.close();
                }
                catch (IOException e) {
                    log.error("Exception while closing directory.", (Throwable)e);
                }
            }
        }
    }

    NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    Document createDocument(NodeData node) throws RepositoryException {
        return this.handler.createDocument(node, this.nsMappings, this.version);
    }

    Document createDocument(String id) throws RepositoryException {
        ItemData data = this.handler.getContext().getItemStateManager().getItemData(id);
        if (data == null) {
            throw new ItemNotFoundException("Item id=" + id + " not found");
        }
        if (!data.isNode()) {
            throw new RepositoryException("Item with id " + id + " is not a node");
        }
        return this.createDocument((NodeData)data);
    }

    boolean getRedoLogApplied() {
        return this.redoLogApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteIndex(PersistentIndex index) {
        this.indexes.remove(index);
        this.indexNames.removeName(index.getName());
        Set set = this.deletable;
        synchronized (set) {
            log.debug("Moved " + index.getName() + " to deletable");
            this.deletable.add(index.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            this.executeAndLog(new Start(-1L));
            this.commitVolatileIndex();
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                PersistentIndex index = (PersistentIndex)this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                index.commit();
                if (index.getNumDocuments() != 0) continue;
                this.executeAndLog(new DeleteIndex(this.getTransactionId(), index.getName()));
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
            this.indexNames.write();
            this.redoLog.clear();
            this.lastFlushTime = System.currentTimeMillis();
        }
        this.attemptDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMultiReader() throws IOException {
        if (this.multiReader != null) {
            try {
                this.multiReader.release();
                Object var2_1 = null;
                this.multiReader = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.multiReader = null;
                throw throwable;
            }
        }
    }

    private void enqueueUnusedSegments() throws IOException {
        String[] dirNames = this.directoryManager.getDirectoryNames();
        for (int i = 0; i < dirNames.length; ++i) {
            if (!dirNames[i].startsWith("_") || this.indexNames.contains(dirNames[i])) continue;
            this.deletable.add(dirNames[i]);
        }
    }

    private void scheduleFlushTask() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
        }
        FLUSH_TIMER.purge();
        this.flushTask = new TimerTask(){

            public void run() {
                MultiIndex.this.checkIndexingQueue();
                MultiIndex.this.checkFlush();
            }
        };
        FLUSH_TIMER.schedule(this.flushTask, 0L, 1000L);
        this.lastFlushTime = System.currentTimeMillis();
        this.lastFileSystemFlushTime = System.currentTimeMillis();
    }

    private void resetVolatileIndex() throws IOException {
        this.volatileIndex = new VolatileIndex(this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.indexingQueue);
        this.volatileIndex.setUseCompoundFile(this.handler.getUseCompoundFile());
        this.volatileIndex.setMaxFieldLength(this.handler.getMaxFieldLength());
        this.volatileIndex.setBufferSize(this.handler.getBufferSize());
    }

    private long getTransactionId() {
        return this.currentTransactionId;
    }

    private Action executeAndLog(Action a) throws IOException {
        a.execute(this);
        this.redoLog.append(a);
        if (a.getType() == 3 || a.getType() == 6) {
            this.redoLog.flush();
        }
        return a;
    }

    private boolean checkVolatileCommit() throws IOException {
        if (this.volatileIndex.getRamSizeInBytes() >= this.handler.getMaxVolatileIndexSize()) {
            this.commitVolatileIndex();
            return true;
        }
        long volatileTime = System.currentTimeMillis() - this.lastFileSystemFlushTime;
        if (this.handler.getMaxVolatileTime() > 0 && volatileTime >= (long)(this.handler.getMaxVolatileTime() * 1000)) {
            this.commitVolatileIndex();
            return true;
        }
        return false;
    }

    private void commitVolatileIndex() throws IOException {
        if (this.volatileIndex.getNumDocuments() > 0) {
            long time = System.currentTimeMillis();
            CreateIndex create = new CreateIndex(this.getTransactionId(), null);
            this.executeAndLog(create);
            this.executeAndLog(new VolatileCommit(this.getTransactionId(), create.getIndexName()));
            AddIndex add = new AddIndex(this.getTransactionId(), create.getIndexName());
            this.executeAndLog(add);
            this.resetVolatileIndex();
            this.lastFileSystemFlushTime = System.currentTimeMillis();
            time = System.currentTimeMillis() - time;
            log.debug("Committed in-memory index in " + time + "ms.");
        }
    }

    private long createIndex(NodeData node, ItemDataConsumer stateMgr, long count) throws IOException, RepositoryException {
        if (this.indexingTree.isExcluded(node)) {
            return count;
        }
        this.executeAndLog(new AddNode(this.getTransactionId(), node.getIdentifier()));
        if (++count % 100L == 0L) {
            log.info("indexing... {} ({})", (Object)node.getQPath().getAsString(), (Object)new Long(count));
        }
        if (count % 10L == 0L) {
            this.checkIndexingQueue(true);
        }
        this.checkVolatileCommit();
        List<NodeData> children = stateMgr.getChildNodesData(node);
        for (NodeData nodeData : children) {
            NodeData childState = (NodeData)stateMgr.getItemData(nodeData.getIdentifier());
            if (childState == null) {
                this.handler.getOnWorkspaceInconsistencyHandler().handleMissingChildNode(new ItemNotFoundException("Child not found "), this.handler, nodeData.getQPath(), node, nodeData);
            }
            if (nodeData == null) continue;
            count = this.createIndex(nodeData, stateMgr, count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDelete() {
        Set set = this.deletable;
        synchronized (set) {
            Iterator it = this.deletable.iterator();
            while (it.hasNext()) {
                String indexName = (String)it.next();
                if (this.directoryManager.delete(indexName)) {
                    it.remove();
                    continue;
                }
                log.info("Unable to delete obsolete index: " + indexName);
            }
        }
    }

    private void removeDeletable() {
        String fileName = "deletable";
        try {
            if (this.indexDir.fileExists(fileName)) {
                this.indexDir.deleteFile(fileName);
            }
        }
        catch (IOException e) {
            log.warn("Unable to remove file 'deletable'.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkFlush() {
        block13: {
            long idleTime = System.currentTimeMillis() - this.lastFlushTime;
            if (this.handler.getVolatileIdleTime() > 0 && idleTime > (long)(this.handler.getVolatileIdleTime() * 1000)) {
                try {
                    Object object;
                    if (!this.redoLog.hasEntries()) break block13;
                    log.debug("Flushing index after being idle for " + idleTime + " ms.");
                    Object object2 = this.updateMonitor;
                    synchronized (object2) {
                        this.indexUpdateMonitor.setUpdateInProgress(true, true);
                    }
                    try {
                        this.flush();
                        Object var6_5 = null;
                        object = this.updateMonitor;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        Object object3 = this.updateMonitor;
                        synchronized (object3) {
                            this.indexUpdateMonitor.setUpdateInProgress(false, true);
                            this.updateMonitor.notifyAll();
                            this.releaseMultiReader();
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        this.indexUpdateMonitor.setUpdateInProgress(false, true);
                        this.updateMonitor.notifyAll();
                        this.releaseMultiReader();
                    }
                }
                catch (IOException e) {
                    log.error("Unable to commit volatile index", (Throwable)e);
                }
            }
        }
    }

    private synchronized void checkIndexingQueue() {
        this.checkIndexingQueue(false);
    }

    private void checkIndexingQueue(boolean transactionPresent) {
        Document[] docs = this.indexingQueue.getFinishedDocuments();
        HashMap<String, Document> finished = new HashMap<String, Document>();
        for (int i = 0; i < docs.length; ++i) {
            String uuid = docs[i].get(FieldNames.UUID);
            finished.put(uuid, docs[i]);
        }
        if (!finished.isEmpty()) {
            log.info("updating index with {} nodes from indexing queue.", (Object)new Long(finished.size()));
            Iterator<Object> it = finished.keySet().iterator();
            while (it.hasNext()) {
                this.indexingQueue.removeDocument(it.next().toString());
            }
            try {
                if (transactionPresent) {
                    it = finished.keySet().iterator();
                    while (it.hasNext()) {
                        this.executeAndLog(new DeleteNode(this.getTransactionId(), (String)it.next()));
                    }
                    it = finished.values().iterator();
                    while (it.hasNext()) {
                        this.executeAndLog(new AddNode(this.getTransactionId(), (Document)it.next()));
                    }
                } else {
                    this.update(finished.keySet(), finished.values());
                }
            }
            catch (IOException e) {
                log.warn("Failed to update index with deferred text extraction", (Throwable)e);
            }
        }
    }

    public void onChangeMode(IndexerIoMode mode) {
        try {
            switch (mode) {
                case READ_ONLY: {
                    this.setReadOny();
                    break;
                }
                case READ_WRITE: {
                    this.setReadWrite();
                }
            }
        }
        catch (IOException e) {
            log.error("An error occurs while changing of mode " + (Object)((Object)mode), (Throwable)e);
        }
    }

    protected void setReadOny() {
        this.merger.dispose();
        this.flushTask.cancel();
        FLUSH_TIMER.purge();
        this.redoLog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReadWrite() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            this.indexUpdateMonitor.setUpdateInProgress(false, true);
            this.updateMonitor.notifyAll();
            this.releaseMultiReader();
        }
        this.redoLog = new RedoLog(this.indexDir);
        this.redoLogApplied = this.redoLog.hasEntries();
        Recovery.run(this, this.redoLog);
        this.enqueueUnusedSegments();
        this.attemptDelete();
        this.merger.start();
        if (this.redoLogApplied) {
            try {
                this.merger.waitUntilIdle();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flush();
        }
        if (this.indexNames.size() > 0) {
            this.scheduleFlushTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIndexList() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            this.releaseMultiReader();
            HashSet<String> newList = new HashSet<String>(this.indexNames.getNames());
            Iterator iterator = this.indexes.iterator();
            while (iterator.hasNext()) {
                PersistentIndex index = (PersistentIndex)iterator.next();
                String name = index.getName();
                if (!newList.contains(name)) {
                    index.close();
                    iterator.remove();
                    continue;
                }
                newList.remove(name);
            }
            for (String name : newList) {
                if (!this.directoryManager.hasDirectory(name)) {
                    log.debug("index does not exist anymore: " + name);
                    continue;
                }
                PersistentIndex index = new PersistentIndex(name, this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager);
                index.setMaxFieldLength(this.handler.getMaxFieldLength());
                index.setUseCompoundFile(this.handler.getUseCompoundFile());
                index.setTermInfosIndexDivisor(this.handler.getTermInfosIndexDivisor());
                this.indexes.add(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdateInProgressChange(boolean updateInProgress) {
        if (this.modeHandler.getMode() == IndexerIoMode.READ_ONLY && !updateInProgress) {
            try {
                Object object = this.updateMonitor;
                synchronized (object) {
                    this.updateMonitor.notifyAll();
                    this.releaseMultiReader();
                }
            }
            catch (IOException e) {
                log.error("An erro occurs while trying to wake up the sleeping threads", (Throwable)e);
            }
        }
    }

    private static class VolatileCommit
    extends Action {
        private final String targetIndex;

        VolatileCommit(long transactionId, String targetIndex) {
            super(transactionId, 4);
            this.targetIndex = targetIndex;
        }

        static VolatileCommit fromString(long transactionId, String arguments) {
            return new VolatileCommit(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            VolatileIndex volatileIndex = index.getVolatileIndex();
            PersistentIndex persistentIndex = index.getOrCreateIndex(this.targetIndex);
            persistentIndex.copyIndex(volatileIndex);
            index.resetVolatileIndex();
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("VOL_COM");
            logLine.append(' ');
            logLine.append(this.targetIndex);
            return logLine.toString();
        }
    }

    private static class Start
    extends Action {
        Start(long transactionId) {
            super(transactionId, 0);
        }

        static Start fromString(long transactionId, String arguments) {
            return new Start(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.currentTransactionId = this.getTransactionId();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "STR";
        }
    }

    private static class DeleteNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "DEL".length() + 32 + 2;
        private final String uuid;

        DeleteNode(long transactionId, String uuid) {
            super(transactionId, 2);
            this.uuid = uuid;
        }

        static DeleteNode fromString(long transactionId, String arguments) {
            if (arguments.length() != 32) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new DeleteNode(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            String uuidString = this.uuid.toString();
            Document doc = index.indexingQueue.removeDocument(uuidString);
            if (doc != null) {
                Util.disposeDocument(doc);
            }
            Term idTerm = new Term(FieldNames.UUID, uuidString);
            int num = index.volatileIndex.removeDocument(idTerm);
            if (num == 0) {
                for (int i = index.indexes.size() - 1; i >= 0; --i) {
                    PersistentIndex idx = (PersistentIndex)index.indexes.get(i);
                    if (!index.indexNames.contains(idx.getName()) || (num = idx.removeDocument(idTerm)) <= 0) continue;
                    return;
                }
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class DeleteIndex
    extends Action {
        private String indexName;

        DeleteIndex(long transactionId, String indexName) {
            super(transactionId, 7);
            this.indexName = indexName;
        }

        static DeleteIndex fromString(long transactionId, String arguments) {
            return new DeleteIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            for (PersistentIndex idx : index.indexes) {
                if (!idx.getName().equals(this.indexName)) continue;
                idx.close();
                index.deleteIndex(idx);
                break;
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    private static class CreateIndex
    extends Action {
        private String indexName;

        CreateIndex(long transactionId, String indexName) {
            super(transactionId, 5);
            this.indexName = indexName;
        }

        static CreateIndex fromString(long transactionId, String arguments) {
            return new CreateIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            this.indexName = idx.getName();
        }

        public void undo(MultiIndex index) throws IOException {
            if (index.hasIndex(this.indexName)) {
                PersistentIndex idx = index.getOrCreateIndex(this.indexName);
                idx.close();
                index.deleteIndex(idx);
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("CRE_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }

        String getIndexName() {
            return this.indexName;
        }
    }

    private static class Commit
    extends Action {
        Commit(long transactionId) {
            super(transactionId, 3);
        }

        static Commit fromString(long transactionId, String arguments) {
            return new Commit(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.lastFlushTime = System.currentTimeMillis();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "COM";
        }
    }

    private static class AddNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "ADD".length() + 32 + 2;
        private final String uuid;
        private Document doc;

        AddNode(long transactionId, String uuid) {
            super(transactionId, 1);
            this.uuid = uuid;
        }

        AddNode(long transactionId, Document doc) {
            this(transactionId, doc.get(FieldNames.UUID));
            this.doc = doc;
        }

        static AddNode fromString(long transactionId, String arguments) throws IllegalArgumentException {
            if (arguments.length() != 32) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new AddNode(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            if (this.doc == null) {
                try {
                    this.doc = index.createDocument(this.uuid);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            if (this.doc != null) {
                index.volatileIndex.addDocuments(new Document[]{this.doc});
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class AddIndex
    extends Action {
        private String indexName;

        AddIndex(long transactionId, String indexName) {
            super(transactionId, 6);
            this.indexName = indexName;
        }

        static AddIndex fromString(long transactionId, String arguments) {
            return new AddIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            if (!index.indexNames.contains(this.indexName)) {
                index.indexNames.addName(this.indexName);
                index.merger.indexAdded(this.indexName, idx.getNumDocuments());
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    public static abstract class Action {
        static final String START = "STR";
        public static final int TYPE_START = 0;
        static final String ADD_NODE = "ADD";
        public static final int TYPE_ADD_NODE = 1;
        static final String DELETE_NODE = "DEL";
        public static final int TYPE_DELETE_NODE = 2;
        static final String COMMIT = "COM";
        public static final int TYPE_COMMIT = 3;
        static final String VOLATILE_COMMIT = "VOL_COM";
        public static final int TYPE_VOLATILE_COMMIT = 4;
        static final String CREATE_INDEX = "CRE_IDX";
        public static final int TYPE_CREATE_INDEX = 5;
        static final String ADD_INDEX = "ADD_IDX";
        public static final int TYPE_ADD_INDEX = 6;
        static final String DELETE_INDEX = "DEL_IDX";
        public static final int TYPE_DELETE_INDEX = 7;
        static final long INTERNAL_TRANSACTION = -1L;
        static final long INTERNAL_TRANS_REPL_INDEXES = -2L;
        private final long transactionId;
        private final int type;

        Action(long transactionId, int type) {
            this.transactionId = transactionId;
            this.type = type;
        }

        long getTransactionId() {
            return this.transactionId;
        }

        int getType() {
            return this.type;
        }

        public abstract void execute(MultiIndex var1) throws IOException;

        public void undo(MultiIndex index) throws IOException {
        }

        public abstract String toString();

        static Action fromString(String line) throws IllegalArgumentException {
            Action a;
            long transactionId;
            int endTransIdx = line.indexOf(32);
            if (endTransIdx == -1) {
                throw new IllegalArgumentException(line);
            }
            try {
                transactionId = Long.parseLong(line.substring(0, endTransIdx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(line);
            }
            int endActionIdx = line.indexOf(32, endTransIdx + 1);
            if (endActionIdx == -1) {
                endActionIdx = line.length();
            }
            String actionLabel = line.substring(endTransIdx + 1, endActionIdx);
            String arguments = "";
            if (endActionIdx + 1 <= line.length()) {
                arguments = line.substring(endActionIdx + 1);
            }
            if (actionLabel.equals(ADD_NODE)) {
                a = AddNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(ADD_INDEX)) {
                a = AddIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(COMMIT)) {
                a = Commit.fromString(transactionId, arguments);
            } else if (actionLabel.equals(CREATE_INDEX)) {
                a = CreateIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_INDEX)) {
                a = DeleteIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_NODE)) {
                a = DeleteNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(START)) {
                a = Start.fromString(transactionId, arguments);
            } else if (actionLabel.equals(VOLATILE_COMMIT)) {
                a = VolatileCommit.fromString(transactionId, arguments);
            } else {
                throw new IllegalArgumentException(line);
            }
            return a;
        }
    }
}

