/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.loggingmonitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.MalformedObjectNameException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.jboss.logging.appender.DailyRollingFileAppender;
import org.jboss.services.loggingmonitor.LoggingMonitorMBean;
import org.jboss.services.loggingmonitor.LoggingMonitorTimerTask;
import org.jboss.services.loggingmonitor.MonitoredMBean;
import org.jboss.services.loggingmonitor.RolloverPeriod;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LoggingMonitor
extends ServiceMBeanSupport
implements LoggingMonitorMBean {
    public static final String MONITORED_MBEAN_ELEMENT = "monitoredmbean";
    public static final String MBEAN_NAME_ATTRIBUTE = "name";
    public static final String MBEAN_LOGGER_ATTRIBUTE = "logger";
    public static final String MBEAN_ATTRIBUTE_ELEMENT = "attribute";
    public static final String DEFAULT_PATTERN_LAYOUT = "%d %-5p [%c] %m%n";
    private String filename;
    private boolean appendToFile = true;
    private RolloverPeriod rolloverPeriod = new RolloverPeriod("DAY");
    private MonitoredMBean[] monitoredObjects;
    private long monitorPeriod;
    private String patternLayout = "%d %-5p [%c] %m%n";
    private Appender appender;
    private Timer timer;

    public void setFilename(String filename) {
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("Logging monitor's filename can not be null or empty");
        }
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setAppendToFile(boolean appendToFile) {
        this.appendToFile = appendToFile;
    }

    public boolean getAppendToFile() {
        return this.appendToFile;
    }

    public void setRolloverPeriod(String rolloverPeriod) {
        this.rolloverPeriod = new RolloverPeriod(rolloverPeriod);
    }

    public String getRolloverPeriod() {
        return this.rolloverPeriod.toString();
    }

    public void setMonitorPeriod(long monitorPeriod) {
        if (monitorPeriod < 1L) {
            throw new IllegalArgumentException("Logging monitor's monitor period must be a positive, non-zero value");
        }
        this.monitorPeriod = monitorPeriod;
    }

    public long getMonitorPeriod() {
        return this.monitorPeriod;
    }

    public void setPatternLayout(String patternLayout) {
        this.patternLayout = patternLayout;
    }

    public String getPatternLayout() {
        return this.patternLayout;
    }

    public String getRolloverFormat() {
        return this.rolloverPeriod.getRolloverFormat();
    }

    public void setMonitoredObjects(Element monitoredObjects) throws MalformedObjectNameException {
        NodeList monitoredMBeans = monitoredObjects.getElementsByTagName(MONITORED_MBEAN_ELEMENT);
        int mbeanCount = monitoredMBeans.getLength();
        if (mbeanCount < 1) {
            throw this.createMissingElementException(MONITORED_MBEAN_ELEMENT);
        }
        this.monitoredObjects = new MonitoredMBean[mbeanCount];
        for (int i = 0; i < mbeanCount; ++i) {
            Node monitoredMBean = monitoredMBeans.item(i);
            this.monitoredObjects[i] = this.toMonitoredMBean((Element)monitoredMBean);
        }
    }

    protected void startService() {
        if (this.monitoredObjects == null) {
            throw new IllegalStateException("'MonitoredObjects' attribute not configured");
        }
        DailyRollingFileAppender appender = new DailyRollingFileAppender();
        appender.setFile(this.filename);
        appender.setAppend(this.appendToFile);
        appender.setDatePattern(this.rolloverPeriod.getRolloverFormat());
        appender.setLayout((Layout)new PatternLayout(this.patternLayout));
        appender.setThreshold((Priority)Level.INFO);
        appender.activateOptions();
        this.appender = appender;
        for (int i = 0; i < this.monitoredObjects.length; ++i) {
            this.monitoredObjects[i].getLogger().addAppender((Appender)appender);
        }
        LoggingMonitorTimerTask task = new LoggingMonitorTimerTask(this.monitoredObjects, this.log);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)task, 0L, this.monitorPeriod);
        this.log.debug((Object)("Logging monitor started logging to " + this.filename));
    }

    protected void stopService() {
        this.timer.cancel();
        for (int i = 0; i < this.monitoredObjects.length; ++i) {
            this.monitoredObjects[i].getLogger().removeAllAppenders();
        }
        this.appender.close();
        this.log.debug((Object)("Logging monitor stopped logging to " + this.filename));
    }

    private MonitoredMBean toMonitoredMBean(Element element) throws MalformedObjectNameException {
        String objectName = element.getAttribute(MBEAN_NAME_ATTRIBUTE);
        if ("".equals(objectName)) {
            throw this.createAttributeNotFoundException(MBEAN_NAME_ATTRIBUTE);
        }
        String loggerName = element.getAttribute(MBEAN_LOGGER_ATTRIBUTE);
        if ("".equals(loggerName)) {
            throw this.createAttributeNotFoundException(MBEAN_LOGGER_ATTRIBUTE);
        }
        Logger logger = Logger.getLogger((String)loggerName.toLowerCase());
        logger.setAdditivity(false);
        logger.setLevel(Level.INFO);
        String[] attributes = this.getMonitoredAttributes(element);
        return new MonitoredMBean(objectName, attributes, logger);
    }

    private String[] getMonitoredAttributes(Element monitoredMBean) {
        NodeList monitoredAttributes = monitoredMBean.getElementsByTagName(MBEAN_ATTRIBUTE_ELEMENT);
        int monitoredAttributesCount = monitoredAttributes.getLength();
        if (monitoredAttributesCount < 1) {
            throw this.createMissingElementException(MBEAN_ATTRIBUTE_ELEMENT);
        }
        String[] attributes = new String[monitoredAttributesCount];
        for (int i = 0; i < monitoredAttributesCount; ++i) {
            Node node = monitoredAttributes.item(i);
            Node attribute = node.getFirstChild();
            if (attribute.getNodeType() != 3) {
                throw new DOMException(3, "Unexpected node type inside <attribute> for monitored MBean.");
            }
            attributes[i] = ((Text)attribute).getData().trim();
        }
        return attributes;
    }

    private DOMException createMissingElementException(String element) {
        return new DOMException(8, "At least one <" + element + "> element is expected");
    }

    private DOMException createAttributeNotFoundException(String attribute) {
        return new DOMException(8, "Missing expected '" + attribute + "' attribute of a <monitoredmbean> element");
    }
}

