/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.text.unicode;

import java.util.BitSet;
import org.exoplatform.services.text.unicode.IntHashtable;
import org.exoplatform.services.text.unicode.IntStringHashtable;

public class NormalizerData {
    public static final int NOT_COMPOSITE = 65535;
    private IntHashtable canonicalClass;
    private IntStringHashtable decompose;
    private IntHashtable compose;
    private BitSet isCompatibility = new BitSet();
    private BitSet isExcluded = new BitSet();

    boolean getExcluded(char ch) {
        return this.isExcluded.get(ch);
    }

    String getRawDecompositionMapping(char ch) {
        return this.decompose.get(ch);
    }

    public int getCanonicalClass(char ch) {
        return this.canonicalClass.get(ch);
    }

    public char getPairwiseComposition(char first, char second) {
        return (char)this.compose.get(first << 16 | second);
    }

    public void getRecursiveDecomposition(boolean canonical, char ch, StringBuilder buffer) {
        String decomp = this.decompose.get(ch);
        if (decomp == null || canonical && this.isCompatibility.get(ch)) {
            buffer.append(ch);
            return;
        }
        for (int i = 0; i < decomp.length(); ++i) {
            this.getRecursiveDecomposition(canonical, decomp.charAt(i), buffer);
        }
    }

    NormalizerData(IntHashtable canonicalClass, IntStringHashtable decompose, IntHashtable compose, BitSet isCompatibility, BitSet isExcluded) {
        this.canonicalClass = canonicalClass;
        this.decompose = decompose;
        this.compose = compose;
        this.isCompatibility = isCompatibility;
        this.isExcluded = isExcluded;
    }
}

