/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.virtual.plugins.context.zip.ZipFileWrapper;

public class ZipEntryInputStream
extends InputStream {
    private InputStream delegate;
    private ZipFileWrapper zipWrapper;
    private boolean closed;

    ZipEntryInputStream(ZipFileWrapper zipWrapper, InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        this.zipWrapper = zipWrapper;
        this.delegate = is;
    }

    private void streamClosed(boolean doClose) {
        if (!this.closed && doClose) {
            this.closed = true;
            this.zipWrapper.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int rc = -1;
        try {
            int n = rc = this.delegate.read();
            this.streamClosed(rc < 0);
            return n;
        }
        catch (Throwable throwable) {
            this.streamClosed(rc < 0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf) throws IOException {
        int rc = -1;
        try {
            int n = rc = this.delegate.read(buf);
            this.streamClosed(rc < 0);
            return n;
        }
        catch (Throwable throwable) {
            this.streamClosed(rc < 0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        int rc = -1;
        try {
            int n = rc = this.delegate.read(buf, off, len);
            this.streamClosed(rc < 0);
            return n;
        }
        catch (Throwable throwable) {
            this.streamClosed(rc < 0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws IOException {
        boolean ok = false;
        try {
            this.delegate.reset();
            ok = true;
            this.streamClosed(!ok);
        }
        catch (Throwable throwable) {
            this.streamClosed(!ok);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mark(int readlimit) {
        boolean ok = false;
        try {
            this.delegate.mark(readlimit);
            ok = true;
            this.streamClosed(!ok);
        }
        catch (Throwable throwable) {
            this.streamClosed(!ok);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        boolean ok = false;
        try {
            int ret = this.delegate.available();
            ok = true;
            int n = ret;
            this.streamClosed(!ok);
            return n;
        }
        catch (Throwable throwable) {
            this.streamClosed(!ok);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n) throws IOException {
        boolean ok = false;
        try {
            long ret = this.delegate.skip(n);
            ok = true;
            long l = ret;
            this.streamClosed(!ok);
            return l;
        }
        catch (Throwable throwable) {
            this.streamClosed(!ok);
            throw throwable;
        }
    }

    public void close() throws IOException {
        this.streamClosed(true);
        super.close();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    boolean isClosed() {
        return this.closed;
    }
}

