/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javassist.scopedpool.ScopedClassPoolFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.aop.ClassLoaderValidation;
import org.jboss.aop.ClassicWeavingStrategy;
import org.jboss.aop.Deployment;
import org.jboss.aop.SuperClassesFirstWeavingStrategy;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.annotation.PortableAnnotationElement;
import org.jboss.aop.asintegration.JBossIntegration;
import org.jboss.aop.asintegration.core.SecurityActions;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.hook.JDK14Transformer;
import org.jboss.aop.hook.JDK14TransformerManager;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AspectManagerServiceDelegate {
    Logger log = Logger.getLogger(AspectManagerServiceDelegate.class);
    protected File tmpClassesDir;
    protected boolean enableTransformer = false;
    protected boolean enableLoadtimeWeaving = false;
    protected boolean suppressTransformationErrors = true;
    protected boolean suppressReferenceErrors = true;
    protected String exclude;
    protected String include;
    protected String ignore;
    protected String includedInvisibleAnnotations;
    private String bootstrapXml;
    private String baseXml;
    private boolean deployedBaseXml;
    private boolean useBaseXml;
    boolean registerHappensAfterStart;
    private JBossIntegration integration;
    private boolean started;
    private AspectManager manager;

    public void setBootstrapXml(String bootstrapXml) {
        this.bootstrapXml = bootstrapXml;
    }

    public void setBaseXml(String baseXml) {
        this.baseXml = baseXml;
    }

    public void setRegisterHappensAfterStart(boolean registerHappensAfterStart) {
        this.registerHappensAfterStart = registerHappensAfterStart;
    }

    public void setAspectManagerMaintainAdvisorInterceptors(boolean maintain) {
        AspectManager.maintainAdvisorMethodInterceptors = maintain;
    }

    public void setAspectManager(AspectManager manager) {
        this.manager = manager;
    }

    public AspectManager getAspectManager() {
        return this.manager;
    }

    public JBossIntegration getJBossIntegration() {
        return this.integration;
    }

    public void setJBossIntegration(JBossIntegration integration) {
        this.integration = integration;
    }

    public ScopedClassPoolFactory createFactory() throws Exception {
        return this.initIntegration().createScopedClassPoolFactory(this.tmpClassesDir);
    }

    public ClassLoaderValidation createClassLoaderValidation() {
        return this.initIntegration();
    }

    protected JBossIntegration initIntegration() {
        if (this.integration == null) {
            throw new IllegalStateException("Integration was not set");
        }
        return this.integration;
    }

    public void create() throws Exception {
        this.initIntegration();
        if (this.started) {
            return;
        }
        PortableAnnotationElement.setClosingDownManager((boolean)false);
        if (this.tmpClassesDir == null) {
            String jbossTmpDir = System.getProperty("jboss.server.temp.dir");
            if (jbossTmpDir == null) {
                jbossTmpDir = System.getProperty("java.io.tmpdir");
            }
            this.tmpClassesDir = new File(jbossTmpDir, "aopdynclasses");
        }
        if (!this.tmpClassesDir.exists() && !this.tmpClassesDir.mkdirs()) {
            throw new FileNotFoundException("Failed to create tmpClassesDir: " + this.tmpClassesDir.getAbsolutePath());
        }
        AspectManager.setClassPoolFactory((ScopedClassPoolFactory)this.createFactory());
        AspectManager.classLoaderValidator = this.createClassLoaderValidation();
        Deployment.searchClasspath = false;
        AspectManager.suppressTransformationErrors = this.suppressTransformationErrors;
        if (this.enableTransformer && this.enableLoadtimeWeaving) {
            throw new RuntimeException("Cannot set both EnableTransformer and EnableLoadtimeWeaving");
        }
        if (this.enableTransformer) {
            this.attachDeprecatedTranslator();
        }
        if (this.enableLoadtimeWeaving) {
            this.attachTranslator();
        }
        AspectManager.setClassLoaderScopingPolicy((AOPClassLoaderScopingPolicy)this.integration.createAOPClassLoaderScopingPolicy());
        this.deployBootstrapXml();
        this.deployBaseXml();
    }

    public void start() throws Exception {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public void destroy() {
        try {
            PortableAnnotationElement.setClosingDownManager((boolean)true);
            this.undeployBaseXml();
        }
        catch (Exception e) {
            this.log.error((Object)"Problem destroying AspectManager", (Throwable)e);
        }
        try {
            this.undeployBootstrapXml();
        }
        catch (Exception e) {
            this.log.error((Object)"Problem destroying AspectManager", (Throwable)e);
        }
    }

    public void deployBaseXml() {
        if (!this.deployedBaseXml && this.useBaseXml) {
            URL base = this.baseXmlUrl();
            try {
                if (base != null) {
                    this.log.debug((Object)("Deploying base aspects " + base));
                    ClassLoader cl = SecurityActions.getClassLoader(this.getClass());
                    AspectXmlLoader.deployXML((URL)base, (ClassLoader)cl, (AspectManager)this.manager);
                    this.deployedBaseXml = true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading " + this.baseXml + " file" + e);
            }
        }
    }

    public void undeployBaseXml() {
        if (this.deployedBaseXml) {
            URL base = this.baseXmlUrl();
            try {
                if (base != null) {
                    this.log.debug((Object)("Undeploying base aspects " + base));
                    AspectXmlLoader.undeployXML((URL)base, (AspectManager)this.manager);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)("Error loading " + this.baseXml + " file" + e));
            }
            this.deployedBaseXml = false;
        }
    }

    private URL baseXmlUrl() {
        if (this.baseXml == null || this.baseXml.trim().length() == 0) {
            return null;
        }
        ClassLoader cl = SecurityActions.getClassLoader(this.getClass());
        URL base = cl.getResource(this.baseXml);
        if (base == null) {
            this.log.debug((Object)("Could not find " + this.baseXml + " file in the resources of " + cl));
        }
        return base;
    }

    private void deployBootstrapXml() {
        try {
            Document doc = this.bootstrapXmlDocument();
            if (doc != null) {
                AspectXmlLoader loader = new AspectXmlLoader();
                loader.setManager(this.manager);
                loader.deployXML(doc, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error deploying bootstrap xml", e);
        }
    }

    private void undeployBootstrapXml() {
        try {
            Document doc = this.bootstrapXmlDocument();
            if (doc != null) {
                AspectXmlLoader loader = new AspectXmlLoader();
                loader.setManager(this.manager);
                loader.undeployXML(doc, null);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Error undeploying bootstrap xml", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document bootstrapXmlDocument() throws IOException, SAXException, ParserConfigurationException {
        if (this.bootstrapXml != null && this.bootstrapXml.trim().length() > 0) {
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(this.bootstrapXml.getBytes()));
            try {
                Document doc;
                Document document = doc = AspectXmlLoader.loadDocument((InputStream)new BufferedInputStream(in));
                return document;
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        return null;
    }

    protected void attachDeprecatedTranslator() {
        this.log.warn((Object)"EnableTransformer has been deprecated, please use EnableLoadtimeWeaving.  See docs for more details");
        this.initIntegration().attachDeprecatedTranslator();
    }

    protected void detachDeprecatedTranslator() {
        this.initIntegration().detachDeprecatedTranslator();
    }

    protected void attachTranslator() {
        JDK14TransformerManager.transformer = new JDK14Transformer(){

            public byte[] transform(ClassLoader loader, String classname, byte[] classBytes) {
                try {
                    return AspectManager.instance((ClassLoader)loader).translate(classname, loader, classBytes);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error converting " + classname + " on " + loader, e);
                }
            }
        };
    }

    protected void detachTranslator() {
        JDK14TransformerManager.transformer = null;
    }

    public boolean getPrune() {
        return AspectManager.getPrune();
    }

    public void setPrune(boolean prune) {
        AspectManager.setPrune((boolean)prune);
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
        ArrayList<String> list = new ArrayList<String>();
        if (exclude != null) {
            StringTokenizer tokenizer = new StringTokenizer(exclude, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        this.manager.setExclude(list);
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
        ArrayList<String> list = new ArrayList<String>();
        if (include != null) {
            StringTokenizer tokenizer = new StringTokenizer(include, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        this.manager.setInclude(list);
    }

    public String getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
        ArrayList<String> list = new ArrayList<String>();
        if (ignore != null) {
            StringTokenizer tokenizer = new StringTokenizer(ignore, ",");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken().trim());
            }
        }
        this.manager.setIgnore(list);
    }

    public String getIncludedInvisibleAnnotations() {
        return this.includedInvisibleAnnotations;
    }

    public void setIncludedInvisibleAnnotations(String ia) {
        ArrayList<String> iiaList = new ArrayList<String>();
        if (ia != null) {
            for (String inc : ia.split(",")) {
                iiaList.add(inc.trim());
            }
        }
        this.manager.setIncludedInvisibleAnnotations(iiaList);
    }

    public File getTmpClassesDir() {
        return this.tmpClassesDir;
    }

    public void setTmpClassesDir(File tmpClassesDir) {
        this.tmpClassesDir = tmpClassesDir;
    }

    public boolean getVerbose() {
        return AspectManager.verbose;
    }

    public void setVerbose(boolean verbose) {
        AspectManager.verbose = verbose;
    }

    public boolean getOptimized() {
        return AspectManager.optimize;
    }

    public void setOptimized(boolean verbose) {
        AspectManager.optimize = verbose;
    }

    public boolean getUseBaseXml() {
        return this.useBaseXml;
    }

    public synchronized void setUseBaseXml(boolean useBaseXml) {
        if (useBaseXml != this.useBaseXml) {
            this.useBaseXml = useBaseXml;
            if (this.started) {
                if (useBaseXml) {
                    this.deployBaseXml();
                } else {
                    this.undeployBaseXml();
                }
            }
        }
    }

    public boolean getSuppressTransformationErrors() {
        return this.suppressTransformationErrors;
    }

    public void setSuppressTransformationErrors(boolean suppressTransformationErrors) {
        this.suppressTransformationErrors = suppressTransformationErrors;
        AspectManager.suppressTransformationErrors = suppressTransformationErrors;
    }

    public boolean getSuppressReferenceErrors() {
        return this.suppressReferenceErrors;
    }

    public void setSuppressReferenceErrors(boolean suppressReferenceErrors) {
        this.suppressReferenceErrors = suppressReferenceErrors;
        AspectManager.suppressReferenceErrors = suppressReferenceErrors;
    }

    public boolean getEnableTransformer() {
        return this.enableTransformer;
    }

    public String interceptorFactories() {
        Map factories = this.manager.getInterceptorFactories();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String aspectDefinitions() {
        Map factories = this.manager.getAspectDefinitions();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String introductions() {
        Map factories = this.manager.getInterfaceIntroductions();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String stacks() {
        Map factories = this.manager.getInterceptorStacks();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            buffer.append(name + "<br>");
        }
        return buffer.toString();
    }

    public String bindings() {
        LinkedHashMap factories = this.manager.getBindings();
        StringBuffer buffer = new StringBuffer("");
        for (String name : factories.keySet()) {
            AdviceBinding binding = (AdviceBinding)factories.get(name);
            StringBuilder detail = new StringBuilder();
            if (binding != null) {
                InterceptorFactory[] ifactories;
                detail.append(binding.getPointcut());
                detail.append("{");
                for (InterceptorFactory ifactory : ifactories = binding.getInterceptorFactories()) {
                    detail.append(ifactory.getName());
                }
                detail.append("}");
            }
            buffer.append("<b>" + name + "</b> - " + detail.toString() + "<br>");
        }
        return buffer.toString();
    }

    public String pointcuts() {
        LinkedHashMap pointcuts = this.manager.getPointcuts();
        StringBuffer buffer = new StringBuffer("");
        for (String name : pointcuts.keySet()) {
            Pointcut pointcut = (Pointcut)pointcuts.get(name);
            buffer.append("<b>" + name + "</b> - " + pointcut + "<br>");
        }
        return buffer.toString();
    }

    public String registeredClassLoaders() {
        Map loaders = AspectManager.getRegisteredCLs();
        StringBuffer buffer = new StringBuffer("");
        for (ClassLoader loader : loaders.keySet()) {
            buffer.append(loader + "<br>");
        }
        return buffer.toString();
    }

    public void setEnableTransformer(boolean enableTransformer) {
        if (this.enableTransformer == enableTransformer) {
            return;
        }
        if (this.enableLoadtimeWeaving && enableTransformer) {
            this.log.warn((Object)"enabledLoadtimeWeaving alread set");
            return;
        }
        if (this.started) {
            if (enableTransformer) {
                this.attachDeprecatedTranslator();
            } else {
                this.detachDeprecatedTranslator();
            }
        }
        this.enableTransformer = enableTransformer;
    }

    public boolean getEnableLoadtimeWeaving() {
        return this.enableLoadtimeWeaving;
    }

    public void setEnableLoadtimeWeaving(boolean enableTransformer) {
        if (this.enableLoadtimeWeaving == enableTransformer) {
            return;
        }
        if (this.enableLoadtimeWeaving && enableTransformer) {
            this.log.warn((Object)"enableTransformer already set");
        }
        if (this.started) {
            if (enableTransformer) {
                this.attachTranslator();
            } else {
                this.detachTranslator();
            }
        }
        this.enableLoadtimeWeaving = enableTransformer;
    }

    public String getInstrumentor() {
        return InstrumentorFactory.getInstrumentorName();
    }

    public void setInstrumentor(String instrumentor) {
        InstrumentorFactory.initialise((String)instrumentor);
    }

    public Logger getLog() {
        return this.log;
    }

    static {
        Class<TransformerCommon> clazz = TransformerCommon.class;
        clazz = SuperClassesFirstWeavingStrategy.class;
        Class<ClassicWeavingStrategy> clazz2 = ClassicWeavingStrategy.class;
    }
}

