/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.listcode;

import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.ftp.listcode.FtpSystemCoder;
import org.exoplatform.services.ftp.listcode.FtpUnixL8Coder;
import org.exoplatform.services.ftp.listcode.FtpWindowsNTCoder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpSystemCoderManager {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ftp.FtpSystemCoderManager");
    private static final String[][] availableSysemCoders = new String[][]{{"Windows_NT", FtpWindowsNTCoder.class.getCanonicalName()}, {"UNIX Type: L8", FtpUnixL8Coder.class.getCanonicalName()}};

    public static FtpSystemCoder getSystemCoder(FtpConfig configuration) {
        String systemType = configuration.getSystemType();
        for (int i = 0; i < availableSysemCoders.length; ++i) {
            if (!systemType.equals(availableSysemCoders[i][0])) continue;
            try {
                FtpSystemCoder coder = (FtpSystemCoder)Class.forName(availableSysemCoders[i][1]).newInstance();
                return coder;
            }
            catch (Exception exc) {
                log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
        return null;
    }
}

