/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPExtensionHandler
implements SOAPHandler<SOAPMessageContext> {
    private static Logger log = LoggerFactory.getLogger(WSRPExtensionHandler.class);
    private boolean debug = false;
    private boolean removeExtensions = true;
    private static final String EXTENSIONS = "extensions";

    public boolean handleMessage(SOAPMessageContext messageContext) {
        this.removeExtensions(messageContext);
        return true;
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public Set<QName> getHeaders() {
        return null;
    }

    private void removeExtensions(SOAPMessageContext msgContext) {
        SOAPMessage soapMessage = msgContext.getMessage();
        try {
            if (this.debug) {
                soapMessage.writeTo((OutputStream)System.out);
            }
            if (this.removeExtensions) {
                SOAPBody soapBody = soapMessage.getSOAPBody();
                this.traverseAndRemoveExtensions((Node)soapBody);
            }
        }
        catch (Exception e) {
            log.error("Error in WSRPExtensionHandler.removeExtensions:", (Throwable)e);
        }
    }

    private void traverseAndRemoveExtensions(Node node) {
        NodeList children = node.getChildNodes();
        int childrenNb = children.getLength();
        for (int i = 0; i < childrenNb; ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType()) continue;
            String name = child.getLocalName();
            if (EXTENSIONS.equals(name)) {
                if (this.debug) {
                    log.debug("Extensions removed on " + name);
                }
                node.removeChild(child);
                break;
            }
            this.traverseAndRemoveExtensions(child);
        }
    }
}

