/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.logging;

import org.gatein.common.logging.LogLevel;

public abstract class Logger {
    private static final Object[] NO_PARAMETERS = null;

    protected abstract void doLog(LogLevel var1, Object var2, Throwable var3);

    protected abstract org.slf4j.Logger getDelegate();

    private void log(LogLevel level, Object msg, Throwable throwable, Object ... parameters) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        if (parameters != null && parameters.length > 0) {
            throw new UnsupportedOperationException("log interpolation to do, for now it cannot be called");
        }
        this.doLog(level, msg, throwable);
    }

    public final String getName() {
        return this.getDelegate().getName();
    }

    public final boolean isEnabled(LogLevel level) {
        if (level == null) {
            level = LogLevel.INFO;
        }
        return level.isEnabled(this.getDelegate());
    }

    public final void log(LogLevel level, Object msg) {
        this.log(level, msg, null, NO_PARAMETERS);
    }

    public final void log(LogLevel level, Object msg, Throwable throwable) {
        this.log(level, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isTraceEnabled() {
        return this.isEnabled(LogLevel.TRACE);
    }

    public final void trace(Object msg) {
        this.log(LogLevel.TRACE, msg, null, NO_PARAMETERS);
    }

    public final void trace(Object msg, Throwable throwable) {
        this.log(LogLevel.TRACE, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isDebugEnabled() {
        return this.isEnabled(LogLevel.DEBUG);
    }

    public final void debug(Object msg) {
        this.log(LogLevel.DEBUG, msg, null, NO_PARAMETERS);
    }

    public final void debug(Object msg, Throwable throwable) {
        this.log(LogLevel.DEBUG, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isInfoEnabled() {
        return this.isEnabled(LogLevel.INFO);
    }

    public final void info(Object msg) {
        this.log(LogLevel.INFO, msg, null, NO_PARAMETERS);
    }

    public final void info(Object msg, Throwable throwable) {
        this.log(LogLevel.INFO, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isWarnEnabled() {
        return this.isEnabled(LogLevel.WARN);
    }

    public final void warn(Object msg) {
        this.log(LogLevel.WARN, msg, null, NO_PARAMETERS);
    }

    public final void warn(Object msg, Throwable throwable) {
        this.log(LogLevel.WARN, msg, throwable, NO_PARAMETERS);
    }

    public final boolean isErrorEnabled() {
        return this.isEnabled(LogLevel.ERROR);
    }

    public final void error(Object msg) {
        this.log(LogLevel.ERROR, msg, null, NO_PARAMETERS);
    }

    public final void error(Object msg, Throwable throwable) {
        this.log(LogLevel.ERROR, msg, throwable, NO_PARAMETERS);
    }

    public String toString() {
        return "Logger[name=" + this.getDelegate().getName() + "]";
    }
}

