/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ConstructorSignature;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.introspector.jlr.AnnotatedParameterImpl;
import org.jboss.webbeans.introspector.jlr.ConstructorSignatureImpl;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.collections.multi.ListHashMultiMap;
import org.jboss.webbeans.util.collections.multi.ListMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedConstructorImpl<T>
extends AbstractAnnotatedMember<T, Constructor<T>>
implements AnnotatedConstructor<T> {
    private final Constructor<T> constructor;
    private final List<AnnotatedParameter<?>> parameters;
    private final ListMultiMap<Class<? extends Annotation>, AnnotatedParameter<?>> annotatedParameters;
    private final AnnotatedType<T> declaringClass;
    private final ConstructorSignature signature;
    private String toString;

    public static <T> AnnotatedConstructor<T> of(Constructor<T> constructor, AnnotatedType<T> declaringClass) {
        return new AnnotatedConstructorImpl<T>(constructor, declaringClass);
    }

    protected AnnotatedConstructorImpl(Constructor<T> constructor, AnnotatedType<T> declaringClass) {
        super(AnnotationStore.of(constructor), constructor, constructor.getDeclaringClass(), constructor.getDeclaringClass());
        this.constructor = constructor;
        this.declaringClass = declaringClass;
        this.parameters = new ArrayList();
        this.annotatedParameters = new ListHashMultiMap();
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            AnnotatedParameter<?> parameter;
            Type type;
            Class<?> clazz;
            if (constructor.getParameterAnnotations()[i].length > 0) {
                clazz = constructor.getParameterTypes()[i];
                type = constructor.getGenericParameterTypes()[i];
                parameter = AnnotatedParameterImpl.of(constructor.getParameterAnnotations()[i], clazz, type, this);
                this.parameters.add(parameter);
                for (Annotation annotation : parameter.getAnnotationsAsSet()) {
                    this.annotatedParameters.put(annotation.annotationType(), parameter);
                }
                continue;
            }
            clazz = constructor.getParameterTypes()[i];
            type = constructor.getGenericParameterTypes().length > i ? constructor.getGenericParameterTypes()[i] : clazz;
            parameter = AnnotatedParameterImpl.of(new Annotation[0], clazz, type, this);
            this.parameters.add(parameter);
            for (Annotation annotation : parameter.getAnnotationsAsSet()) {
                this.annotatedParameters.put(annotation.annotationType(), parameter);
            }
        }
        this.signature = new ConstructorSignatureImpl(this);
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.constructor;
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.constructor;
    }

    @Override
    public List<AnnotatedParameter<?>> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public List<AnnotatedParameter<?>> getAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableList((List)this.annotatedParameters.get(annotationType));
    }

    @Override
    public T newInstance(Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ((Constructor)this.getDelegate()).newInstance(parameters);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof AnnotatedConstructor) {
            AnnotatedConstructor that = (AnnotatedConstructor)other;
            return this.getDeclaringClass().equals(that.getDeclaringClass()) && ((Object)this.getParameters()).equals(that.getParameters());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Constructor)this.getDelegate()).hashCode();
    }

    @Override
    public AnnotatedType<T> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated constructor " + Names.constructorToString(this.constructor);
        return this.toString;
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }
}

