/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloading.spi.dependency.ClassLoadingSpace;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.helpers.NameAndVersionSupport;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.metadata.ExportPackages;
import org.jboss.classloading.spi.metadata.OptionalPackages;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Module
extends NameAndVersionSupport {
    private static Map<ClassLoader, Module> modulesByClassLoader = new ConcurrentHashMap<ClassLoader, Module>();
    private String contextName;
    private List<Capability> capabilities;
    private List<Requirement> requirements;
    private ControllerContext context;
    private Domain domain;
    private ClassLoadingSpace space;
    private List<RequirementDependencyItem> requirementDependencies;

    protected static void registerModuleClassLoader(Module module, ClassLoader classLoader) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        modulesByClassLoader.put(classLoader, module);
    }

    protected static void unregisterModuleClassLoader(Module module, ClassLoader classLoader) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        modulesByClassLoader.remove(classLoader);
    }

    public Module(String name) {
        this(name, name, null);
    }

    public Module(String name, Object version) {
        this(name, name, version);
    }

    public Module(String name, String contextName, Object version) {
        super(name, version);
        if (contextName == null) {
            contextName = name + version.toString();
        }
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    Domain getDomain() {
        return this.domain;
    }

    void setDomain(Domain domain) {
        this.domain = domain;
    }

    Domain checkDomain() {
        Domain result = this.domain;
        if (result == null) {
            throw new IllegalStateException("Domain is not set for " + this);
        }
        return result;
    }

    public boolean isValid() {
        return this.domain != null;
    }

    public String getDomainName() {
        return null;
    }

    public String getDeterminedDomainName() {
        String domainName = this.getDomainName();
        if (domainName == null) {
            domainName = "DefaultDomain";
        }
        return domainName;
    }

    public String getParentDomainName() {
        return null;
    }

    public String getDeterminedParentDomainName() {
        String parentDomain = this.getParentDomainName();
        if (parentDomain == null && !"DefaultDomain".equals(this.getDeterminedDomainName())) {
            return "DefaultDomain";
        }
        return parentDomain;
    }

    ClassLoadingSpace getClassLoadingSpace() {
        return this.space;
    }

    void setClassLoadingSpace(ClassLoadingSpace space) {
        this.space = space;
    }

    public ExportAll getExportAll() {
        return null;
    }

    public ClassFilter getIncluded() {
        return null;
    }

    public ClassFilter getExcluded() {
        return null;
    }

    public ClassFilter getExcludedExport() {
        return null;
    }

    public boolean isImportAll() {
        return false;
    }

    public boolean isJ2seClassLoadingCompliance() {
        return true;
    }

    public ParentPolicy getDeterminedParentPolicy() {
        if (this.isJ2seClassLoadingCompliance()) {
            return ParentPolicy.BEFORE;
        }
        return ParentPolicy.AFTER_BUT_ONLY_JAVA_BEFORE;
    }

    protected boolean isCacheable() {
        return true;
    }

    protected boolean isBlackListable() {
        return true;
    }

    static Module getModuleForClassLoader(ClassLoader cl) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if (cl != null) {
            return modulesByClassLoader.get(cl);
        }
        return null;
    }

    public Module getModuleForClass(String className) throws ClassNotFoundException {
        ClassLoader cl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if ((cl = this.getClassLoaderForClass(className)) != null) {
            return modulesByClassLoader.get(cl);
        }
        return null;
    }

    protected ClassLoader getClassLoaderForClass(String className) throws ClassNotFoundException {
        final Class<?> clazz = this.loadClass(className);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("No classloader for this module " + this);
        }
        return classLoader.loadClass(className);
    }

    public URL getResource(String resourceName) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("No classloader for this module " + this);
        }
        return classLoader.getResource(resourceName);
    }

    public Enumeration<URL> getResources(String resourceName) throws IOException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("No classloader for this module " + this);
        }
        return classLoader.getResources(resourceName);
    }

    protected ClassLoader getClassLoader() {
        return null;
    }

    public void visit(ResourceVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(visitor, visitor.getFilter());
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter) {
        this.visit(visitor, filter, null, new URL[0]);
    }

    public void visit(ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter, URL ... urls) {
        throw new UnsupportedOperationException("The module " + this.getContextName() + " does not support filtering: " + this.getClass().getName());
    }

    public List<? extends DelegateLoader> getDelegates() {
        if (this.requirementDependencies == null || this.requirementDependencies.isEmpty()) {
            return null;
        }
        CopyOnWriteArrayList<DelegateLoader> result = new CopyOnWriteArrayList<DelegateLoader>();
        CopyOnWriteArrayList<DelegateLoader> dynamic = new CopyOnWriteArrayList<DelegateLoader>();
        HashSet<Module> visited = new HashSet<Module>();
        this.addDelegates(this, result, dynamic, visited, false);
        result.addAll(dynamic);
        return result;
    }

    protected List<RequirementDependencyItem> getRequirementDependencyItems() {
        return this.requirementDependencies;
    }

    protected void addDelegates(Module module, List<DelegateLoader> delegates, List<DelegateLoader> dynamic, Set<Module> visited, boolean reExport) {
        if (visited.contains(module)) {
            return;
        }
        visited.add(module);
        List<RequirementDependencyItem> dependencies = module.getRequirementDependencyItems();
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        for (RequirementDependencyItem item : dependencies) {
            Requirement requirement = item.getRequirement();
            if (reExport && !requirement.isReExport()) continue;
            if (!item.isResolved()) {
                throw new IllegalStateException("Item not resolved: " + (Object)((Object)item));
            }
            if (requirement.isDynamic()) {
                DelegateLoader delegate = this.createLazyDelegateLoader(this.checkDomain(), item);
                dynamic.add(delegate);
                continue;
            }
            String name = (String)item.getIDependOn();
            if (name == null) {
                if (requirement.isOptional()) continue;
                throw new IllegalStateException("No iDependOn for item: " + (Object)((Object)item));
            }
            Module iDependOnModule = this.checkDomain().getModule(name);
            if (iDependOnModule == null) {
                throw new IllegalStateException("Module not found with name: " + name);
            }
            Module other = item.getModule();
            DelegateLoader delegate = iDependOnModule.getDelegateLoader(other, requirement);
            if (requirement.wantReExports()) {
                this.addDelegates(iDependOnModule, delegates, dynamic, visited, true);
            }
            if (delegate == null) continue;
            delegates.add(delegate);
        }
    }

    public abstract DelegateLoader createLazyDelegateLoader(Domain var1, RequirementDependencyItem var2);

    public abstract DelegateLoader getDelegateLoader(Module var1, Requirement var2);

    public List<Capability> getCapabilities() {
        if (this.capabilities != null) {
            return this.capabilities;
        }
        List<Capability> capabilities = this.determineCapabilities();
        if (capabilities == null) {
            capabilities = this.defaultCapabilities();
        }
        capabilities = this.checkDomain().mergeGlobalCapabilities(capabilities);
        this.capabilities = capabilities;
        return capabilities;
    }

    protected List<Capability> determineCapabilities() {
        return null;
    }

    protected List<Capability> defaultCapabilities() {
        CopyOnWriteArrayList<Capability> capabilities = new CopyOnWriteArrayList<Capability>();
        ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
        Capability capability = factory.createModule(this.getName(), this.getVersion());
        capabilities.add(capability);
        return capabilities;
    }

    public String[] getPackageNames() {
        List<String> packageNames = this.determinePackageNames(true);
        return packageNames.toArray(new String[packageNames.size()]);
    }

    public List<String> determinePackageNames(boolean optional) {
        List<Requirement> requirements;
        List<String> packageNames = Collections.emptyList();
        List<Capability> capabilities = this.getCapabilities();
        if (capabilities != null && !capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                ExportPackages exported;
                Set<String> exportPackages;
                if (!(capability instanceof ExportPackages) || (exportPackages = (exported = (ExportPackages)((Object)capability)).getPackageNames(this)) == null) continue;
                if (packageNames.isEmpty()) {
                    packageNames = new ArrayList<String>();
                }
                packageNames.addAll(exportPackages);
            }
        }
        if ((requirements = this.getRequirements()) != null && !requirements.isEmpty()) {
            for (Requirement requirement : this.getRequirements()) {
                Set<String> optionalPackages;
                Object exported;
                if (requirement instanceof ExportPackages) {
                    exported = (ExportPackages)((Object)requirement);
                    Set<String> exportPackages = exported.getPackageNames(this);
                    if (!optional && requirement.isOptional() || exportPackages == null || exportPackages.isEmpty()) continue;
                    if (packageNames.isEmpty()) {
                        packageNames = new ArrayList<String>();
                    }
                    packageNames.addAll(exportPackages);
                    continue;
                }
                if (optional || !(requirement instanceof OptionalPackages) || (optionalPackages = (exported = (OptionalPackages)((Object)requirement)).getOptionalPackageNames(this)) == null || packageNames.isEmpty()) continue;
                packageNames.removeAll(optionalPackages);
            }
        }
        return packageNames;
    }

    public ControllerState getClassLoaderState() {
        return ControllerState.INSTALLED;
    }

    public List<Requirement> getRequirements() {
        if (this.requirements != null) {
            return this.requirements;
        }
        List<Requirement> requirements = this.determineRequirements();
        this.requirements = requirements;
        return requirements;
    }

    public List<Requirement> determineRequirements() {
        return Collections.emptyList();
    }

    public URL getDynamicClassRoot() {
        return null;
    }

    List<RequirementDependencyItem> getDependencies() {
        return this.requirementDependencies;
    }

    protected void createDependencies() {
        ControllerState classLoaderState = this.getClassLoaderState();
        List<Requirement> requirements = this.getRequirements();
        if (requirements != null) {
            this.requirementDependencies = new ArrayList<RequirementDependencyItem>();
            for (Requirement requirement : requirements) {
                RequirementDependencyItem item = new RequirementDependencyItem(this, requirement, classLoaderState);
                this.addIDependOn(item);
                this.requirementDependencies.add(item);
            }
        }
    }

    protected void removeDependencies() {
        if (this.requirementDependencies != null && !this.requirementDependencies.isEmpty()) {
            for (RequirementDependencyItem item : this.requirementDependencies) {
                this.removeIDependOn(item);
            }
        }
        this.requirementDependencies = null;
    }

    protected ControllerContext getControllerContext() {
        return this.context;
    }

    protected void setControllerContext(ControllerContext context) {
        this.context = context;
    }

    protected void addIDependOn(RequirementDependencyItem item) {
        if (this.context == null) {
            throw new IllegalStateException("No controller context");
        }
        this.context.getDependencyInfo().addIDependOn((DependencyItem)item);
    }

    protected void removeIDependOn(RequirementDependencyItem item) {
        if (this.context == null) {
            throw new IllegalStateException("No controller context");
        }
        this.context.getDependencyInfo().removeIDependOn((DependencyItem)item);
    }

    protected Module resolveModule(RequirementDependencyItem dependency, boolean resolveSpace) {
        ClassLoadingSpace space = this.getClassLoadingSpace();
        if (resolveSpace && space != null) {
            space.resolve(this);
        }
        Requirement requirement = dependency.getRequirement();
        return this.checkDomain().resolveModule(this, requirement);
    }

    public void release() {
        Domain domain = this.domain;
        if (domain != null) {
            domain.removeModule(this);
        }
        this.reset();
    }

    public void reset() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null) {
            Module.unregisterModuleClassLoader(this, classLoader);
        }
        this.capabilities = null;
        this.requirements = null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Module)) {
            return false;
        }
        return super.equals(obj);
    }
}

